/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.tentackle.common.FileHelper;
import org.tentackle.common.StringHelper;
import org.tentackle.common.ToolRunner;
import org.tentackle.maven.AbstractTentackleMojo;
import org.tentackle.maven.plugin.jlink.ClasspathDependency;
import org.tentackle.maven.plugin.jlink.JLinkResolver;
import org.tentackle.maven.plugin.jlink.ModularArtifact;

public abstract class AbstractJLinkMojo
extends AbstractTentackleMojo {
    public static final String DEST_CLASSPATH = "cp";
    public static final String DEST_MODULEPATH = "mp";
    public static final String DEST_RESOURCES = "conf";
    public static final String ZIP_EXTENSION = "zip";
    @Parameter
    private String mainModule;
    @Parameter(required=true)
    private String mainClass;
    @Parameter
    private List<ClasspathDependency> classpathDependencies;
    @Parameter
    private List<File> extraDirectories;
    @Parameter
    private List<String> extraClasspathElements;
    @Parameter(defaultValue="${project.basedir}/templates")
    private File templateDir;
    @Parameter(property="jdepsTool")
    private File jdepsTool;
    @Parameter(property="jlinkTool")
    private File jlinkTool;
    @Parameter
    private File saveOpts;
    @Parameter
    private boolean withUpdater;
    @Parameter
    private List<String> modulePathOnly;
    @Parameter(defaultValue="${project.build.directory}")
    private File zipDirectory;
    @Parameter(defaultValue="false")
    private boolean stripDebug;
    @Parameter
    private Integer compress;
    @Parameter(defaultValue="false")
    private boolean ignoreSigningInformation;
    @Parameter(defaultValue="false")
    private boolean noHeaderFiles;
    @Parameter(defaultValue="false")
    private boolean noManPages;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File resourcesDirectory;
    @Parameter
    private List<String> addModules;
    @Parameter
    private List<String> excludeModules;
    @Parameter
    private Map<String, Object> variables;
    @Parameter(defaultValue="system, maven, variables", required=true)
    private String variablesPrecedence;
    @Parameter(defaultValue="${project.build.directory}/jlink", required=true)
    private File imageDirectory;
    @Parameter
    private String extraClassifier;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String finalName;
    @Component
    private LocationManager locationManager;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;
    private String javaRuntimeVersion;
    private int javaMajorRuntimeVersion;

    public String getFinalName() {
        return this.finalName;
    }

    public boolean isWithUpdater() {
        return this.withUpdater;
    }

    public boolean isModulePathOnly() {
        if (this.modulePathOnly != null && this.modulePathOnly.size() == 1) {
            String arg = this.modulePathOnly.get(0);
            return "true".equals(arg) || "all".equals(arg) || "*".equals(arg);
        }
        return false;
    }

    public boolean isModulePathOnly(String moduleName) {
        return this.modulePathOnly != null && this.modulePathOnly.contains(moduleName);
    }

    public File getZipDirectory() {
        return this.zipDirectory;
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public File getImageDirectory() {
        return this.imageDirectory;
    }

    public String getMainModule() {
        return this.mainModule;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public LocationManager getLocationManager() {
        return this.locationManager;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public File getJdepsTool() {
        return this.jdepsTool;
    }

    public List<String> getAddModules() {
        return this.addModules == null ? Collections.emptyList() : this.addModules;
    }

    public List<String> getExcludeModules() {
        return this.excludeModules == null ? Collections.emptyList() : this.excludeModules;
    }

    public Map<String, Object> getVariables() {
        return this.variables == null ? Collections.emptyMap() : this.variables;
    }

    public String getVariablesPrecedence() {
        return this.variablesPrecedence;
    }

    public String getExtraClassifier() {
        return this.extraClassifier;
    }

    public List<String> getExtraClasspathElements() {
        return this.extraClasspathElements;
    }

    public List<File> getExtraDirectories() {
        return this.extraDirectories;
    }

    public String getJavaRuntimeVersion() {
        return this.javaRuntimeVersion;
    }

    public int getJavaMajorRuntimeVersion() {
        return this.javaMajorRuntimeVersion;
    }

    public void prepareExecute() throws MojoExecutionException, MojoFailureException {
        if (this.jdepsTool == null) {
            this.jdepsTool = this.getToolFinder().find("jdeps");
        }
        if (this.jlinkTool == null) {
            this.jlinkTool = this.getToolFinder().find("jlink");
        }
    }

    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        JLinkResolver.Result result = new JLinkResolver(this, this.getMavenProject().getArtifacts()).resolve();
        this.createImage(result);
        this.generateFiles(result);
        this.getMavenProject().setArtifact((Artifact)new ProjectArtifact(this.getMavenProject()));
        this.getMavenProject().setPackaging("pom");
    }

    public String getClassifier() throws MojoExecutionException {
        try {
            String classifier = StringHelper.getPlatform() + "-" + StringHelper.getArchitecture();
            if (!StringHelper.isAllWhitespace((String)this.getExtraClassifier())) {
                classifier = classifier + "-" + this.getExtraClassifier();
            }
            return classifier;
        }
        catch (RuntimeException ex) {
            throw new MojoExecutionException(ex.getMessage());
        }
    }

    public String getImagePathPrefix() {
        return "";
    }

    public File createZipFile(File dir, String name) throws MojoExecutionException {
        File zipFile = new File(this.zipDirectory, name + ".zip");
        this.zipArchiver.addDirectory(dir);
        this.zipArchiver.setDestFile(zipFile);
        try {
            this.zipArchiver.createArchive();
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return zipFile;
    }

    public boolean isClasspathDependency(Artifact artifact) {
        if (this.classpathDependencies != null) {
            for (ClasspathDependency classpathDependency : this.classpathDependencies) {
                if (!Objects.equals(classpathDependency.getGroupId(), artifact.getGroupId()) || !Objects.equals(classpathDependency.getArtifactId(), artifact.getArtifactId()) || !Objects.equals(classpathDependency.getClassifier(), artifact.getClassifier())) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void generateFiles(JLinkResolver.Result var1) throws MojoExecutionException;

    protected abstract void installTemplates(boolean var1) throws MojoExecutionException;

    protected void createImage(JLinkResolver.Result result) throws MojoFailureException, MojoExecutionException {
        this.createJLinkImage(result);
        this.copyArtifacts(result);
        this.copyResources(result);
        this.copyExtraDirectories();
    }

    protected void createJLinkImage(JLinkResolver.Result result) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("creating jlink image for a " + (result.isPlainModular() ? "plain " : "") + (result.isModular() ? "modular" : "classpath") + " application with Java " + this.javaRuntimeVersion));
        this.getLog().debug((CharSequence)result.toString());
        ToolRunner jlinkRunner = new ToolRunner(this.jlinkTool);
        if (this.saveOpts != null) {
            jlinkRunner.arg(new Object[]{"--save-opts"}).arg(new Object[]{this.saveOpts});
        }
        jlinkRunner.arg(new Object[]{"--output"}).arg(new Object[]{this.getImageDirectory()});
        if (this.stripDebug) {
            jlinkRunner.arg(new Object[]{"--strip-debug"});
        }
        if (this.compress != null) {
            jlinkRunner.arg(new Object[]{"--compress=" + this.compress});
        }
        if (this.ignoreSigningInformation) {
            jlinkRunner.arg(new Object[]{"--ignore-signing-information"});
        }
        if (this.noHeaderFiles) {
            jlinkRunner.arg(new Object[]{"--no-header-files"});
        }
        if (this.noManPages) {
            jlinkRunner.arg(new Object[]{"--no-man-pages"});
        }
        result.generateJlinkModulePath(jlinkRunner);
        result.generateJlinkModules(jlinkRunner);
        this.getLog().debug((CharSequence)jlinkRunner.toString());
        int errCode = jlinkRunner.run().getErrCode();
        if (errCode != 0) {
            throw new MojoFailureException("jlink failed: " + errCode + "\n" + jlinkRunner.getErrorsAsString() + "\n" + jlinkRunner.getOutputAsString());
        }
    }

    protected void copyArtifacts(JLinkResolver.Result result) throws MojoExecutionException {
        try {
            List<Artifact> classPath;
            File dest;
            List<ModularArtifact> modulePath;
            if (result.isModular() && !(modulePath = result.getModulePath()).isEmpty()) {
                File mpDir = new File(this.getImageDirectory(), DEST_MODULEPATH);
                mpDir.mkdir();
                for (ModularArtifact modularArtifact : modulePath) {
                    dest = new File(mpDir, modularArtifact.getFileName());
                    this.getLog().debug((CharSequence)("copying " + modularArtifact.getPath() + " to " + String.valueOf(mpDir)));
                    FileHelper.copy((File)modularArtifact.getFile(), (File)dest);
                }
            }
            if (!(classPath = result.getClassPath()).isEmpty()) {
                File cpDir = new File(this.getImageDirectory(), DEST_CLASSPATH);
                cpDir.mkdir();
                for (Artifact artifact : classPath) {
                    dest = new File(cpDir, artifact.getFile().getName());
                    this.getLog().debug((CharSequence)("copying " + String.valueOf(artifact.getFile()) + " to " + String.valueOf(cpDir)));
                    FileHelper.copy((File)artifact.getFile(), (File)dest);
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("copying artifacts failed", (Exception)ex);
        }
    }

    protected void copyResources(JLinkResolver.Result result) throws MojoExecutionException {
        int resCount;
        if (this.resourcesDirectory != null && this.resourcesDirectory.isDirectory() && (resCount = this.copyResources(this.resourcesDirectory, new File(this.getImageDirectory(), DEST_RESOURCES))) > 0) {
            result.addToClasspath(DEST_RESOURCES);
        }
    }

    protected void copyExtraDirectories() throws MojoExecutionException {
        try {
            if (this.getExtraDirectories() != null) {
                for (File fromDir : this.getExtraDirectories()) {
                    File toDir = new File(this.getImageDirectory(), fromDir.getName());
                    FileHelper.copyDirectory((File)fromDir, (File)toDir, (boolean)true, null);
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("copying extra directories failed", (Exception)ex);
        }
    }

    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.jdepsTool == null) {
                throw new MojoExecutionException("jdeps tool not found");
            }
            this.getLog().debug((CharSequence)("using " + String.valueOf(this.jdepsTool)));
            this.javaRuntimeVersion = this.determineJavaToolVersion(this.jdepsTool);
            this.javaMajorRuntimeVersion = this.getMajorVersion(this.javaRuntimeVersion);
            if (this.jlinkTool == null) {
                throw new MojoExecutionException("jlink tool not found");
            }
            this.getLog().debug((CharSequence)("using " + String.valueOf(this.jlinkTool)));
            if (this.templateDir.exists()) {
                if (!this.templateDir.isDirectory()) {
                    throw new MojoExecutionException(this.templateDir.getPath() + " is not a directory");
                }
            } else {
                this.getLog().info((CharSequence)("template directory created: " + this.templateDir.getPath()));
            }
            this.installTemplates(false);
            if (this.mainClass == null) {
                throw new MojoExecutionException("mainClass missing");
            }
            return true;
        }
        return false;
    }

    protected void installTemplate(String pluginTemplate, String projectTemplate, boolean overwrite) throws MojoExecutionException {
        this.templateDir.mkdirs();
        File file = new File(this.templateDir, projectTemplate);
        if (overwrite || !file.exists()) {
            String path = "/templates/" + pluginTemplate;
            String text = this.loadResourceFileIntoString(path);
            try (PrintStream ps = new PrintStream(new FileOutputStream(file));){
                ps.print(text);
                this.getLog().info((CharSequence)("installed template " + projectTemplate));
            }
            catch (IOException e) {
                throw new MojoExecutionException("cannot install template " + path, (Exception)e);
            }
        }
    }

    protected void logToolOutput(ToolRunner runner) throws MojoExecutionException {
        String out = runner.getOutputAsString();
        if (!out.isEmpty()) {
            this.getLog().info((CharSequence)out);
        }
    }

    private int copyResources(File srcDir, File dstDir) throws MojoExecutionException {
        try {
            return FileHelper.copyDirectory((File)srcDir, (File)dstDir, (boolean)true, null);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("copying resources failed", (Exception)ex);
        }
    }
}

