/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.AbstractGenerator;
import org.tentackle.maven.GeneratedFile;
import org.tentackle.maven.TemplateModel;
import org.tentackle.maven.plugin.jlink.JLinkResolver;
import org.tentackle.maven.plugin.jlink.JPackageMojo;
import org.tentackle.maven.plugin.jlink.TemplateModelFactory;

public class JPackageGenerator
extends AbstractGenerator {
    private final JPackageMojo mojo;
    private final JLinkResolver.Result result;

    public JPackageGenerator(JPackageMojo mojo, JLinkResolver.Result result) {
        this.mojo = mojo;
        this.result = result;
        this.setTemplateDirectory(mojo.getTemplateDir());
        this.setLogger(mojo.getLog());
    }

    public void generateOptions() throws MojoExecutionException {
        try {
            Configuration cfg = this.createFreemarkerConfiguration();
            TemplateModel model = TemplateModelFactory.getInstance().create(this.mojo, this.result);
            model.putValue("runtimeDir", (Object)this.mojo.getImagePathPrefix());
            File optionsFile = new File(this.mojo.getMavenProject().getBuild().getDirectory(), "jpackage-image.options");
            GeneratedFile generatedFile = new GeneratedFile(cfg, (Map)model, this.mojo.getPackageImageTemplate(), optionsFile);
            generatedFile.generate();
            optionsFile = new File(this.mojo.getMavenProject().getBuild().getDirectory(), "jpackage-installer.options");
            generatedFile = new GeneratedFile(cfg, (Map)model, this.mojo.getPackageInstallerTemplate(), optionsFile);
            generatedFile.generate();
        }
        catch (TemplateException | IOException e) {
            throw new MojoExecutionException("generating jpackage options failed", (Exception)e);
        }
    }

    public void generateUpdateScript(File appImageDir) throws MojoExecutionException {
        try {
            Configuration cfg = this.createFreemarkerConfiguration();
            TemplateModel model = TemplateModelFactory.getInstance().create(this.mojo, this.result);
            if (this.mojo.getPackageUpdateTemplate() != null) {
                File binDir = new File(appImageDir, "bin");
                binDir.mkdirs();
                File scriptFile = new File(binDir, StringHelper.getPlatform().contains("win") ? "update.cmd" : "update.sh");
                GeneratedFile generatedFile = new GeneratedFile(cfg, (Map)model, this.mojo.getPackageUpdateTemplate(), scriptFile);
                generatedFile.generate();
                scriptFile.setExecutable(true);
            }
        }
        catch (TemplateException | IOException e) {
            throw new MojoExecutionException("generating update script failed", (Exception)e);
        }
    }
}

