/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.plugin.jlink.AbstractJLinkMojo;
import org.tentackle.maven.plugin.jlink.ArtifactCreator;
import org.tentackle.maven.plugin.jlink.JLinkGenerator;
import org.tentackle.maven.plugin.jlink.JLinkResolver;

@Mojo(name="jlink", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class JLinkMojo
extends AbstractJLinkMojo {
    public static final String NAME_TEMPLATE = "name.ftl";
    public static final String RUN_TEMPLATE = "run.ftl";
    public static final String UPDATE_TEMPLATE = "update.ftl";
    @Parameter(defaultValue="name.ftl")
    private String nameTemplate;
    @Parameter(defaultValue="run.ftl")
    private String runTemplate;
    @Parameter(defaultValue="update.ftl")
    private String updateTemplate;
    @Parameter(defaultValue="false")
    private boolean noArtifact;

    public String getNameTemplate() {
        return this.nameTemplate;
    }

    public String getRunTemplate() {
        return this.runTemplate;
    }

    public String getUpdateTemplate() {
        return this.isWithUpdater() ? this.updateTemplate : null;
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        super.executeImpl();
        if (!this.noArtifact) {
            ArtifactCreator.getInstance().createAndAttachArtifact(this);
        }
    }

    @Override
    protected void generateFiles(JLinkResolver.Result result) throws MojoExecutionException {
        new JLinkGenerator(this, result).generateScripts();
    }

    @Override
    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (StringHelper.isAllWhitespace((String)this.nameTemplate)) {
                throw new MojoExecutionException("nameTemplate missing");
            }
            if (StringHelper.isAllWhitespace((String)this.runTemplate)) {
                throw new MojoExecutionException("runTemplate missing");
            }
            if (this.isWithUpdater() && StringHelper.isAllWhitespace((String)this.updateTemplate)) {
                throw new MojoExecutionException("updateTemplate missing");
            }
            return true;
        }
        return false;
    }

    @Override
    protected void installTemplates(boolean overwrite) throws MojoExecutionException {
        this.installTemplate(NAME_TEMPLATE, this.nameTemplate, overwrite);
        this.installTemplate(RUN_TEMPLATE, this.runTemplate, overwrite);
        if (this.getUpdateTemplate() != null) {
            this.installTemplate(UPDATE_TEMPLATE, this.getUpdateTemplate(), overwrite);
        }
    }
}

