/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.maven.TemplateModel;
import org.tentackle.maven.plugin.jlink.AbstractJLinkMojo;
import org.tentackle.maven.plugin.jlink.JLinkResolver;
import org.tentackle.maven.plugin.jlink.TemplateModelFactory;

public class DefaultTemplateModelFactory
implements TemplateModelFactory {
    @Override
    public TemplateModel create(AbstractJLinkMojo mojo, JLinkResolver.Result result) throws MojoExecutionException {
        TemplateModel model = new TemplateModel(mojo.getLog());
        StringTokenizer stok = new StringTokenizer(mojo.getVariablesPrecedence(), " \t\r\n,");
        block20: while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            switch (token.toUpperCase()) {
                case "SYSTEM": 
                case "SYS": {
                    model.addProperties(System.getProperties());
                    continue block20;
                }
                case "MAVEN": 
                case "MVN": 
                case "PROPERTIES": 
                case "PROPS": 
                case "POM": {
                    model.addProperties(mojo.getMavenProject().getProperties());
                    continue block20;
                }
                case "VARIABLES": 
                case "VARS": 
                case "VAR": 
                case "EXTRA": 
                case "EXTRAS": 
                case "TEMPLATE": {
                    model.addMap(mojo.getVariables());
                    continue block20;
                }
            }
            throw new MojoExecutionException("unknown variables precedence keyword: " + token);
        }
        model.putValue("phase", (Object)mojo.getMojoExecution().getLifecyclePhase());
        model.putValue("goal", (Object)mojo.getMojoExecution().getGoal());
        model.putValue("id", (Object)mojo.getMojoExecution().getExecutionId());
        model.putValue("mainModule", (Object)mojo.getMainModule());
        model.putValue("mainClass", (Object)mojo.getMainClass());
        model.putValue("modulePath", (Object)result.generateModulePath());
        model.putValue("classPath", (Object)result.generateClassPath());
        return model;
    }
}

