/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.plugin.jlink.AbstractJlinkMojo;
import org.tentackle.maven.plugin.jlink.JlinkResolver;

public class RunTemplateModel
extends HashMap<String, String> {
    private final AbstractJlinkMojo mojo;
    private final JlinkResolver.Result result;

    public RunTemplateModel(AbstractJlinkMojo mojo, JlinkResolver.Result result) throws MojoExecutionException {
        this.mojo = mojo;
        this.result = result;
        this.putValue("mainModule", mojo.getMainModule());
        this.putValue("mainClass", mojo.getMainClass());
        this.putValue("modulePath", result.generateModulePath());
        this.putValue("classPath", result.generateClassPath());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            this.putValue(StringHelper.toCamelCase((String)entry.getKey().toString()), entry.getValue().toString());
        }
        for (Map.Entry<Object, Object> entry : mojo.getMavenProject().getProperties().entrySet()) {
            this.putValue(StringHelper.toCamelCase((String)entry.getKey().toString()), entry.getValue().toString());
        }
    }

    private void putValue(String key, Object value) {
        String val = value == null ? "" : value.toString();
        this.put(key, val);
        this.mojo.getLog().debug((CharSequence)("script variable " + key + " = \"" + val + "\""));
    }
}

