/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.maven.AbstractGenerator;
import org.tentackle.maven.GeneratedFile;
import org.tentackle.maven.GeneratedString;
import org.tentackle.maven.plugin.jlink.AbstractJlinkMojo;
import org.tentackle.maven.plugin.jlink.JlinkResolver;
import org.tentackle.maven.plugin.jlink.RunTemplateModel;

public class RunGenerator
extends AbstractGenerator {
    private final AbstractJlinkMojo mojo;
    private final JlinkResolver.Result result;

    public RunGenerator(AbstractJlinkMojo mojo, JlinkResolver.Result result) {
        this.mojo = mojo;
        this.result = result;
        this.setTemplateDirectory(mojo.getTemplateDir());
    }

    public void generate() throws MojoExecutionException {
        try {
            Configuration cfg = this.createFreemarkerConfiguration();
            RunTemplateModel model = new RunTemplateModel(this.mojo, this.result);
            String output = new GeneratedString(cfg, (Map)model, this.mojo.getNameTemplate()).generate();
            StringTokenizer stok = new StringTokenizer(output);
            if (!stok.hasMoreTokens()) {
                throw new MojoExecutionException("no valid name for runner script");
            }
            File scriptFile = new File(new File(this.mojo.getApplicationDirectory(), "bin"), stok.nextToken());
            GeneratedFile generatedFile = new GeneratedFile(cfg, (Map)model, this.mojo.getRunTemplate(), scriptFile);
            generatedFile.generate();
            scriptFile.setExecutable(true);
        }
        catch (TemplateException | IOException e) {
            throw new MojoExecutionException("generating run script failed", (Exception)e);
        }
    }
}

