/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.tentackle.common.FileHelper;
import org.tentackle.maven.ToolRunner;
import org.tentackle.maven.plugin.jlink.AbstractJlinkMojo;
import org.tentackle.maven.plugin.jlink.JlinkResolver;

@Mojo(name="jpackage", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class JpackageMojo
extends AbstractJlinkMojo {
    @Parameter
    private File jpackageTool;
    @Parameter
    private String packageType;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String applicationName;
    @Parameter
    private String mainJar;
    @Parameter(defaultValue="${project.build.directory}/jpackage", required=true)
    private File imageDirectory;
    @Parameter(defaultValue="${project.build.directory}/artifacts", required=true)
    private File artifactDirectory;
    private File applicationDirectory;

    @Override
    public File getImageDirectory() {
        return this.imageDirectory;
    }

    @Override
    public File getApplicationDirectory() {
        if (this.applicationDirectory == null) {
            this.applicationDirectory = new File(new File(this.imageDirectory, this.applicationName), "runtime");
        }
        return this.applicationDirectory;
    }

    @Override
    public void prepareExecute() throws MojoExecutionException, MojoFailureException {
        super.prepareExecute();
        if (this.jpackageTool == null) {
            this.jpackageTool = this.getToolFinder().find("jpackage");
        }
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.getMavenProject().getProperties().setProperty("goal", "jpackage");
        super.executeImpl();
        ToolRunner jpackageRunner = new ToolRunner(this.jpackageTool);
        jpackageRunner.arg(new Object[]{"create-installer"});
        if (this.packageType != null) {
            jpackageRunner.arg(new Object[]{this.packageType});
        }
        jpackageRunner.arg(new Object[]{"-o"}).arg(new Object[]{this.getImageDirectory()}).arg(new Object[]{"-n"}).arg(new Object[]{this.applicationName}).arg(new Object[]{"--app-image"}).arg(new Object[]{new File(this.getImageDirectory(), this.applicationName)});
        this.getLog().debug((CharSequence)jpackageRunner.toString());
        this.getLog().info((CharSequence)"creating installation package");
        int errCode = jpackageRunner.run().getErrCode();
        if (errCode != 0) {
            throw new MojoFailureException("jpackage failed: " + errCode + "\n" + jpackageRunner.getErrorsAsString() + "\n" + jpackageRunner.getOutputAsString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void createImage(JlinkResolver.Result result) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("creating jpackage image for a " + (result.isPlainModular() ? "plain " : "") + (result.isModular() ? "modular" : "classpath") + " application"));
        this.getLog().debug((CharSequence)result.toString());
        ToolRunner jpackageRunner = new ToolRunner(this.jpackageTool);
        jpackageRunner.arg(new Object[]{"create-image"}).arg(new Object[]{"-o"}).arg(new Object[]{this.imageDirectory}).arg(new Object[]{"-n"}).arg(new Object[]{this.applicationName}).arg(new Object[]{"-c"}).arg(new Object[]{this.getMainClass()});
        if (result.isModular()) {
            if (!result.isPlainModular()) throw new MojoFailureException("jpackage does not support modular applications with non-modular dependencies");
            jpackageRunner.arg(new Object[]{"-m"}).arg(new Object[]{this.getMainModule()});
            result.generateJlinkModulePath(jpackageRunner);
            result.generateJlinkModules(jpackageRunner);
        } else {
            this.copyClasspathArtifacts(result);
            jpackageRunner.arg(new Object[]{"-i"}).arg(new Object[]{this.artifactDirectory});
            jpackageRunner.arg(new Object[]{"-j"}).arg(new Object[]{this.determineMainJar(result)});
        }
        this.getLog().debug((CharSequence)jpackageRunner.toString());
        int errCode = jpackageRunner.run().getErrCode();
        if (errCode == 0) return;
        throw new MojoFailureException("jpackage failed: " + errCode + "\n" + jpackageRunner.getErrorsAsString() + "\n" + jpackageRunner.getOutputAsString());
    }

    @Override
    protected void copyArtifacts(JlinkResolver.Result result) throws MojoExecutionException {
        super.copyArtifacts(result);
    }

    @Override
    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.jpackageTool == null) {
                throw new MojoExecutionException("jpackageTool tool not found");
            }
            this.getLog().debug((CharSequence)("using " + this.jpackageTool));
            if (this.applicationName.contains(" ") || this.applicationName.contains(File.separator)) {
                throw new MojoExecutionException("applicationName must not contain blanks or file separators");
            }
            return true;
        }
        return false;
    }

    private void copyClasspathArtifacts(JlinkResolver.Result result) throws MojoExecutionException {
        try {
            this.artifactDirectory.mkdirs();
            for (Artifact artifact : result.getClassPath()) {
                FileHelper.copy((File)artifact.getFile(), (File)new File(this.artifactDirectory, artifact.getFile().getName()));
            }
        }
        catch (IOException io) {
            throw new MojoExecutionException("copying classpath artifacts failed", (Exception)io);
        }
    }

    private String determineMainJar(JlinkResolver.Result result) throws MojoFailureException {
        String jarName = null;
        if (this.mainJar == null) {
            jarName = result.getClassPath().iterator().next().getFile().getName();
        } else {
            for (Artifact artifact : result.getClassPath()) {
                if (!artifact.getFile().getName().contains(this.mainJar)) continue;
                jarName = artifact.getFile().getName();
                break;
            }
        }
        if (jarName == null) {
            throw new MojoFailureException("cannot determine main jar");
        }
        return jarName;
    }
}

