/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.tentackle.maven.ToolRunner;
import org.tentackle.maven.plugin.jlink.AbstractJlinkMojo;
import org.tentackle.maven.plugin.jlink.ModularArtifact;

public class JlinkResolver {
    private final Set<Artifact> artifacts;
    private final AbstractJlinkMojo mojo;
    private final Map<String, ModularArtifact> automaticModules;
    private final Map<String, ModularArtifact> modules;
    private final Set<String> requiredModules;
    private final Set<String> runtimeModules;
    private final boolean jdeps12AndNewer;

    public JlinkResolver(AbstractJlinkMojo mojo, Set<Artifact> artifacts) throws MojoExecutionException {
        this.artifacts = artifacts;
        this.mojo = mojo;
        this.automaticModules = new LinkedHashMap<String, ModularArtifact>();
        this.modules = new LinkedHashMap<String, ModularArtifact>();
        this.requiredModules = new HashSet<String>();
        this.runtimeModules = new HashSet<String>();
        this.jdeps12AndNewer = !new ToolRunner(mojo.getJdepsTool()).arg(new Object[]{"--version"}).run().getOutputAsString().startsWith("11");
    }

    public Result resolve() throws MojoExecutionException {
        Object moduleName;
        Result result = new Result();
        for (Map.Entry<Artifact, JavaModuleDescriptor> entry : this.loadArtifacts().entrySet()) {
            Artifact artifact = entry.getKey();
            File artifactFile = artifact.getFile();
            JavaModuleDescriptor moduleDescriptor = entry.getValue();
            String moduleName2 = moduleDescriptor.name();
            if (moduleDescriptor.isAutomatic()) {
                if (moduleName2.startsWith("javafx.") && moduleName2.endsWith("Empty")) {
                    this.mojo.getLog().debug((CharSequence)(moduleName2 + " is an automatic dummy javafx module -> skipped"));
                    continue;
                }
                this.mojo.getLog().debug((CharSequence)(moduleName2 + " is an automatic module"));
                this.automaticModules.put(moduleName2, new ModularArtifact(artifact, moduleDescriptor));
                continue;
            }
            this.mojo.getLog().debug((CharSequence)(moduleName2 + " is a full-blown module"));
            this.modules.put(moduleName2, new ModularArtifact(artifact, moduleDescriptor));
            for (JavaModuleDescriptor.JavaRequires requires : moduleDescriptor.requires()) {
                this.addRequired(requires.name());
                this.mojo.getLog().debug((CharSequence)(moduleName2 + " requires " + requires.name()));
            }
        }
        Iterator<String> iter = this.runtimeModules.iterator();
        while (iter.hasNext()) {
            moduleName = iter.next();
            if (this.automaticModules.get(moduleName) == null && this.modules.get(moduleName) == null) continue;
            iter.remove();
            this.requiredModules.add((String)moduleName);
        }
        result.setModular(this.isModularApplication());
        if (result.isModular()) {
            this.mojo.getLog().debug((CharSequence)"building a modular application");
            LinkedHashSet unresolvedModules = new LinkedHashSet();
            for (String string : this.requiredModules) {
                if (this.modules.get(string) != null) continue;
                ModularArtifact artifact = this.automaticModules.get(string);
                if (artifact == null) {
                    throw new MojoExecutionException("required module not found in dependencies: " + string);
                }
                unresolvedModules.add(artifact);
            }
            if (unresolvedModules.isEmpty()) {
                this.mojo.getLog().debug((CharSequence)"YEAH! can build a full-blown modular application!");
                result.addJlinkModules(this.modules.values());
                result.setPlainModular(true);
            } else {
                moduleName = unresolvedModules.iterator();
                while (moduleName.hasNext()) {
                    ModularArtifact modularArtifact = (ModularArtifact)moduleName.next();
                    this.mojo.getLog().info((CharSequence)("required " + modularArtifact + " is not a full-blown module"));
                    result.addToModulePath(modularArtifact);
                }
                this.mojo.getLog().info((CharSequence)"all dependencies moved to module-path for bin/java");
                result.addRuntimeModuleNames(this.runtimeModules);
                for (ModularArtifact modularArtifact : this.modules.values()) {
                    this.addToModuleOrClasspath(modularArtifact, result);
                }
            }
        } else {
            this.mojo.getLog().debug((CharSequence)"building a classpath application");
            result.addRuntimeModuleNames(this.runtimeModules);
            for (Artifact artifact : this.artifacts) {
                result.addToClassPath(artifact);
            }
        }
        ArrayList<ModularArtifact> allModules = new ArrayList<ModularArtifact>();
        allModules.addAll(this.automaticModules.values());
        allModules.addAll(this.modules.values());
        for (ModularArtifact modularArtifact : allModules) {
            String moduleName3 = modularArtifact.getModuleName();
            if (moduleName3.equals(this.mojo.getMainModule()) || this.requiredModules.contains(moduleName3)) continue;
            this.addToModuleOrClasspath(modularArtifact, result);
        }
        result.addRuntimeModuleNames(this.mojo.getAddModules());
        return result;
    }

    private Map<Artifact, JavaModuleDescriptor> loadArtifacts() throws MojoExecutionException {
        LinkedHashMap<File, Artifact> artifactMap = new LinkedHashMap<File, Artifact>();
        for (Artifact artifact : this.artifacts) {
            File artifactFile = artifact.getFile();
            artifactMap.put(artifactFile, artifact);
        }
        ResolvePathsRequest request = ResolvePathsRequest.ofFiles(artifactMap.keySet());
        if (this.mojo.getToolChain() instanceof DefaultJavaToolChain) {
            request.setJdkHome((Object)new File(((DefaultJavaToolChain)this.mojo.getToolChain()).getJavaHome()));
        }
        LinkedHashMap<Artifact, JavaModuleDescriptor> artifactJavaModuleDescriptorMap = new LinkedHashMap<Artifact, JavaModuleDescriptor>();
        int maxNameLength = 0;
        try {
            for (Map.Entry entry : this.mojo.getLocationManager().resolvePaths(request).getPathElements().entrySet()) {
                JavaModuleDescriptor descriptor = (JavaModuleDescriptor)entry.getValue();
                if (descriptor.name().length() > maxNameLength) {
                    maxNameLength = descriptor.name().length();
                }
                artifactJavaModuleDescriptorMap.put((Artifact)artifactMap.get(entry.getKey()), descriptor);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot resolve paths", (Exception)e);
        }
        for (Artifact artifact : this.artifacts) {
            String msg;
            JavaModuleDescriptor moduleDescriptor = (JavaModuleDescriptor)artifactJavaModuleDescriptorMap.get(artifact);
            if (moduleDescriptor != null) {
                if (moduleDescriptor.isAutomatic()) {
                    msg = String.format("automatic module   %-" + maxNameLength + "s  %s", moduleDescriptor.name(), artifact);
                    this.runJdeps(artifact);
                } else {
                    msg = String.format("full-blown module  %-" + maxNameLength + "s  %s", moduleDescriptor.name(), artifact);
                }
            } else {
                msg = String.format("artifact           %-" + maxNameLength + "s  %s", "", artifact);
                this.runJdeps(artifact);
            }
            this.mojo.getLog().info((CharSequence)msg);
        }
        return artifactJavaModuleDescriptorMap;
    }

    private boolean isModularApplication() throws MojoExecutionException {
        if (this.mojo.getMainModule() != null) {
            if (this.modules.get(this.mojo.getMainModule()) != null) {
                return true;
            }
            throw new MojoExecutionException("no such main module: " + this.mojo.getMainModule());
        }
        return false;
    }

    private void runJdeps(Artifact artifact) throws MojoExecutionException {
        ToolRunner jdepsRunner = new ToolRunner(this.mojo.getJdepsTool()).arg(new Object[]{"--list-deps"});
        if (this.jdeps12AndNewer) {
            jdepsRunner.arg(new Object[]{"--ignore-missing-deps"});
        }
        jdepsRunner.arg(new Object[]{artifact.getFile()});
        for (String line : jdepsRunner.run().getOutput()) {
            if ((line = line.trim()).isEmpty() || line.contains(" ")) continue;
            this.mojo.getLog().debug((CharSequence)(artifact + " (non-module): " + line));
            this.addRequired(line);
        }
    }

    private void addRequired(String moduleName) {
        int ndx = moduleName.indexOf(47);
        if (ndx > 0) {
            moduleName = moduleName.substring(0, ndx);
        }
        if (this.mojo.getExcludeModules().contains(moduleName)) {
            this.mojo.getLog().debug((CharSequence)("module " + moduleName + " excluded"));
        } else if (moduleName.startsWith("java.") || moduleName.startsWith("jdk.")) {
            this.runtimeModules.add(moduleName);
        } else {
            this.requiredModules.add(moduleName);
        }
    }

    private void addToModuleOrClasspath(ModularArtifact artifact, Result result) {
        if (this.mojo.isClasspathDependency(artifact.getArtifact()) || !result.isModular()) {
            result.addToClassPath(artifact.getArtifact());
        } else {
            result.addToModulePath(artifact);
        }
    }

    public static class Result {
        private final List<ModularArtifact> jlinkModules = new ArrayList<ModularArtifact>();
        private final List<String> runtimeModuleNames = new ArrayList<String>();
        private final List<ModularArtifact> modulePath = new ArrayList<ModularArtifact>();
        private final List<Artifact> classPath = new ArrayList<Artifact>();
        private final List<String> extraClassPathElements = new ArrayList<String>();
        private boolean modular;
        private boolean isPlainModular;

        public List<ModularArtifact> getJlinkModules() {
            return this.jlinkModules;
        }

        public List<ModularArtifact> getModulePath() {
            return this.modulePath;
        }

        public List<Artifact> getClassPath() {
            return this.classPath;
        }

        private void addJlinkModules(Collection<ModularArtifact> modules) {
            this.jlinkModules.addAll(modules);
        }

        private void addRuntimeModuleNames(Collection<String> moduleNames) {
            this.runtimeModuleNames.addAll(moduleNames);
        }

        private void addToModulePath(ModularArtifact module) {
            this.modulePath.add(module);
        }

        private void addToClassPath(Artifact artifact) {
            this.classPath.add(artifact);
        }

        private void setModular(boolean modular) {
            this.modular = modular;
        }

        public boolean isModular() {
            return this.modular;
        }

        private void setPlainModular(boolean plainModular) {
            this.isPlainModular = plainModular;
        }

        public boolean isPlainModular() {
            return this.isPlainModular;
        }

        public String toString() {
            boolean needComma;
            StringBuilder buf = new StringBuilder();
            if (!this.runtimeModuleNames.isEmpty()) {
                buf.append("runtime modules passed to jlink: ");
                needComma = false;
                for (String string : this.runtimeModuleNames) {
                    if (needComma) {
                        buf.append(", ");
                    } else {
                        needComma = true;
                    }
                    buf.append(string);
                }
            }
            if (!this.jlinkModules.isEmpty()) {
                buf.append("application modules passed to jlink: ");
                needComma = false;
                for (ModularArtifact modularArtifact : this.jlinkModules) {
                    if (needComma) {
                        buf.append(", ");
                    } else {
                        needComma = true;
                    }
                    buf.append(modularArtifact.getModuleName());
                }
            }
            if (!this.modulePath.isEmpty()) {
                buf.append("\nmodulepath passed to bin/java: ");
                needComma = false;
                for (ModularArtifact modularArtifact : this.modulePath) {
                    if (needComma) {
                        buf.append(", ");
                    } else {
                        needComma = true;
                    }
                    buf.append(modularArtifact.getModuleName());
                }
            }
            if (!this.classPath.isEmpty()) {
                buf.append("\nclasspath passed to bin/java: ");
                needComma = false;
                for (Artifact artifact : this.classPath) {
                    if (needComma) {
                        buf.append(", ");
                    } else {
                        needComma = true;
                    }
                    buf.append(artifact.getFile().getName());
                }
            }
            return buf.toString();
        }

        public void addToClasspath(String element) {
            this.extraClassPathElements.add(element);
        }

        public void generateJlinkModulePath(ToolRunner jlinkRunner) {
            if (!this.jlinkModules.isEmpty()) {
                jlinkRunner.arg(new Object[]{"--module-path"});
                boolean needSep = false;
                StringBuilder buf = new StringBuilder();
                for (ModularArtifact module : this.jlinkModules) {
                    if (needSep) {
                        buf.append(File.pathSeparatorChar);
                    } else {
                        needSep = true;
                    }
                    buf.append(module.getPath());
                }
                jlinkRunner.arg(new Object[]{buf});
            }
        }

        public void generateJlinkModules(ToolRunner jlinkRunner) {
            if (!this.runtimeModuleNames.isEmpty() || !this.jlinkModules.isEmpty()) {
                jlinkRunner.arg(new Object[]{"--add-modules"});
                boolean needComma = false;
                StringBuilder buf = new StringBuilder();
                for (String name : this.runtimeModuleNames) {
                    if (needComma) {
                        buf.append(',');
                    } else {
                        needComma = true;
                    }
                    buf.append(name);
                }
                for (ModularArtifact module : this.jlinkModules) {
                    if (needComma) {
                        buf.append(',');
                    } else {
                        needComma = true;
                    }
                    buf.append(module.getModuleName());
                }
                jlinkRunner.arg(new Object[]{buf});
            }
        }

        public String generateModulePath() {
            StringBuilder buf = new StringBuilder();
            if (this.modular) {
                boolean needSep = false;
                for (ModularArtifact artifact : this.modulePath) {
                    if (needSep) {
                        buf.append(File.pathSeparatorChar);
                    } else {
                        needSep = true;
                    }
                    buf.append("mp").append(File.separatorChar).append(artifact.getFileName());
                }
            }
            return buf.toString();
        }

        public String generateClassPath() {
            StringBuilder buf = new StringBuilder();
            boolean needSep = false;
            for (String element : this.extraClassPathElements) {
                if (needSep) {
                    buf.append(File.pathSeparatorChar);
                } else {
                    needSep = true;
                }
                buf.append(element);
            }
            for (Artifact artifact : this.classPath) {
                if (needSep) {
                    buf.append(File.pathSeparatorChar);
                } else {
                    needSep = true;
                }
                buf.append("cp").append(File.separatorChar).append(artifact.getFile().getName());
            }
            return buf.toString();
        }
    }
}

