/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.tentackle.maven.ToolRunner;
import org.tentackle.maven.plugin.jlink.AbstractJlinkMojo;
import org.tentackle.maven.plugin.jlink.JlinkResolver;

@Mojo(name="jlink", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class JlinkMojo
extends AbstractJlinkMojo {
    private static final String ZIP_EXTENSION = "zip";
    @Parameter
    private File jlinkTool;
    @Parameter
    private File saveOpts;
    @Parameter(defaultValue="false")
    private boolean stripDebug;
    @Parameter
    private Integer compress;
    @Parameter(defaultValue="false")
    private boolean ignoreSigningInformation;
    @Parameter(defaultValue="false")
    private boolean noHeaderFiles;
    @Parameter(defaultValue="false")
    private boolean noManPages;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File zipDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}/jlink", required=true)
    private File imageDirectory;

    @Override
    public File getImageDirectory() {
        return this.imageDirectory;
    }

    @Override
    public void prepareExecute() throws MojoExecutionException, MojoFailureException {
        super.prepareExecute();
        if (this.jlinkTool == null) {
            this.jlinkTool = this.getToolFinder().find("jlink");
        }
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.getMavenProject().getProperties().setProperty("goal", "jlink");
        super.executeImpl();
        this.getProjectHelper().attachArtifact(this.getMavenProject(), ZIP_EXTENSION, this.getClassifier(), this.createZipFile());
    }

    @Override
    protected void createImage(JlinkResolver.Result result) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("creating jlink image for a " + (result.isPlainModular() ? "plain " : "") + (result.isModular() ? "modular" : "classpath") + " application"));
        this.getLog().debug((CharSequence)result.toString());
        ToolRunner jlinkRunner = new ToolRunner(this.jlinkTool);
        if (this.saveOpts != null) {
            jlinkRunner.arg(new Object[]{"--save-opts"}).arg(new Object[]{this.saveOpts});
        }
        jlinkRunner.arg(new Object[]{"--output"}).arg(new Object[]{this.getImageDirectory()});
        if (this.stripDebug) {
            jlinkRunner.arg(new Object[]{"--strip-debug"});
        }
        if (this.compress != null) {
            jlinkRunner.arg(new Object[]{"--compress=" + this.compress});
        }
        if (this.ignoreSigningInformation) {
            jlinkRunner.arg(new Object[]{"--ignore-signing-information"});
        }
        if (this.noHeaderFiles) {
            jlinkRunner.arg(new Object[]{"--no-header-files"});
        }
        if (this.noManPages) {
            jlinkRunner.arg(new Object[]{"--no-man-pages"});
        }
        result.generateJlinkModulePath(jlinkRunner);
        result.generateJlinkModules(jlinkRunner);
        this.getLog().debug((CharSequence)jlinkRunner.toString());
        int errCode = jlinkRunner.run().getErrCode();
        if (errCode != 0) {
            throw new MojoFailureException("jlink failed: " + errCode + "\n" + jlinkRunner.getErrorsAsString() + "\n" + jlinkRunner.getOutputAsString());
        }
    }

    @Override
    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.jlinkTool == null) {
                throw new MojoExecutionException("jlink tool not found");
            }
            this.getLog().debug((CharSequence)("using " + this.jlinkTool));
            return true;
        }
        return false;
    }

    private File createZipFile() throws MojoExecutionException {
        File zipFile = new File(this.zipDirectory, this.finalName + ".zip");
        this.zipArchiver.addDirectory(this.getImageDirectory());
        this.zipArchiver.setDestFile(zipFile);
        try {
            this.zipArchiver.createArchive();
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return zipFile;
    }

    private String getClassifier() throws MojoExecutionException {
        String osArch;
        String osName = System.getProperty("os.name");
        if (osName == null) {
            throw new MojoExecutionException("missing system property 'os.name'");
        }
        osName = osName.trim().toLowerCase();
        StringBuilder buf = new StringBuilder();
        boolean isWindows = osName.contains("win");
        for (int i = 0; i < osName.length(); ++i) {
            char c = osName.charAt(i);
            if (Character.isLetter(c)) {
                buf.append(c);
                continue;
            }
            if (isWindows) break;
        }
        if ((osArch = System.getProperty("os.arch")) == null) {
            throw new MojoExecutionException("missing system property 'os.arch'");
        }
        buf.append('-').append(osArch.toLowerCase());
        return buf.toString();
    }
}

