/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.tentackle.common.FileHelper;
import org.tentackle.maven.AbstractTentackleMojo;
import org.tentackle.maven.plugin.jlink.ClasspathDependency;
import org.tentackle.maven.plugin.jlink.JlinkResolver;
import org.tentackle.maven.plugin.jlink.ModularArtifact;
import org.tentackle.maven.plugin.jlink.RunGenerator;

public abstract class AbstractJlinkMojo
extends AbstractTentackleMojo {
    @Parameter
    private String mainModule;
    @Parameter(required=true)
    private String mainClass;
    @Parameter
    private List<ClasspathDependency> classpathDependencies;
    @Component
    private LocationManager locationManager;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.basedir}/templates")
    private File templateDir;
    @Parameter(defaultValue="name.ftl")
    private String nameTemplate;
    @Parameter(defaultValue="run.ftl")
    private String runTemplate;
    @Parameter
    private File jdepsTool;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File resourcesDirectory;
    @Parameter
    private List<String> addModules;
    @Parameter
    private List<String> excludeModules;

    public File getTemplateDir() {
        return this.templateDir;
    }

    public abstract File getImageDirectory();

    public String getMainModule() {
        return this.mainModule;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public LocationManager getLocationManager() {
        return this.locationManager;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public File getJdepsTool() {
        return this.jdepsTool;
    }

    public String getNameTemplate() {
        return this.nameTemplate;
    }

    public String getRunTemplate() {
        return this.runTemplate;
    }

    public List<String> getAddModules() {
        return this.addModules == null ? Collections.emptyList() : this.addModules;
    }

    public List<String> getExcludeModules() {
        return this.excludeModules == null ? Collections.emptyList() : this.excludeModules;
    }

    public void prepareExecute() throws MojoExecutionException, MojoFailureException {
        if (this.jdepsTool == null) {
            this.jdepsTool = this.getToolFinder().find("jdeps");
        }
    }

    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        JlinkResolver.Result result = new JlinkResolver(this, this.getMavenProject().getArtifacts()).resolve();
        this.createImage(result);
        this.copyArtifacts(result);
        if (this.resourcesDirectory != null && this.resourcesDirectory.isDirectory()) {
            int resCount = this.copyResources(this.resourcesDirectory, new File(this.getApplicationDirectory(), "conf"));
            if (resCount > 0) {
                result.addToClasspath("conf");
            }
        } else {
            result.addToClasspath(".");
        }
        new RunGenerator(this, result).generate();
    }

    protected abstract void createImage(JlinkResolver.Result var1) throws MojoExecutionException, MojoFailureException;

    protected File getApplicationDirectory() {
        return this.getImageDirectory();
    }

    protected void copyArtifacts(JlinkResolver.Result result) throws MojoExecutionException {
        try {
            File dest;
            if (result.isModular() && !result.getModulePath().isEmpty()) {
                File mpDir = new File(this.getApplicationDirectory(), "mp");
                mpDir.mkdir();
                for (ModularArtifact modularArtifact : result.getModulePath()) {
                    dest = new File(mpDir, modularArtifact.getFileName());
                    this.getLog().debug((CharSequence)("copying " + modularArtifact.getPath() + " to " + mpDir));
                    FileHelper.copy((File)modularArtifact.getFile(), (File)dest);
                }
            }
            if (!result.getClassPath().isEmpty()) {
                File cpDir = new File(this.getApplicationDirectory(), "cp");
                cpDir.mkdir();
                for (Artifact artifact : result.getClassPath()) {
                    dest = new File(cpDir, artifact.getFile().getName());
                    this.getLog().debug((CharSequence)("copying " + artifact.getFile() + " to " + cpDir));
                    FileHelper.copy((File)artifact.getFile(), (File)dest);
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("copying artifacts failed", (Exception)ex);
        }
    }

    private int copyResources(File srcDir, File dstDir) throws MojoExecutionException {
        try {
            int count = 0;
            File[] files = srcDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        this.getLog().debug((CharSequence)("copying " + file + " to " + dstDir));
                        File dest = new File(dstDir, file.getName());
                        FileHelper.copy((File)file, (File)dest);
                        ++count;
                        continue;
                    }
                    if (file.isDirectory()) {
                        File subDir = new File(dstDir, file.getName());
                        subDir.mkdir();
                        count += this.copyResources(file, subDir);
                        continue;
                    }
                    this.getLog().debug((CharSequence)("skipping " + file));
                }
            }
            return count;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("copying resources failed", (Exception)ex);
        }
    }

    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.jdepsTool == null) {
                throw new MojoExecutionException("jdeps tool not found");
            }
            this.getLog().debug((CharSequence)("using " + this.jdepsTool));
            if (this.templateDir.exists()) {
                if (!this.templateDir.isDirectory()) {
                    throw new MojoExecutionException(this.templateDir.getPath() + " is not a directory");
                }
            } else {
                this.getLog().info((CharSequence)("template directory created: " + this.templateDir.getPath()));
                this.installTemplates();
            }
            if (this.mainClass == null) {
                throw new MojoExecutionException("mainClass missing");
            }
            if (this.nameTemplate == null) {
                throw new MojoExecutionException("nameTemplate missing");
            }
            if (this.runTemplate == null) {
                throw new MojoExecutionException("runTemplate missing");
            }
            return true;
        }
        return false;
    }

    public boolean isClasspathDependency(Artifact artifact) {
        if (this.classpathDependencies != null) {
            for (ClasspathDependency classpathDependency : this.classpathDependencies) {
                if (!Objects.equals(classpathDependency.getGroupId(), artifact.getGroupId()) || !Objects.equals(classpathDependency.getArtifactId(), artifact.getArtifactId()) || !Objects.equals(classpathDependency.getClassifier(), artifact.getClassifier())) continue;
                return true;
            }
        }
        return false;
    }

    protected void installTemplates() throws MojoExecutionException {
        this.installTemplate(this.nameTemplate);
        this.installTemplate(this.runTemplate);
    }

    private void installTemplate(String template) throws MojoExecutionException {
        this.templateDir.mkdirs();
        File file = new File(this.templateDir, template);
        String path = "/templates/" + template;
        String text = this.loadResourceFileIntoString(path);
        try (PrintStream ps = new PrintStream(new FileOutputStream(file));){
            ps.print(text);
            this.getLog().info((CharSequence)("installed template " + template));
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot install template " + path, (Exception)e);
        }
    }
}

