/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.i18n;

import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.tentackle.buildsupport.BundleHandler;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.StringHelper;
import org.tentackle.i18n.StoredBundleControlProvider;
import org.tentackle.maven.AbstractTentackleMojo;
import org.tentackle.maven.ProjectClassLoader;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;

public abstract class AbstractI18nMojo
extends AbstractTentackleMojo
implements DomainContextProvider {
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    protected List<String> classpathElements;
    @Parameter(required=true)
    protected String url;
    @Parameter(required=true)
    public String user;
    @Parameter
    public String password;
    @Parameter
    protected String locales;
    protected List<String> localeSuffixes;
    protected Session session;
    protected DomainContext context;
    protected int bundleCount;
    protected int errors;
    protected int warnings;
    protected int updates;

    public DomainContext getDomainContext() {
        return this.context;
    }

    protected void validate() throws MojoExecutionException {
        super.validate();
        this.findResourceDirs();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StoredBundleControlProvider.enabled = false;
        this.validate();
        this.localeSuffixes = new ArrayList<String>();
        if (this.locales != null) {
            StringTokenizer stok = new StringTokenizer(this.locales, ",; \n\r\t");
            while (stok.hasMoreTokens()) {
                String localeName = stok.nextToken().replace('_', '-');
                if (localeName.isEmpty()) continue;
                this.localeSuffixes.add(localeName);
            }
        }
        Properties props = new Properties();
        props.setProperty("url", this.url);
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        SessionInfo sessionInfo = Pdo.createSessionInfo((Properties)props);
        this.session = Pdo.createSession((SessionInfo)sessionInfo);
        try {
            this.session.open();
            this.session.makeCurrent();
            this.context = Pdo.createDomainContext((Session)this.session);
            ModificationTracker pdoTracker = ModificationTracker.getInstance();
            pdoTracker.setSession(this.session);
            ProjectClassLoader classLoader = new ProjectClassLoader((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader(), this.classpathElements);
            for (Map.Entry providerEntry : ServiceFactory.getServiceFinder((ClassLoader)classLoader, (String)"META-INF/services/").findServiceConfigurations(BundleHandler.BUNDLE_HANDLER_SERVICE).entrySet()) {
                String serviceName = (String)providerEntry.getKey();
                block9: for (Map.Entry entry : ServiceFactory.getServiceFinder((ClassLoader)classLoader, (String)"META-INF/bundles/").findServiceConfigurations(serviceName).entrySet()) {
                    String configuration = (String)entry.getKey();
                    List parts = StringHelper.split((String)configuration, (String)":= ");
                    String bundleName = (String)parts.get(0);
                    bundleName = bundleName.replace('.', '/');
                    String suffix = null;
                    String resourceName = bundleName;
                    Iterator<String> iter = this.localeSuffixes.iterator();
                    while (true) {
                        if (suffix != null) {
                            resourceName = bundleName + "_" + suffix;
                        }
                        resourceName = resourceName + ".properties";
                        if (this.verbosityLevel.isDebug()) {
                            this.getLog().debug((CharSequence)("processing " + resourceName));
                        }
                        this.processBundle((ClassLoader)classLoader, bundleName, suffix, resourceName);
                        if (!iter.hasNext()) continue block9;
                        suffix = iter.next();
                    }
                }
            }
        }
        catch (MalformedURLException mx) {
            this.getLog().error((CharSequence)"cannot create project classloader", (Throwable)mx);
        }
        catch (PersistenceException rex) {
            throw new MojoExecutionException("processing the bundles failed", (Exception)((Object)rex));
        }
        finally {
            if (this.session.isOpen()) {
                this.session.close();
            }
        }
        this.getLog().info((CharSequence)(this.bundleCount + " bundle" + (this.bundleCount == 1 ? "" : "s") + " processed, " + this.warnings + " warning" + (this.warnings == 1 ? "" : "s") + ", " + this.errors + " error" + (this.errors == 1 ? "" : "s") + ", " + this.updates + " update" + (this.updates == 1 ? "" : "s")));
        if (this.errors > 0) {
            throw new MojoExecutionException("pushing to the database failed");
        }
    }

    public abstract void processBundle(ClassLoader var1, String var2, String var3, String var4);
}

