/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.tools.fixprefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tentackle.app.ConsoleApplication;
import org.tentackle.dbms.Db;
import org.tentackle.dbms.prefs.DbPreferencesKey;
import org.tentackle.dbms.prefs.DbPreferencesNode;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;

public class FixPreferences
extends ConsoleApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixPreferences.class);
    private int nodeCount;
    private int keyCount;
    private final Map<Long, DbPreferencesNode> nodeMap = new HashMap<Long, DbPreferencesNode>();
    private final Set<DbPreferencesNode> processedNodes = new HashSet<DbPreferencesNode>();

    public FixPreferences() {
        super("Fix Preferences");
    }

    public <U extends PersistentDomainObject<U>> U getUser(DomainContext context, long userId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Db db = (Db)this.getSession();
        db.assertNotRemote();
        db = db.clone();
        long tv = db.begin();
        try {
            List nodes = new DbPreferencesNode(db).selectAllObjects();
            List keys = new DbPreferencesKey(db).selectAllObjects();
            LOGGER.info("processing {0} nodes and {1} keys", new Object[]{nodes.size(), keys.size()});
            for (DbPreferencesNode node : nodes) {
                this.nodeMap.put(node.getId(), node);
            }
            this.processPreferences(nodes, keys);
            db.commit(tv);
            LOGGER.info("{0} nodes modified, {1} keys modified", new Object[]{this.nodeCount, this.keyCount});
        }
        finally {
            db.close();
        }
    }

    private DbPreferencesNode findRoot(DbPreferencesNode node) {
        while (node != null && node.getParentId() != 0L) {
            node = this.nodeMap.get(node.getParentId());
        }
        return node;
    }

    private List<DbPreferencesNode> findChilds(List<? extends DbPreferencesNode> allNodes, DbPreferencesNode node) {
        ArrayList<DbPreferencesNode> childs = new ArrayList<DbPreferencesNode>();
        for (DbPreferencesNode dbPreferencesNode : allNodes) {
            if (dbPreferencesNode.getParentId() != node.getId()) continue;
            childs.add(dbPreferencesNode);
        }
        return childs;
    }

    private List<DbPreferencesKey> findKeys(List<? extends DbPreferencesKey> allKeys, DbPreferencesNode node) {
        ArrayList<DbPreferencesKey> keys = new ArrayList<DbPreferencesKey>();
        for (DbPreferencesKey dbPreferencesKey : allKeys) {
            if (dbPreferencesKey.getNodeId() != node.getId()) continue;
            keys.add(dbPreferencesKey);
        }
        return keys;
    }

    private void processPreferences(List<? extends DbPreferencesNode> allNodes, List<? extends DbPreferencesKey> allKeys) {
        for (DbPreferencesNode dbPreferencesNode : allNodes) {
            if (dbPreferencesNode.getParentId() != 0L || dbPreferencesNode.getRootNodeId() != 0L) continue;
            dbPreferencesNode.setRootNodeId(dbPreferencesNode.getId());
            dbPreferencesNode.saveObject();
            ++this.nodeCount;
        }
        for (DbPreferencesNode dbPreferencesNode : allNodes) {
            if (dbPreferencesNode.getParentId() == 0L) continue;
            DbPreferencesNode root = this.findRoot(dbPreferencesNode);
            if (root == null) {
                LOGGER.severe("missing root for node {0}", new Object[]{dbPreferencesNode.getId()});
                continue;
            }
            this.processNode(allNodes, allKeys, root);
        }
    }

    private void processNode(List<? extends DbPreferencesNode> allNodes, List<? extends DbPreferencesKey> allKeys, DbPreferencesNode node) {
        if (!this.processedNodes.contains(node)) {
            for (DbPreferencesKey key : this.findKeys(allKeys, node)) {
                if (key.getRootNodeId() != 0L) continue;
                key.setRootNodeId(node.getRootNodeId());
                key.saveObject();
                ++this.keyCount;
            }
            for (DbPreferencesNode child : this.findChilds(allNodes, node)) {
                if (child.getRootNodeId() == 0L) {
                    child.setRootNodeId(node.getRootNodeId());
                    child.saveObject();
                    ++this.nodeCount;
                }
                this.processNode(allNodes, allKeys, child);
            }
            this.processedNodes.add(node);
        }
    }

    public static void main(String[] args) {
        FixPreferences app = new FixPreferences();
        app.start(args);
        try {
            app.run();
        }
        catch (RuntimeException rex) {
            LOGGER.severe("FAILED!", (Throwable)rex);
        }
        finally {
            app.stop();
        }
    }
}

