/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PassportElementErrorFilesBuilderImpl.class)
public class PassportElementErrorFiles
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String FILEHASHES_FIELD = "file_hashes";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    @NonNull
    private final String source;
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="file_hashes")
    @NonNull
    private List<String> fileHashes;
    @JsonProperty(value="message")
    @NonNull
    private String message;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fileHashes.isEmpty()) {
            throw new TelegramApiValidationException("File hash parameter can't be empty", this);
        }
        if (this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    private static String $default$source() {
        return "file";
    }

    protected PassportElementErrorFiles(PassportElementErrorFilesBuilder<?, ?> b) {
        this.source = b.source$set ? b.source$value : PassportElementErrorFiles.$default$source();
        if (this.source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.type = b.type;
        if (this.type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        List<Object> fileHashes = switch (b.fileHashes == null ? 0 : b.fileHashes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.fileHashes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.fileHashes));
        };
        this.fileHashes = fileHashes;
        if (fileHashes == null) {
            throw new NullPointerException("fileHashes is marked non-null but is null");
        }
        this.message = b.message;
        if (this.message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
    }

    public static PassportElementErrorFilesBuilder<?, ?> builder() {
        return new PassportElementErrorFilesBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassportElementErrorFiles)) {
            return false;
        }
        PassportElementErrorFiles other = (PassportElementErrorFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$fileHashes = this.getFileHashes();
        List<String> other$fileHashes = other.getFileHashes();
        if (this$fileHashes == null ? other$fileHashes != null : !((Object)this$fileHashes).equals(other$fileHashes)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PassportElementErrorFiles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $fileHashes = this.getFileHashes();
        result = result * 59 + ($fileHashes == null ? 43 : ((Object)$fileHashes).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @NonNull
    public String getSource() {
        return this.source;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public List<String> getFileHashes() {
        return this.fileHashes;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="file_hashes")
    public void setFileHashes(@NonNull List<String> fileHashes) {
        if (fileHashes == null) {
            throw new NullPointerException("fileHashes is marked non-null but is null");
        }
        this.fileHashes = fileHashes;
    }

    @JsonProperty(value="message")
    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
    }

    public String toString() {
        return "PassportElementErrorFiles(source=" + this.getSource() + ", type=" + this.getType() + ", fileHashes=" + this.getFileHashes() + ", message=" + this.getMessage() + ")";
    }

    public PassportElementErrorFiles(@NonNull String source2, @NonNull String type, @NonNull List<String> fileHashes, @NonNull String message) {
        if (source2 == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fileHashes == null) {
            throw new NullPointerException("fileHashes is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.source = source2;
        this.type = type;
        this.fileHashes = fileHashes;
        this.message = message;
    }

    public static abstract class PassportElementErrorFilesBuilder<C extends PassportElementErrorFiles, B extends PassportElementErrorFilesBuilder<C, B>> {
        private boolean source$set;
        private String source$value;
        private String type;
        private ArrayList<String> fileHashes;
        private String message;

        @JsonProperty(value="source")
        public B source(@NonNull String source2) {
            if (source2 == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source$value = source2;
            this.source$set = true;
            return this.self();
        }

        @JsonProperty(value="type")
        public B type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this.self();
        }

        public B fileHash(String fileHash) {
            if (this.fileHashes == null) {
                this.fileHashes = new ArrayList();
            }
            this.fileHashes.add(fileHash);
            return this.self();
        }

        @JsonProperty(value="file_hashes")
        public B fileHashes(Collection<? extends String> fileHashes) {
            if (fileHashes == null) {
                throw new NullPointerException("fileHashes cannot be null");
            }
            if (this.fileHashes == null) {
                this.fileHashes = new ArrayList();
            }
            this.fileHashes.addAll(fileHashes);
            return this.self();
        }

        public B clearFileHashes() {
            if (this.fileHashes != null) {
                this.fileHashes.clear();
            }
            return this.self();
        }

        @JsonProperty(value="message")
        public B message(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "PassportElementErrorFiles.PassportElementErrorFilesBuilder(source$value=" + this.source$value + ", type=" + this.type + ", fileHashes=" + this.fileHashes + ", message=" + this.message + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class PassportElementErrorFilesBuilderImpl
    extends PassportElementErrorFilesBuilder<PassportElementErrorFiles, PassportElementErrorFilesBuilderImpl> {
        private PassportElementErrorFilesBuilderImpl() {
        }

        @Override
        protected PassportElementErrorFilesBuilderImpl self() {
            return this;
        }

        @Override
        public PassportElementErrorFiles build() {
            return new PassportElementErrorFiles(this);
        }
    }
}

