/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InlineQueryResultAudioBuilderImpl.class)
public class InlineQueryResultAudio
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String AUDIOURL_FIELD = "audio_url";
    private static final String TITLE_FIELD = "title";
    private static final String PERFORMER_FIELD = "performer";
    private static final String AUDIO_DURATION_FIELD = "audio_duration";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String CAPTION_FIELD = "caption";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "audio";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="audio_url")
    @NonNull
    private String audioUrl;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="performer")
    private String performer;
    @JsonProperty(value="audio_duration")
    private Integer audioDuration;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.audioUrl == null || this.audioUrl.isEmpty()) {
            throw new TelegramApiValidationException("AudioUrl parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    protected InlineQueryResultAudio(InlineQueryResultAudioBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.audioUrl = b.audioUrl;
        if (this.audioUrl == null) {
            throw new NullPointerException("audioUrl is marked non-null but is null");
        }
        this.title = b.title;
        this.performer = b.performer;
        this.audioDuration = b.audioDuration;
        this.inputMessageContent = b.inputMessageContent;
        this.replyMarkup = b.replyMarkup;
        this.caption = b.caption;
        this.parseMode = b.parseMode;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
    }

    public static InlineQueryResultAudioBuilder<?, ?> builder() {
        return new InlineQueryResultAudioBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultAudio)) {
            return false;
        }
        InlineQueryResultAudio other = (InlineQueryResultAudio)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$audioDuration = this.getAudioDuration();
        Integer other$audioDuration = other.getAudioDuration();
        if (this$audioDuration == null ? other$audioDuration != null : !((Object)this$audioDuration).equals(other$audioDuration)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$audioUrl = this.getAudioUrl();
        String other$audioUrl = other.getAudioUrl();
        if (this$audioUrl == null ? other$audioUrl != null : !this$audioUrl.equals(other$audioUrl)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$performer = this.getPerformer();
        String other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultAudio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $audioDuration = this.getAudioDuration();
        result = result * 59 + ($audioDuration == null ? 43 : ((Object)$audioDuration).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $audioUrl = this.getAudioUrl();
        result = result * 59 + ($audioUrl == null ? 43 : $audioUrl.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getAudioUrl() {
        return this.audioUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPerformer() {
        return this.performer;
    }

    public Integer getAudioDuration() {
        return this.audioDuration;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="audio_url")
    public void setAudioUrl(@NonNull String audioUrl) {
        if (audioUrl == null) {
            throw new NullPointerException("audioUrl is marked non-null but is null");
        }
        this.audioUrl = audioUrl;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="performer")
    public void setPerformer(String performer) {
        this.performer = performer;
    }

    @JsonProperty(value="audio_duration")
    public void setAudioDuration(Integer audioDuration) {
        this.audioDuration = audioDuration;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultAudio(type=" + this.getType() + ", id=" + this.getId() + ", audioUrl=" + this.getAudioUrl() + ", title=" + this.getTitle() + ", performer=" + this.getPerformer() + ", audioDuration=" + this.getAudioDuration() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultAudio(@NonNull String id, @NonNull String audioUrl) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (audioUrl == null) {
            throw new NullPointerException("audioUrl is marked non-null but is null");
        }
        this.id = id;
        this.audioUrl = audioUrl;
    }

    public InlineQueryResultAudio(@NonNull String id, @NonNull String audioUrl, String title, String performer, Integer audioDuration, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, String caption, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (audioUrl == null) {
            throw new NullPointerException("audioUrl is marked non-null but is null");
        }
        this.id = id;
        this.audioUrl = audioUrl;
        this.title = title;
        this.performer = performer;
        this.audioDuration = audioDuration;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static abstract class InlineQueryResultAudioBuilder<C extends InlineQueryResultAudio, B extends InlineQueryResultAudioBuilder<C, B>> {
        private String id;
        private String audioUrl;
        private String title;
        private String performer;
        private Integer audioDuration;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private String caption;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        @JsonProperty(value="id")
        public B id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="audio_url")
        public B audioUrl(@NonNull String audioUrl) {
            if (audioUrl == null) {
                throw new NullPointerException("audioUrl is marked non-null but is null");
            }
            this.audioUrl = audioUrl;
            return this.self();
        }

        @JsonProperty(value="title")
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="performer")
        public B performer(String performer) {
            this.performer = performer;
            return this.self();
        }

        @JsonProperty(value="audio_duration")
        public B audioDuration(Integer audioDuration) {
            this.audioDuration = audioDuration;
            return this.self();
        }

        @JsonProperty(value="input_message_content")
        public B inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this.self();
        }

        @JsonProperty(value="reply_markup")
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this.self();
        }

        @JsonProperty(value="caption")
        public B caption(String caption) {
            this.caption = caption;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this.self();
        }

        @JsonProperty(value="caption_entities")
        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this.self();
        }

        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InlineQueryResultAudio.InlineQueryResultAudioBuilder(id=" + this.id + ", audioUrl=" + this.audioUrl + ", title=" + this.title + ", performer=" + this.performer + ", audioDuration=" + this.audioDuration + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InlineQueryResultAudioBuilderImpl
    extends InlineQueryResultAudioBuilder<InlineQueryResultAudio, InlineQueryResultAudioBuilderImpl> {
        private InlineQueryResultAudioBuilderImpl() {
        }

        @Override
        protected InlineQueryResultAudioBuilderImpl self() {
            return this;
        }

        @Override
        public InlineQueryResultAudio build() {
            return new InlineQueryResultAudio(this);
        }
    }
}

