/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodSerializable;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=EditMessageLiveLocationBuilderImpl.class)
public class EditMessageLiveLocation
extends BotApiMethodSerializable {
    public static final String PATH = "editMessageLiveLocation";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String HORIZONTAL_ACCURACY_FIELD = "horizontal_accuracy";
    private static final String HEADING_FIELD = "heading";
    private static final String PROXIMITY_ALERT_RADIUS_FIELD = "proximity_alert_radius";
    private static final String LIVE_PERIOD_FIELD = "live_period";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="latitude")
    @NonNull
    private Double latitude;
    @JsonProperty(value="longitude")
    @NonNull
    private Double longitude;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="horizontal_accuracy")
    private Double horizontalAccuracy;
    @JsonProperty(value="heading")
    private Integer heading;
    @JsonProperty(value="proximity_alert_radius")
    private Integer proximityAlertRadius;
    @JsonProperty(value="live_period")
    private Integer livePeriod;

    public void setChatId(Long chatId) {
        this.chatId = chatId == null ? null : chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Serializable deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponseMessageOrBoolean(answer);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null || this.chatId.isEmpty()) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
        if (this.horizontalAccuracy != null && (this.horizontalAccuracy < 0.0 || this.horizontalAccuracy > 1500.0)) {
            throw new TelegramApiValidationException("Horizontal Accuracy parameter must be between 0 and 1500", this);
        }
        if (this.heading != null && (this.heading < 1 || this.heading > 360)) {
            throw new TelegramApiValidationException("Heading Accuracy parameter must be between 1 and 360", this);
        }
        if (this.proximityAlertRadius != null && (this.proximityAlertRadius < 1 || this.proximityAlertRadius > 100000)) {
            throw new TelegramApiValidationException("Approaching notification distance parameter must be between 1 and 100000", this);
        }
        if (this.livePeriod != null && (this.livePeriod < 60 || this.livePeriod > 86400) && this.livePeriod != Integer.MAX_VALUE) {
            throw new TelegramApiValidationException("Live period parameter must be between 60 and 86400 or be 0x7FFFFFFF", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    protected EditMessageLiveLocation(EditMessageLiveLocationBuilder<?, ?> b) {
        super((BotApiMethodSerializable.BotApiMethodSerializableBuilder<?, ?>)b);
        this.chatId = b.chatId;
        this.messageId = b.messageId;
        this.inlineMessageId = b.inlineMessageId;
        this.latitude = b.latitude;
        if (this.latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.longitude = b.longitude;
        if (this.longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.replyMarkup = b.replyMarkup;
        this.horizontalAccuracy = b.horizontalAccuracy;
        this.heading = b.heading;
        this.proximityAlertRadius = b.proximityAlertRadius;
        this.livePeriod = b.livePeriod;
    }

    public static EditMessageLiveLocationBuilder<?, ?> builder() {
        return new EditMessageLiveLocationBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditMessageLiveLocation)) {
            return false;
        }
        EditMessageLiveLocation other = (EditMessageLiveLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$horizontalAccuracy = this.getHorizontalAccuracy();
        Double other$horizontalAccuracy = other.getHorizontalAccuracy();
        if (this$horizontalAccuracy == null ? other$horizontalAccuracy != null : !((Object)this$horizontalAccuracy).equals(other$horizontalAccuracy)) {
            return false;
        }
        Integer this$heading = this.getHeading();
        Integer other$heading = other.getHeading();
        if (this$heading == null ? other$heading != null : !((Object)this$heading).equals(other$heading)) {
            return false;
        }
        Integer this$proximityAlertRadius = this.getProximityAlertRadius();
        Integer other$proximityAlertRadius = other.getProximityAlertRadius();
        if (this$proximityAlertRadius == null ? other$proximityAlertRadius != null : !((Object)this$proximityAlertRadius).equals(other$proximityAlertRadius)) {
            return false;
        }
        Integer this$livePeriod = this.getLivePeriod();
        Integer other$livePeriod = other.getLivePeriod();
        if (this$livePeriod == null ? other$livePeriod != null : !((Object)this$livePeriod).equals(other$livePeriod)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        if (this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        return !(this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditMessageLiveLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $horizontalAccuracy = this.getHorizontalAccuracy();
        result = result * 59 + ($horizontalAccuracy == null ? 43 : ((Object)$horizontalAccuracy).hashCode());
        Integer $heading = this.getHeading();
        result = result * 59 + ($heading == null ? 43 : ((Object)$heading).hashCode());
        Integer $proximityAlertRadius = this.getProximityAlertRadius();
        result = result * 59 + ($proximityAlertRadius == null ? 43 : ((Object)$proximityAlertRadius).hashCode());
        Integer $livePeriod = this.getLivePeriod();
        result = result * 59 + ($livePeriod == null ? 43 : ((Object)$livePeriod).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        return result;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @NonNull
    public Double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public Double getLongitude() {
        return this.longitude;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public Double getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public Integer getHeading() {
        return this.heading;
    }

    public Integer getProximityAlertRadius() {
        return this.proximityAlertRadius;
    }

    public Integer getLivePeriod() {
        return this.livePeriod;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(@NonNull Double latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(@NonNull Double longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="horizontal_accuracy")
    public void setHorizontalAccuracy(Double horizontalAccuracy) {
        this.horizontalAccuracy = horizontalAccuracy;
    }

    @JsonProperty(value="heading")
    public void setHeading(Integer heading) {
        this.heading = heading;
    }

    @JsonProperty(value="proximity_alert_radius")
    public void setProximityAlertRadius(Integer proximityAlertRadius) {
        this.proximityAlertRadius = proximityAlertRadius;
    }

    @JsonProperty(value="live_period")
    public void setLivePeriod(Integer livePeriod) {
        this.livePeriod = livePeriod;
    }

    public String toString() {
        return "EditMessageLiveLocation(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", replyMarkup=" + this.getReplyMarkup() + ", horizontalAccuracy=" + this.getHorizontalAccuracy() + ", heading=" + this.getHeading() + ", proximityAlertRadius=" + this.getProximityAlertRadius() + ", livePeriod=" + this.getLivePeriod() + ")";
    }

    public EditMessageLiveLocation(@NonNull Double latitude, @NonNull Double longitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static abstract class EditMessageLiveLocationBuilder<C extends EditMessageLiveLocation, B extends EditMessageLiveLocationBuilder<C, B>>
    extends BotApiMethodSerializable.BotApiMethodSerializableBuilder<C, B> {
        private String chatId;
        private Integer messageId;
        private String inlineMessageId;
        private Double latitude;
        private Double longitude;
        private InlineKeyboardMarkup replyMarkup;
        private Double horizontalAccuracy;
        private Integer heading;
        private Integer proximityAlertRadius;
        private Integer livePeriod;

        public EditMessageLiveLocationBuilder<C, B> chatId(Long chatId) {
            this.chatId = chatId == null ? null : chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(String chatId) {
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        public B messageId(Integer messageId) {
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="inline_message_id")
        public B inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="latitude")
        public B latitude(@NonNull Double latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return (B)this.self();
        }

        @JsonProperty(value="longitude")
        public B longitude(@NonNull Double longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="horizontal_accuracy")
        public B horizontalAccuracy(Double horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
            return (B)this.self();
        }

        @JsonProperty(value="heading")
        public B heading(Integer heading) {
            this.heading = heading;
            return (B)this.self();
        }

        @JsonProperty(value="proximity_alert_radius")
        public B proximityAlertRadius(Integer proximityAlertRadius) {
            this.proximityAlertRadius = proximityAlertRadius;
            return (B)this.self();
        }

        @JsonProperty(value="live_period")
        public B livePeriod(Integer livePeriod) {
            this.livePeriod = livePeriod;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "EditMessageLiveLocation.EditMessageLiveLocationBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", replyMarkup=" + this.replyMarkup + ", horizontalAccuracy=" + this.horizontalAccuracy + ", heading=" + this.heading + ", proximityAlertRadius=" + this.proximityAlertRadius + ", livePeriod=" + this.livePeriod + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class EditMessageLiveLocationBuilderImpl
    extends EditMessageLiveLocationBuilder<EditMessageLiveLocation, EditMessageLiveLocationBuilderImpl> {
        private EditMessageLiveLocationBuilderImpl() {
        }

        @Override
        protected EditMessageLiveLocationBuilderImpl self() {
            return this;
        }

        @Override
        public EditMessageLiveLocation build() {
            return new EditMessageLiveLocation(this);
        }
    }
}

