/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SendLocationBuilderImpl.class)
public class SendLocation
extends BotApiMethodMessage {
    public static final String PATH = "sendlocation";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGETHREADID_FIELD = "message_thread_id";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private static final String LIVE_PERIOD_FIELD = "live_period";
    private static final String ALLOWSENDINGWITHOUTREPLY_FIELD = "allow_sending_without_reply";
    private static final String HORIZONTALACCURACY_FIELD = "horizontal_accuracy";
    private static final String HEADING_FIELD = "heading";
    private static final String PROXIMITYALERTRADIUS_FIELD = "proximity_alert_radius";
    private static final String PROTECTCONTENT_FIELD = "protect_content";
    private static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="latitude")
    @NonNull
    private Double latitude;
    @JsonProperty(value="longitude")
    @NonNull
    private Double longitude;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;
    @JsonProperty(value="live_period")
    private Integer livePeriod;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="horizontal_accuracy")
    private Double horizontalAccuracy;
    @JsonProperty(value="heading")
    private Integer heading;
    @JsonProperty(value="proximity_alert_radius")
    private Integer proximityAlertRadius;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="reply_parameters")
    private ReplyParameters replyParameters;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.horizontalAccuracy != null && (this.horizontalAccuracy < 0.0 || this.horizontalAccuracy > 1500.0)) {
            throw new TelegramApiValidationException("Horizontal Accuracy parameter must be between 0 and 1500", this);
        }
        if (this.heading != null && (this.heading < 1 || this.heading > 360)) {
            throw new TelegramApiValidationException("Heading Accuracy parameter must be between 1 and 360", this);
        }
        if (this.proximityAlertRadius != null && (this.proximityAlertRadius < 1 || this.proximityAlertRadius > 100000)) {
            throw new TelegramApiValidationException("Proximity alert radius parameter must be between 1 and 100000", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.livePeriod != null && (this.livePeriod < 60 || this.livePeriod > 86400) && this.livePeriod != Integer.MAX_VALUE) {
            throw new TelegramApiValidationException("Live period parameter must be between 60 and 86400 or be 0x7FFFFFFF", this);
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    protected SendLocation(SendLocationBuilder<?, ?> b) {
        super((BotApiMethodMessage.BotApiMethodMessageBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.latitude = b.latitude;
        if (this.latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.longitude = b.longitude;
        if (this.longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.disableNotification = b.disableNotification;
        this.replyToMessageId = b.replyToMessageId;
        this.replyMarkup = b.replyMarkup;
        this.livePeriod = b.livePeriod;
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.horizontalAccuracy = b.horizontalAccuracy;
        this.heading = b.heading;
        this.proximityAlertRadius = b.proximityAlertRadius;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
        this.businessConnectionId = b.businessConnectionId;
    }

    public static SendLocationBuilder<?, ?> builder() {
        return new SendLocationBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendLocation)) {
            return false;
        }
        SendLocation other = (SendLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Integer this$livePeriod = this.getLivePeriod();
        Integer other$livePeriod = other.getLivePeriod();
        if (this$livePeriod == null ? other$livePeriod != null : !((Object)this$livePeriod).equals(other$livePeriod)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Double this$horizontalAccuracy = this.getHorizontalAccuracy();
        Double other$horizontalAccuracy = other.getHorizontalAccuracy();
        if (this$horizontalAccuracy == null ? other$horizontalAccuracy != null : !((Object)this$horizontalAccuracy).equals(other$horizontalAccuracy)) {
            return false;
        }
        Integer this$heading = this.getHeading();
        Integer other$heading = other.getHeading();
        if (this$heading == null ? other$heading != null : !((Object)this$heading).equals(other$heading)) {
            return false;
        }
        Integer this$proximityAlertRadius = this.getProximityAlertRadius();
        Integer other$proximityAlertRadius = other.getProximityAlertRadius();
        if (this$proximityAlertRadius == null ? other$proximityAlertRadius != null : !((Object)this$proximityAlertRadius).equals(other$proximityAlertRadius)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        return !(this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Integer $livePeriod = this.getLivePeriod();
        result = result * 59 + ($livePeriod == null ? 43 : ((Object)$livePeriod).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Double $horizontalAccuracy = this.getHorizontalAccuracy();
        result = result * 59 + ($horizontalAccuracy == null ? 43 : ((Object)$horizontalAccuracy).hashCode());
        Integer $heading = this.getHeading();
        result = result * 59 + ($heading == null ? 43 : ((Object)$heading).hashCode());
        Integer $proximityAlertRadius = this.getProximityAlertRadius();
        result = result * 59 + ($proximityAlertRadius == null ? 43 : ((Object)$proximityAlertRadius).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public Double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public Double getLongitude() {
        return this.longitude;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public Integer getLivePeriod() {
        return this.livePeriod;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public Double getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public Integer getHeading() {
        return this.heading;
    }

    public Integer getProximityAlertRadius() {
        return this.proximityAlertRadius;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(@NonNull Double latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(@NonNull Double longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="reply_to_message_id")
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="live_period")
    public void setLivePeriod(Integer livePeriod) {
        this.livePeriod = livePeriod;
    }

    @JsonProperty(value="allow_sending_without_reply")
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="horizontal_accuracy")
    public void setHorizontalAccuracy(Double horizontalAccuracy) {
        this.horizontalAccuracy = horizontalAccuracy;
    }

    @JsonProperty(value="heading")
    public void setHeading(Integer heading) {
        this.heading = heading;
    }

    @JsonProperty(value="proximity_alert_radius")
    public void setProximityAlertRadius(Integer proximityAlertRadius) {
        this.proximityAlertRadius = proximityAlertRadius;
    }

    @JsonProperty(value="protect_content")
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="reply_parameters")
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @JsonProperty(value="business_connection_id")
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    public String toString() {
        return "SendLocation(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", livePeriod=" + this.getLivePeriod() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", horizontalAccuracy=" + this.getHorizontalAccuracy() + ", heading=" + this.getHeading() + ", proximityAlertRadius=" + this.getProximityAlertRadius() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ", businessConnectionId=" + this.getBusinessConnectionId() + ")";
    }

    public SendLocation(@NonNull String chatId, @NonNull Double latitude, @NonNull Double longitude) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.chatId = chatId;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public SendLocation(@NonNull String chatId, Integer messageThreadId, @NonNull Double latitude, @NonNull Double longitude, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, Integer livePeriod, Boolean allowSendingWithoutReply, Double horizontalAccuracy, Integer heading, Integer proximityAlertRadius, Boolean protectContent, ReplyParameters replyParameters, String businessConnectionId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.latitude = latitude;
        this.longitude = longitude;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.livePeriod = livePeriod;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.horizontalAccuracy = horizontalAccuracy;
        this.heading = heading;
        this.proximityAlertRadius = proximityAlertRadius;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
        this.businessConnectionId = businessConnectionId;
    }

    public static abstract class SendLocationBuilder<C extends SendLocation, B extends SendLocationBuilder<C, B>>
    extends BotApiMethodMessage.BotApiMethodMessageBuilder<C, B> {
        private String chatId;
        private Integer messageThreadId;
        private Double latitude;
        private Double longitude;
        private Boolean disableNotification;
        private Integer replyToMessageId;
        private ReplyKeyboard replyMarkup;
        private Integer livePeriod;
        private Boolean allowSendingWithoutReply;
        private Double horizontalAccuracy;
        private Integer heading;
        private Integer proximityAlertRadius;
        private Boolean protectContent;
        private ReplyParameters replyParameters;
        private String businessConnectionId;

        public SendLocationBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="latitude")
        public B latitude(@NonNull Double latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return (B)this.self();
        }

        @JsonProperty(value="longitude")
        public B longitude(@NonNull Double longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="reply_to_message_id")
        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="live_period")
        public B livePeriod(Integer livePeriod) {
            this.livePeriod = livePeriod;
            return (B)this.self();
        }

        @JsonProperty(value="allow_sending_without_reply")
        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        @JsonProperty(value="horizontal_accuracy")
        public B horizontalAccuracy(Double horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
            return (B)this.self();
        }

        @JsonProperty(value="heading")
        public B heading(Integer heading) {
            this.heading = heading;
            return (B)this.self();
        }

        @JsonProperty(value="proximity_alert_radius")
        public B proximityAlertRadius(Integer proximityAlertRadius) {
            this.proximityAlertRadius = proximityAlertRadius;
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @JsonProperty(value="reply_parameters")
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @JsonProperty(value="business_connection_id")
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SendLocation.SendLocationBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", livePeriod=" + this.livePeriod + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", horizontalAccuracy=" + this.horizontalAccuracy + ", heading=" + this.heading + ", proximityAlertRadius=" + this.proximityAlertRadius + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ", businessConnectionId=" + this.businessConnectionId + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SendLocationBuilderImpl
    extends SendLocationBuilder<SendLocation, SendLocationBuilderImpl> {
        private SendLocationBuilderImpl() {
        }

        @Override
        protected SendLocationBuilderImpl self() {
            return this;
        }

        @Override
        public SendLocation build() {
            return new SendLocation(this);
        }
    }
}

