/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAnimation;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAudio;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaDocument;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaPhoto;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaVideo;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=InputMediaAnimation.class, name="animation"), @JsonSubTypes.Type(value=InputMediaAudio.class, name="audio"), @JsonSubTypes.Type(value=InputMediaDocument.class, name="document"), @JsonSubTypes.Type(value=InputMediaPhoto.class, name="photo"), @JsonSubTypes.Type(value=InputMediaVideo.class, name="video")})
public abstract class InputMedia
implements Validable,
BotApiObject {
    public static final String TYPE_FIELD = "type";
    public static final String MEDIA_FIELD = "media";
    public static final String CAPTION_FIELD = "caption";
    public static final String PARSE_MODE_FIELD = "parse_mode";
    public static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="media")
    @NonNull
    private String media;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;
    @JsonIgnore
    private boolean isNewMedia;
    @JsonIgnore
    private String mediaName;
    @JsonIgnore
    private File newMediaFile;
    @JsonIgnore
    private InputStream newMediaStream;

    @JsonIgnore
    public boolean isNewMedia() {
        return this.isNewMedia;
    }

    public void setMedia(String media) {
        this.media = media;
        this.isNewMedia = false;
    }

    public void setMedia(File mediaFile, String fileName) {
        this.newMediaFile = mediaFile;
        this.isNewMedia = true;
        this.mediaName = fileName;
        this.media = "attach://" + fileName;
    }

    public void setMedia(InputStream mediaStream, String fileName) {
        this.newMediaStream = mediaStream;
        this.isNewMedia = true;
        this.mediaName = fileName;
        this.media = "attach://" + fileName;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.isNewMedia) {
            if (this.mediaName == null || this.mediaName.isEmpty()) {
                throw new TelegramApiValidationException("Media name can't be empty", this);
            }
            if (this.newMediaFile == null && this.newMediaStream == null) {
                throw new TelegramApiValidationException("Media can't be empty", this);
            }
        } else if (this.media.isEmpty()) {
            throw new TelegramApiValidationException("Media can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
    }

    @JsonProperty(value="type")
    public abstract String getType();

    protected InputMedia(InputMediaBuilder<?, ?> b) {
        this.media = b.media;
        if (this.media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.caption = b.caption;
        this.parseMode = b.parseMode;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
        this.isNewMedia = b.isNewMedia;
        this.mediaName = b.mediaName;
        this.newMediaFile = b.newMediaFile;
        this.newMediaStream = b.newMediaStream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMedia)) {
            return false;
        }
        InputMedia other = (InputMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNewMedia() != other.isNewMedia()) {
            return false;
        }
        String this$media = this.getMedia();
        String other$media = other.getMedia();
        if (this$media == null ? other$media != null : !this$media.equals(other$media)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        String this$mediaName = this.getMediaName();
        String other$mediaName = other.getMediaName();
        if (this$mediaName == null ? other$mediaName != null : !this$mediaName.equals(other$mediaName)) {
            return false;
        }
        File this$newMediaFile = this.getNewMediaFile();
        File other$newMediaFile = other.getNewMediaFile();
        if (this$newMediaFile == null ? other$newMediaFile != null : !((Object)this$newMediaFile).equals(other$newMediaFile)) {
            return false;
        }
        InputStream this$newMediaStream = this.getNewMediaStream();
        InputStream other$newMediaStream = other.getNewMediaStream();
        return !(this$newMediaStream == null ? other$newMediaStream != null : !this$newMediaStream.equals(other$newMediaStream));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputMedia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNewMedia() ? 79 : 97);
        String $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : $media.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        String $mediaName = this.getMediaName();
        result = result * 59 + ($mediaName == null ? 43 : $mediaName.hashCode());
        File $newMediaFile = this.getNewMediaFile();
        result = result * 59 + ($newMediaFile == null ? 43 : ((Object)$newMediaFile).hashCode());
        InputStream $newMediaStream = this.getNewMediaStream();
        result = result * 59 + ($newMediaStream == null ? 43 : $newMediaStream.hashCode());
        return result;
    }

    @NonNull
    public String getMedia() {
        return this.media;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public File getNewMediaFile() {
        return this.newMediaFile;
    }

    public InputStream getNewMediaStream() {
        return this.newMediaStream;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @JsonIgnore
    public void setNewMedia(boolean isNewMedia) {
        this.isNewMedia = isNewMedia;
    }

    @JsonIgnore
    public void setMediaName(String mediaName) {
        this.mediaName = mediaName;
    }

    @JsonIgnore
    public void setNewMediaFile(File newMediaFile) {
        this.newMediaFile = newMediaFile;
    }

    @JsonIgnore
    public void setNewMediaStream(InputStream newMediaStream) {
        this.newMediaStream = newMediaStream;
    }

    public String toString() {
        return "InputMedia(media=" + this.getMedia() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ", isNewMedia=" + this.isNewMedia() + ", mediaName=" + this.getMediaName() + ", newMediaFile=" + this.getNewMediaFile() + ", newMediaStream=" + this.getNewMediaStream() + ")";
    }

    protected InputMedia() {
    }

    public InputMedia(@NonNull String media) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
    }

    public InputMedia(@NonNull String media, String caption, String parseMode, List<MessageEntity> captionEntities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
        this.isNewMedia = isNewMedia;
        this.mediaName = mediaName;
        this.newMediaFile = newMediaFile;
        this.newMediaStream = newMediaStream;
    }

    public static abstract class InputMediaBuilder<C extends InputMedia, B extends InputMediaBuilder<C, B>> {
        private String media;
        private String caption;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;
        private boolean isNewMedia;
        private String mediaName;
        private File newMediaFile;
        private InputStream newMediaStream;

        @JsonIgnore
        public B media(@NonNull File mediaFile, @NonNull String fileName) {
            if (mediaFile == null) {
                throw new NullPointerException("mediaFile is marked non-null but is null");
            }
            if (fileName == null) {
                throw new NullPointerException("fileName is marked non-null but is null");
            }
            this.newMediaFile = mediaFile;
            this.isNewMedia = true;
            this.mediaName = fileName;
            this.media = "attach://" + fileName;
            return this.self();
        }

        @JsonIgnore
        public B media(@NonNull InputStream mediaStream, @NonNull String fileName) {
            if (mediaStream == null) {
                throw new NullPointerException("mediaStream is marked non-null but is null");
            }
            if (fileName == null) {
                throw new NullPointerException("fileName is marked non-null but is null");
            }
            this.newMediaStream = mediaStream;
            this.isNewMedia = true;
            this.mediaName = fileName;
            this.media = "attach://" + fileName;
            return this.self();
        }

        @JsonProperty(value="media")
        public B media(@NonNull String media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            this.isNewMedia = false;
            return this.self();
        }

        @JsonIgnore
        private B isNewMedia(boolean isNewMedia) {
            return this.self();
        }

        @JsonIgnore
        private B mediaName(String mediaName) {
            return this.self();
        }

        @JsonIgnore
        private B newMediaFile(File newMediaFile) {
            return this.self();
        }

        @JsonIgnore
        private B newMediaStream(InputStream newMediaStream) {
            return this.self();
        }

        @JsonProperty(value="caption")
        public B caption(String caption) {
            this.caption = caption;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this.self();
        }

        @JsonProperty(value="caption_entities")
        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this.self();
        }

        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InputMedia.InputMediaBuilder(media=" + this.media + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ", isNewMedia=" + this.isNewMedia + ", mediaName=" + this.mediaName + ", newMediaFile=" + this.newMediaFile + ", newMediaStream=" + this.newMediaStream + ")";
        }
    }
}

