/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InlineQueryResultCachedDocumentBuilderImpl.class)
public class InlineQueryResultCachedDocument
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String TITLE_FIELD = "title";
    private static final String DOCUMENT_FILE_ID_FIELD = "document_file_id";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String CAPTION_FIELD = "caption";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "document";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="document_file_id")
    @NonNull
    private String documentFileId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.documentFileId.isEmpty()) {
            throw new TelegramApiValidationException("DocumentFileId parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    protected InlineQueryResultCachedDocument(InlineQueryResultCachedDocumentBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.title = b.title;
        this.documentFileId = b.documentFileId;
        if (this.documentFileId == null) {
            throw new NullPointerException("documentFileId is marked non-null but is null");
        }
        this.description = b.description;
        this.caption = b.caption;
        this.replyMarkup = b.replyMarkup;
        this.inputMessageContent = b.inputMessageContent;
        this.parseMode = b.parseMode;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
    }

    public static InlineQueryResultCachedDocumentBuilder<?, ?> builder() {
        return new InlineQueryResultCachedDocumentBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultCachedDocument)) {
            return false;
        }
        InlineQueryResultCachedDocument other = (InlineQueryResultCachedDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$documentFileId = this.getDocumentFileId();
        String other$documentFileId = other.getDocumentFileId();
        if (this$documentFileId == null ? other$documentFileId != null : !this$documentFileId.equals(other$documentFileId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultCachedDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $documentFileId = this.getDocumentFileId();
        result = result * 59 + ($documentFileId == null ? 43 : $documentFileId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getDocumentFileId() {
        return this.documentFileId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCaption() {
        return this.caption;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="document_file_id")
    public void setDocumentFileId(@NonNull String documentFileId) {
        if (documentFileId == null) {
            throw new NullPointerException("documentFileId is marked non-null but is null");
        }
        this.documentFileId = documentFileId;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultCachedDocument(type=" + this.getType() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", documentFileId=" + this.getDocumentFileId() + ", description=" + this.getDescription() + ", caption=" + this.getCaption() + ", replyMarkup=" + this.getReplyMarkup() + ", inputMessageContent=" + this.getInputMessageContent() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultCachedDocument(@NonNull String id, @NonNull String documentFileId) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (documentFileId == null) {
            throw new NullPointerException("documentFileId is marked non-null but is null");
        }
        this.id = id;
        this.documentFileId = documentFileId;
    }

    public InlineQueryResultCachedDocument(@NonNull String id, String title, @NonNull String documentFileId, String description, String caption, InlineKeyboardMarkup replyMarkup, InputMessageContent inputMessageContent, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (documentFileId == null) {
            throw new NullPointerException("documentFileId is marked non-null but is null");
        }
        this.id = id;
        this.title = title;
        this.documentFileId = documentFileId;
        this.description = description;
        this.caption = caption;
        this.replyMarkup = replyMarkup;
        this.inputMessageContent = inputMessageContent;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static abstract class InlineQueryResultCachedDocumentBuilder<C extends InlineQueryResultCachedDocument, B extends InlineQueryResultCachedDocumentBuilder<C, B>> {
        private String id;
        private String title;
        private String documentFileId;
        private String description;
        private String caption;
        private InlineKeyboardMarkup replyMarkup;
        private InputMessageContent inputMessageContent;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        @JsonProperty(value="id")
        public B id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="title")
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="document_file_id")
        public B documentFileId(@NonNull String documentFileId) {
            if (documentFileId == null) {
                throw new NullPointerException("documentFileId is marked non-null but is null");
            }
            this.documentFileId = documentFileId;
            return this.self();
        }

        @JsonProperty(value="description")
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @JsonProperty(value="caption")
        public B caption(String caption) {
            this.caption = caption;
            return this.self();
        }

        @JsonProperty(value="reply_markup")
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this.self();
        }

        @JsonProperty(value="input_message_content")
        public B inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this.self();
        }

        @JsonProperty(value="caption_entities")
        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this.self();
        }

        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InlineQueryResultCachedDocument.InlineQueryResultCachedDocumentBuilder(id=" + this.id + ", title=" + this.title + ", documentFileId=" + this.documentFileId + ", description=" + this.description + ", caption=" + this.caption + ", replyMarkup=" + this.replyMarkup + ", inputMessageContent=" + this.inputMessageContent + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InlineQueryResultCachedDocumentBuilderImpl
    extends InlineQueryResultCachedDocumentBuilder<InlineQueryResultCachedDocument, InlineQueryResultCachedDocumentBuilderImpl> {
        private InlineQueryResultCachedDocumentBuilderImpl() {
        }

        @Override
        protected InlineQueryResultCachedDocumentBuilderImpl self() {
            return this;
        }

        @Override
        public InlineQueryResultCachedDocument build() {
            return new InlineQueryResultCachedDocument(this);
        }
    }
}

