/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=LocationBuilderImpl.class)
public class Location
implements BotApiObject {
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String HORIZONTALACCURACY_FIELD = "horizontal_accuracy";
    private static final String LIVEPERIOD_FIELD = "live_period";
    private static final String HEADING_FIELD = "heading";
    private static final String PROXMITYALERTRADIUS_FIELD = "proximity_alert_radius";
    @JsonProperty(value="longitude")
    @NonNull
    private Double longitude;
    @JsonProperty(value="latitude")
    @NonNull
    private Double latitude;
    @JsonProperty(value="horizontal_accuracy")
    private Double horizontalAccuracy;
    @JsonProperty(value="live_period")
    private Integer livePeriod;
    @JsonProperty(value="heading")
    private Integer heading;
    @JsonProperty(value="proximity_alert_radius")
    private Integer proximityAlertRadius;

    protected Location(LocationBuilder<?, ?> b) {
        this.longitude = b.longitude;
        if (this.longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.latitude = b.latitude;
        if (this.latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.horizontalAccuracy = b.horizontalAccuracy;
        this.livePeriod = b.livePeriod;
        this.heading = b.heading;
        this.proximityAlertRadius = b.proximityAlertRadius;
    }

    public static LocationBuilder<?, ?> builder() {
        return new LocationBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$horizontalAccuracy = this.getHorizontalAccuracy();
        Double other$horizontalAccuracy = other.getHorizontalAccuracy();
        if (this$horizontalAccuracy == null ? other$horizontalAccuracy != null : !((Object)this$horizontalAccuracy).equals(other$horizontalAccuracy)) {
            return false;
        }
        Integer this$livePeriod = this.getLivePeriod();
        Integer other$livePeriod = other.getLivePeriod();
        if (this$livePeriod == null ? other$livePeriod != null : !((Object)this$livePeriod).equals(other$livePeriod)) {
            return false;
        }
        Integer this$heading = this.getHeading();
        Integer other$heading = other.getHeading();
        if (this$heading == null ? other$heading != null : !((Object)this$heading).equals(other$heading)) {
            return false;
        }
        Integer this$proximityAlertRadius = this.getProximityAlertRadius();
        Integer other$proximityAlertRadius = other.getProximityAlertRadius();
        return !(this$proximityAlertRadius == null ? other$proximityAlertRadius != null : !((Object)this$proximityAlertRadius).equals(other$proximityAlertRadius));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $horizontalAccuracy = this.getHorizontalAccuracy();
        result = result * 59 + ($horizontalAccuracy == null ? 43 : ((Object)$horizontalAccuracy).hashCode());
        Integer $livePeriod = this.getLivePeriod();
        result = result * 59 + ($livePeriod == null ? 43 : ((Object)$livePeriod).hashCode());
        Integer $heading = this.getHeading();
        result = result * 59 + ($heading == null ? 43 : ((Object)$heading).hashCode());
        Integer $proximityAlertRadius = this.getProximityAlertRadius();
        result = result * 59 + ($proximityAlertRadius == null ? 43 : ((Object)$proximityAlertRadius).hashCode());
        return result;
    }

    @NonNull
    public Double getLongitude() {
        return this.longitude;
    }

    @NonNull
    public Double getLatitude() {
        return this.latitude;
    }

    public Double getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public Integer getLivePeriod() {
        return this.livePeriod;
    }

    public Integer getHeading() {
        return this.heading;
    }

    public Integer getProximityAlertRadius() {
        return this.proximityAlertRadius;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(@NonNull Double longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(@NonNull Double latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="horizontal_accuracy")
    public void setHorizontalAccuracy(Double horizontalAccuracy) {
        this.horizontalAccuracy = horizontalAccuracy;
    }

    @JsonProperty(value="live_period")
    public void setLivePeriod(Integer livePeriod) {
        this.livePeriod = livePeriod;
    }

    @JsonProperty(value="heading")
    public void setHeading(Integer heading) {
        this.heading = heading;
    }

    @JsonProperty(value="proximity_alert_radius")
    public void setProximityAlertRadius(Integer proximityAlertRadius) {
        this.proximityAlertRadius = proximityAlertRadius;
    }

    public String toString() {
        return "Location(longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", horizontalAccuracy=" + this.getHorizontalAccuracy() + ", livePeriod=" + this.getLivePeriod() + ", heading=" + this.getHeading() + ", proximityAlertRadius=" + this.getProximityAlertRadius() + ")";
    }

    public Location(@NonNull Double longitude, @NonNull Double latitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public static abstract class LocationBuilder<C extends Location, B extends LocationBuilder<C, B>> {
        private Double longitude;
        private Double latitude;
        private Double horizontalAccuracy;
        private Integer livePeriod;
        private Integer heading;
        private Integer proximityAlertRadius;

        @JsonProperty(value="longitude")
        public B longitude(@NonNull Double longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return this.self();
        }

        @JsonProperty(value="latitude")
        public B latitude(@NonNull Double latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return this.self();
        }

        @JsonProperty(value="horizontal_accuracy")
        public B horizontalAccuracy(Double horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
            return this.self();
        }

        @JsonProperty(value="live_period")
        public B livePeriod(Integer livePeriod) {
            this.livePeriod = livePeriod;
            return this.self();
        }

        @JsonProperty(value="heading")
        public B heading(Integer heading) {
            this.heading = heading;
            return this.self();
        }

        @JsonProperty(value="proximity_alert_radius")
        public B proximityAlertRadius(Integer proximityAlertRadius) {
            this.proximityAlertRadius = proximityAlertRadius;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Location.LocationBuilder(longitude=" + this.longitude + ", latitude=" + this.latitude + ", horizontalAccuracy=" + this.horizontalAccuracy + ", livePeriod=" + this.livePeriod + ", heading=" + this.heading + ", proximityAlertRadius=" + this.proximityAlertRadius + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class LocationBuilderImpl
    extends LocationBuilder<Location, LocationBuilderImpl> {
        private LocationBuilderImpl() {
        }

        @Override
        protected LocationBuilderImpl self() {
            return this;
        }

        @Override
        public Location build() {
            return new Location(this);
        }
    }
}

