/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.payments.ShippingOption;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=AnswerShippingQueryBuilderImpl.class)
public class AnswerShippingQuery
extends BotApiMethodBoolean {
    public static final String PATH = "answerShippingQuery";
    private static final String SHIPPING_QUERY_ID_FIELD = "shipping_query_id";
    private static final String OK_FIELD = "ok";
    private static final String SHIPPING_OPTIONS_FIELD = "shipping_options";
    private static final String ERROR_MESSAGE_FIELD = "error_message";
    @JsonProperty(value="shipping_query_id")
    @NonNull
    private String shippingQueryId;
    @JsonProperty(value="ok")
    @NonNull
    private Boolean ok;
    @JsonProperty(value="shipping_options")
    private List<ShippingOption> shippingOptions;
    @JsonProperty(value="error_message")
    private String errorMessage;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.shippingQueryId == null || this.shippingQueryId.isEmpty()) {
            throw new TelegramApiValidationException("ShippingQueryId can't be empty", this);
        }
        if (this.ok == null) {
            throw new TelegramApiValidationException("Ok can't be null", this);
        }
        if (this.ok.booleanValue()) {
            if (this.shippingOptions == null || this.shippingOptions.isEmpty()) {
                throw new TelegramApiValidationException("ShippingOptions array can't be empty if ok", this);
            }
            for (ShippingOption shippingOption : this.shippingOptions) {
                shippingOption.validate();
            }
        } else if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            throw new TelegramApiValidationException("ErrorMessage can't be empty if not ok", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    protected AnswerShippingQuery(AnswerShippingQueryBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.shippingQueryId = b.shippingQueryId;
        if (this.shippingQueryId == null) {
            throw new NullPointerException("shippingQueryId is marked non-null but is null");
        }
        this.ok = b.ok;
        if (this.ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.shippingOptions = b.shippingOptions;
        this.errorMessage = b.errorMessage;
    }

    public static AnswerShippingQueryBuilder<?, ?> builder() {
        return new AnswerShippingQueryBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerShippingQuery)) {
            return false;
        }
        AnswerShippingQuery other = (AnswerShippingQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ok = this.getOk();
        Boolean other$ok = other.getOk();
        if (this$ok == null ? other$ok != null : !((Object)this$ok).equals(other$ok)) {
            return false;
        }
        String this$shippingQueryId = this.getShippingQueryId();
        String other$shippingQueryId = other.getShippingQueryId();
        if (this$shippingQueryId == null ? other$shippingQueryId != null : !this$shippingQueryId.equals(other$shippingQueryId)) {
            return false;
        }
        List<ShippingOption> this$shippingOptions = this.getShippingOptions();
        List<ShippingOption> other$shippingOptions = other.getShippingOptions();
        if (this$shippingOptions == null ? other$shippingOptions != null : !((Object)this$shippingOptions).equals(other$shippingOptions)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnswerShippingQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ok = this.getOk();
        result = result * 59 + ($ok == null ? 43 : ((Object)$ok).hashCode());
        String $shippingQueryId = this.getShippingQueryId();
        result = result * 59 + ($shippingQueryId == null ? 43 : $shippingQueryId.hashCode());
        List<ShippingOption> $shippingOptions = this.getShippingOptions();
        result = result * 59 + ($shippingOptions == null ? 43 : ((Object)$shippingOptions).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @NonNull
    public String getShippingQueryId() {
        return this.shippingQueryId;
    }

    @NonNull
    public Boolean getOk() {
        return this.ok;
    }

    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="shipping_query_id")
    public void setShippingQueryId(@NonNull String shippingQueryId) {
        if (shippingQueryId == null) {
            throw new NullPointerException("shippingQueryId is marked non-null but is null");
        }
        this.shippingQueryId = shippingQueryId;
    }

    @JsonProperty(value="ok")
    public void setOk(@NonNull Boolean ok) {
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.ok = ok;
    }

    @JsonProperty(value="shipping_options")
    public void setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    @JsonProperty(value="error_message")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String toString() {
        return "AnswerShippingQuery(shippingQueryId=" + this.getShippingQueryId() + ", ok=" + this.getOk() + ", shippingOptions=" + this.getShippingOptions() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public AnswerShippingQuery(@NonNull String shippingQueryId, @NonNull Boolean ok) {
        if (shippingQueryId == null) {
            throw new NullPointerException("shippingQueryId is marked non-null but is null");
        }
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.shippingQueryId = shippingQueryId;
        this.ok = ok;
    }

    public AnswerShippingQuery(@NonNull String shippingQueryId, @NonNull Boolean ok, List<ShippingOption> shippingOptions, String errorMessage) {
        if (shippingQueryId == null) {
            throw new NullPointerException("shippingQueryId is marked non-null but is null");
        }
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.shippingQueryId = shippingQueryId;
        this.ok = ok;
        this.shippingOptions = shippingOptions;
        this.errorMessage = errorMessage;
    }

    public static abstract class AnswerShippingQueryBuilder<C extends AnswerShippingQuery, B extends AnswerShippingQueryBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        private String shippingQueryId;
        private Boolean ok;
        private List<ShippingOption> shippingOptions;
        private String errorMessage;

        @JsonProperty(value="shipping_query_id")
        public B shippingQueryId(@NonNull String shippingQueryId) {
            if (shippingQueryId == null) {
                throw new NullPointerException("shippingQueryId is marked non-null but is null");
            }
            this.shippingQueryId = shippingQueryId;
            return (B)this.self();
        }

        @JsonProperty(value="ok")
        public B ok(@NonNull Boolean ok) {
            if (ok == null) {
                throw new NullPointerException("ok is marked non-null but is null");
            }
            this.ok = ok;
            return (B)this.self();
        }

        @JsonProperty(value="shipping_options")
        public B shippingOptions(List<ShippingOption> shippingOptions) {
            this.shippingOptions = shippingOptions;
            return (B)this.self();
        }

        @JsonProperty(value="error_message")
        public B errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AnswerShippingQuery.AnswerShippingQueryBuilder(super=" + super.toString() + ", shippingQueryId=" + this.shippingQueryId + ", ok=" + this.ok + ", shippingOptions=" + this.shippingOptions + ", errorMessage=" + this.errorMessage + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class AnswerShippingQueryBuilderImpl
    extends AnswerShippingQueryBuilder<AnswerShippingQuery, AnswerShippingQueryBuilderImpl> {
        private AnswerShippingQueryBuilderImpl() {
        }

        @Override
        protected AnswerShippingQueryBuilderImpl self() {
            return this;
        }

        @Override
        public AnswerShippingQuery build() {
            return new AnswerShippingQuery(this);
        }
    }
}

