/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.maven;

import com.github.jknack.handlebars.internal.text.StringTokenizer;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.teiid.maven.ApiGenerator;
import org.teiid.maven.CodeGenerator;
import org.teiid.maven.DataSourceCodeGenerator;
import org.teiid.maven.MaterializationEnhancer;
import org.teiid.maven.PluginDatabaseStore;
import org.teiid.maven.ZipUtils;
import org.teiid.metadata.Database;
import org.teiid.metadata.Server;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.spring.common.ExternalSource;
import org.teiid.spring.common.ExternalSources;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="vdb-codegen", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, requiresProject=true, threadSafe=true)
public class VdbCodeGeneratorMojo
extends AbstractMojo {
    public static final SystemFunctionManager SFM = SystemMetadata.getInstance().getSystemFunctionManager();
    public static final String ISPN = "infinispan-hotrod";
    @Parameter(defaultValue="${basedir}/src/main/resources/teiid.ddl")
    private File vdbFile;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/teiid-sb")
    private File outputDirectory;
    @Parameter
    private String packageName;
    @Parameter
    private Boolean generateApplicationClass = true;
    @Parameter
    private Boolean generateDataSourceClasses = true;
    @Parameter
    private Boolean generatePomXml = false;
    @Parameter
    private Boolean generateApplicationProperties = false;
    @Parameter(defaultValue="${basedir}/src/main/resources/openapi.json")
    private File openApiFile;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter
    private String componentScanPackageNames = "org.teiid.spring.data";
    @Parameter
    private String materializationType = "infinispan-hotrod";
    @Parameter
    private Boolean materializationEnable = false;
    @Parameter
    private String vdbVersion = "";
    @Parameter
    private File yamlFile;

    public File getOutputDirectory() {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return this.outputDirectory;
    }

    public File getJavaSrcDirectory() {
        String codeDirectory = this.packageName.replace('.', '/');
        File javaSrcDir = new File(this.getOutputDirectory() + "/src/main/java", codeDirectory);
        if (!javaSrcDir.exists()) {
            javaSrcDir.mkdirs();
        }
        return javaSrcDir;
    }

    public File getResourceDirectory() {
        File resourcesDir = new File(this.getOutputDirectory() + "/src/main/resources");
        if (!resourcesDir.exists()) {
            resourcesDir.mkdirs();
        }
        return resourcesDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            String ymlFile;
            if (this.packageName == null) {
                this.packageName = this.project.getGroupId();
            }
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            ClassLoader pluginClassloader = this.getClassLoader();
            Thread.currentThread().setContextClassLoader(pluginClassloader);
            ExternalSources sources = new ExternalSources();
            StringTokenizer st = new StringTokenizer(this.componentScanPackageNames, ",");
            while (st.hasNext()) {
                sources.loadConnctionFactories(pluginClassloader, st.next());
            }
            boolean validateDependencies = true;
            Map<?, ?> yamlContents = null;
            if (this.yamlFile != null && this.yamlFile.exists()) {
                yamlContents = this.processYamlVdb();
                this.vdbFile = this.grabVdbFromYaml(yamlContents);
                this.generatePomXml = true;
                this.generateApplicationProperties = true;
                this.generateApplicationClass = false;
                this.generateDataSourceClasses = false;
                validateDependencies = false;
            }
            File vdbfile = this.getVDBFile();
            PluginDatabaseStore databaseStore = this.getDatabaseStore(vdbfile);
            Database database = databaseStore.db();
            this.getLog().info((CharSequence)("Materialization enabled: " + this.materializationEnable));
            this.getLog().info((CharSequence)("Materialization type: " + this.materializationType));
            MaterializationEnhancer materialization = new MaterializationEnhancer(this.materializationType, this.getLog(), this.vdbVersion);
            if (this.materializationEnable.booleanValue() && materialization.isMaterializationRequired(databaseStore)) {
                this.getLog().info((CharSequence)("VDB requires Materialization Intrumentation: " + databaseStore.db().getName()));
                materialization.instrumentForMaterialization(databaseStore, this.getResourceDirectory());
                Resource resource = new Resource();
                resource.setDirectory(this.getOutputDirectory().getPath() + "/src/main/resources");
                this.project.addResource(resource);
            }
            HashMap<String, String> parentMap = new HashMap<String, String>();
            parentMap.put("packageName", this.packageName);
            parentMap.put("vdbName", database.getName());
            parentMap.put("vdbDescription", database.getAnnotation());
            if (this.generateOpenApiScoffolding()) {
                parentMap.put("openapi", this.generateOpenApiScoffolding() ? "true" : "false");
            }
            if (this.generateApplicationClass.booleanValue()) {
                this.createApplication((MustacheFactory)mf, database, parentMap);
            }
            if (this.generateDataSourceClasses.booleanValue()) {
                this.walkDataSources(database, parentMap, sources, new DataSourceCodeGenerator((MustacheFactory)mf, this.getJavaSrcDirectory(), pluginClassloader));
            }
            if (validateDependencies) {
                this.verifyTranslatorDependencies(database, sources, pluginClassloader);
            }
            if (this.generatePomXml.booleanValue()) {
                this.createPomXml(database, yamlContents, (MustacheFactory)mf, parentMap);
            }
            if (this.generateApplicationProperties.booleanValue()) {
                this.createApplicationProperties(database, yamlContents, (MustacheFactory)mf, parentMap, sources);
            }
            if (!this.openApiFile.exists() && !(ymlFile = this.openApiFile.getAbsolutePath().replace("openapi.json", "openapi.yml")).contentEquals(this.openApiFile.getAbsolutePath())) {
                this.openApiFile = new File(ymlFile);
            }
            if (this.generateOpenApiScoffolding() && this.openApiFile.exists()) {
                this.getLog().info((CharSequence)("Found the OpenAPI document at " + this.openApiFile.getAbsolutePath()));
                ApiGenerator generator = new ApiGenerator(this.openApiFile, this.outputDirectory, this.getLog());
                generator.generate((MustacheFactory)mf, this.getJavaSrcDirectory(), database, parentMap);
            } else {
                this.getLog().info((CharSequence)"No OpenAPI document found, no classes for the OpenAPI will be generated ");
            }
            this.project.addCompileSourceRoot(this.getJavaSrcDirectory().getAbsolutePath());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error running the vdb-codegen-plugin.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private Map<?, ?> processYamlVdb() throws FileNotFoundException, IOException {
        Yaml yaml = new Yaml();
        FileInputStream fis = new FileInputStream(this.yamlFile);
        Map yamlContents = (Map)yaml.loadAs((InputStream)fis, Map.class);
        fis.close();
        return (Map)yamlContents.get("spec");
    }

    private File grabVdbFromYaml(Map<?, ?> spec) throws IOException {
        Map build = (Map)spec.get("build");
        Map source = (Map)build.get("source");
        String ddl = (String)source.get("ddl");
        if (ddl != null) {
            File f = new File(this.getResourceDirectory() + "/teiid.ddl");
            FileWriter fw = new FileWriter(f);
            fw.write(ddl);
            fw.close();
            return f;
        }
        return null;
    }

    private PluginDatabaseStore getDatabaseStore(File vdbfile) throws IOException {
        Map typeMap = SystemMetadata.getInstance().getRuntimeTypeMap();
        PluginDatabaseStore store = new PluginDatabaseStore(typeMap);
        store.parse(vdbfile);
        return store;
    }

    private void createApplication(MustacheFactory mf, Database database, HashMap<String, String> props) throws Exception {
        this.getLog().info((CharSequence)"Creating the Application.java class");
        Mustache mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/Application.mustache")), "application");
        FileWriter out = new FileWriter(new File(this.getJavaSrcDirectory(), "Application.java"));
        mustache.execute((Writer)out, props);
        ((Writer)out).close();
    }

    private void verifyTranslatorDependencies(Database database, ExternalSources sources, ClassLoader classloader) throws Exception {
        for (Server server : database.getServers()) {
            String translator = this.getBaseDataWrapper(database, server.getDataWrapper());
            ExternalSource es = sources.find(translator);
            if (es == null) {
                throw new MojoExecutionException("No supported source found with name:" + server.getDataWrapper());
            }
            boolean foundDependency = false;
            if (!es.isJdbc() || es.getDriverNames() == null || es.getDriverNames().length <= 0) continue;
            for (String driverName : es.getDriverNames()) {
                try {
                    Class.forName(driverName, false, classloader);
                    foundDependency = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
            if (foundDependency) continue;
            String str = "Drivers for translator \"" + server.getDataWrapper() + "\" can not be verified. Make sure you have the required dependencies in the pom.xml";
            this.getLog().error((CharSequence)str);
            throw new MojoExecutionException(str);
        }
    }

    private void createPomXml(Database database, Map<?, ?> spec, MustacheFactory mf, HashMap<String, String> props) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Server server : database.getServers()) {
            String translator = this.getBaseDataWrapper(database, server.getDataWrapper());
            sb.append("    <dependency>\n");
            sb.append("      <groupId>org.teiid</groupId>\n");
            sb.append("      <artifactId>spring-data-").append(translator).append("</artifactId>\n");
            sb.append("      <version>${teiid.springboot.version}</version>\n");
            sb.append("    </dependency>\n");
        }
        Map build = (Map)spec.get("build");
        Map source = (Map)build.get("source");
        List dependencies = (List)source.get("dependencies");
        if (dependencies != null) {
            for (String gav : dependencies) {
                int idx = gav.indexOf(58);
                int versionIdx = -1;
                if (idx != -1) {
                    versionIdx = gav.indexOf(idx, 58);
                }
                if (idx == -1 || versionIdx == -1) {
                    throw new MojoExecutionException("dependencies defined are not in correct GAV format. Must be in\"groupId:artifactId:version\" format.");
                }
                String groupId = gav.substring(0, idx);
                String artifactId = gav.substring(idx + 1, versionIdx);
                String version = gav.substring(versionIdx + 1);
                sb.append("    <dependency>\n");
                sb.append("      <groupId>").append(groupId).append("</groupId>\n");
                sb.append("      <artifactId>").append(artifactId).append("</artifactId>\n");
                sb.append("      <version>").append(version).append("</version>\n");
                sb.append("    </dependency>\n");
            }
        }
        props.put("vdbDependencies", sb.toString());
        this.getLog().info((CharSequence)"Creating the pom.xml");
        Mustache mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/pom.mustache")), "application");
        FileWriter out = new FileWriter(new File(this.getOutputDirectory(), "pom.xml"));
        mustache.execute((Writer)out, props);
        ((Writer)out).close();
    }

    private void createApplicationProperties(Database database, Map<?, ?> spec, MustacheFactory mf, HashMap<String, String> props, ExternalSources externalSources) throws Exception {
        StringBuilder sb = new StringBuilder();
        List dataSources = (List)spec.get("datasources");
        for (Object ds : dataSources) {
            Map datasource = (Map)ds;
            String name = (String)datasource.get("name");
            String type = (String)datasource.get("type");
            List properties = (List)datasource.get("properties");
            for (Object p : properties) {
                Map prop = (Map)p;
                sb.append("spring.teiid.data.").append(type).append(".").append(name).append(".").append((String)prop.get("name")).append("=").append((String)prop.get("value")).append("\n");
            }
        }
        props.put("dsProperties", sb.toString());
        this.getLog().info((CharSequence)"Creating the application.properties");
        Mustache mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/application_properties.mustache")), "application");
        FileWriter out = new FileWriter(new File(this.getResourceDirectory(), "application.properties"));
        mustache.execute((Writer)out, props);
        ((Writer)out).close();
    }

    private String getBaseDataWrapper(Database db, String name) {
        if (db.getDataWrapper(name) != null) {
            if (db.getDataWrapper(name).getType() == null) {
                return name;
            }
            return this.getBaseDataWrapper(db, db.getDataWrapper(name).getType());
        }
        return name;
    }

    private void walkDataSources(Database database, HashMap<String, String> parentMap, ExternalSources externalSources, CodeGenerator c) throws Exception {
        TreeMap<String, ExternalSource> sources = new TreeMap<String, ExternalSource>();
        for (ExternalSource source : externalSources.getItems().values()) {
            sources.put(source.getName(), source);
            if (sources.get(source.getTranslatorName()) != null) continue;
            sources.put(source.getTranslatorName(), source);
        }
        for (Server server : database.getServers()) {
            HashMap<String, String> tempMap = new HashMap<String, String>(parentMap);
            tempMap.put("dsName", server.getName());
            tempMap.put("sanitized-dsName", VdbCodeGeneratorMojo.removeCamelCase(server.getName()));
            this.getLog().info((CharSequence)("Building DataSource.java for source :" + server.getName()));
            String translator = this.getBaseDataWrapper(database, server.getDataWrapper());
            ExternalSource source = (ExternalSource)sources.get(translator);
            if (source == null) {
                throw new MojoExecutionException("No Source found with name :" + translator + " make sure it is supported source, if this a custom source, it is developed with @ConnectionFactoryConfiguration annotation");
            }
            tempMap.put("dsPropertyPrefix", "spring.teiid.data." + source.getName());
            c.generate(source, server, tempMap);
        }
    }

    static String removeCamelCase(String name) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        boolean lastCharIsCaptital = false;
        for (int i = 0; i < name.length(); ++i) {
            Character ch = Character.valueOf(name.charAt(i));
            if (Character.isWhitespace(ch.charValue()) || ch.charValue() == '.') {
                throw new MojoExecutionException("Space or dot (.) are not allowed in a property name : " + name);
            }
            if (Character.isUpperCase(ch.charValue())) {
                if (!lastCharIsCaptital && i > 0) {
                    sb.append('-');
                    sb.append(Character.toLowerCase(ch.charValue()));
                    lastCharIsCaptital = true;
                    continue;
                }
                sb.append(Character.toLowerCase(ch.charValue()));
                lastCharIsCaptital = true;
                continue;
            }
            sb.append(ch);
            lastCharIsCaptital = false;
        }
        return sb.toString();
    }

    private File getVDBFile() throws MojoExecutionException, IOException {
        if (this.vdbFile.exists()) {
            this.getLog().info((CharSequence)("Found VDB = " + this.vdbFile));
            if (this.vdbFile.getName().endsWith(".vdb")) {
                File vdbDir = this.unzipContents(this.vdbFile);
                this.vdbFile = new File(vdbDir, "/META-INF/vdb.ddl");
                File openapi = new File(vdbDir, "openapi.json");
                if (openapi.exists()) {
                    this.openApiFile = openapi;
                }
            }
            return this.vdbFile;
        }
        String f = this.vdbFile.getAbsolutePath().replace("teiid.ddl", "teiid.vdb");
        if (!f.contentEquals(this.vdbFile.getAbsolutePath())) {
            this.vdbFile = new File(f);
            if (this.vdbFile.exists()) {
                File vdbDir = this.unzipContents(this.vdbFile);
                this.vdbFile = new File(vdbDir, "/META-INF/vdb.ddl");
                File openapi = new File(vdbDir, "openapi.json");
                if (openapi.exists()) {
                    this.openApiFile = openapi;
                }
                return this.vdbFile;
            }
        }
        Set dependencies = this.project.getArtifacts();
        for (Artifact d : dependencies) {
            if (d.getFile() == null || !d.getFile().getName().endsWith(".vdb")) continue;
            File vdbDir = this.unzipContents(d);
            this.vdbFile = new File(vdbDir, "/META-INF/vdb.ddl");
            File openapi = new File(vdbDir, "openapi.json");
            if (openapi.exists()) {
                this.openApiFile = openapi;
            }
            return this.vdbFile;
        }
        throw new MojoExecutionException("No VDB File found at location " + this.vdbFile + " or no VDB dependencies found in pom.xml");
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String mavenCompilePath : this.project.getCompileClasspathElements()) {
                pathUrls.add(new File(mavenCompilePath).toURI().toURL());
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            this.getLog().debug((CharSequence)("urls for URLClassLoader: " + Arrays.asList(urlsForClassLoader)));
            return new URLClassLoader(urlsForClassLoader, VdbCodeGeneratorMojo.class.getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }

    private boolean generateOpenApiScoffolding() {
        List dependencies = this.project.getDependencies();
        for (Dependency d : dependencies) {
            String gav = d.getGroupId() + ":" + d.getArtifactId();
            if (!gav.equals("org.teiid:spring-openapi")) continue;
            this.getLog().info((CharSequence)"OpenAPI dependency is found in the pom.xml");
            return true;
        }
        this.getLog().info((CharSequence)"No OpenAPI dependency is found in the pom.xml, skipping the generation of the OpenAPI classes");
        return false;
    }

    private File unzipContents(Artifact d) throws IOException {
        File f = new File(this.outputDirectory.getPath(), d.getArtifactId());
        f.mkdirs();
        this.getLog().info((CharSequence)("unzipping " + d.getArtifactId() + " to directory " + f.getCanonicalPath()));
        return ZipUtils.unzipContents(d.getFile(), f);
    }

    public File unzipContents(File d) throws IOException {
        File f = new File(this.outputDirectory.getPath(), d.getName());
        f.mkdirs();
        this.getLog().info((CharSequence)("unzipping " + d.getName() + " to directory " + f.getCanonicalPath()));
        return ZipUtils.unzipContents(d, f);
    }
}

