/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.maven.plugin.logging.Log;
import org.teiid.maven.ImportSchemaAwareDDLStringVisitor;
import org.teiid.maven.PluginDatabaseStore;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Database;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;
import org.teiid.metadata.Table;

public class MaterializationEnhancer {
    static final String CACHE_STORE = "cacheStore";
    private String type;
    private Log log;
    private String version;

    public MaterializationEnhancer(String type, Log log, String version) {
        this.type = type;
        this.log = log;
        this.version = version;
    }

    public boolean isMaterializationRequired(PluginDatabaseStore databaseStore) {
        Database database = databaseStore.db();
        for (Schema schema : database.getSchemas()) {
            if (schema.isPhysical()) continue;
            for (Table table : schema.getTables().values()) {
                if (!table.isMaterialized() || table.getMaterializedTable() != null) continue;
                return true;
            }
        }
        return false;
    }

    public void instrumentForMaterialization(PluginDatabaseStore databaseStore, File resourcesDir) throws Exception {
        Database database = databaseStore.db();
        String schemaName = "materialized_" + this.version;
        Server server = new Server(CACHE_STORE);
        server.setDataWrapper(this.type);
        database.addServer(server);
        MetadataFactory factory = new MetadataFactory(database.getName(), (Object)database.getVersion(), schemaName, (Map)database.getMetadataStore().getDatatypes(), null, null);
        Schema matSchema = factory.getSchema();
        matSchema.setVisible(false);
        matSchema.setPhysical(true);
        matSchema.addServer(server);
        database.addSchema(matSchema);
        Table statusTable = this.buildStatusTable(factory);
        for (Schema schema : database.getSchemas()) {
            if (schema.isPhysical()) continue;
            for (Table table : schema.getTables().values()) {
                if (!table.isMaterialized() || table.getMaterializedTable() != null) continue;
                Table matTable = this.cloneTable(factory, table);
                matSchema.addTable(matTable);
                table.setProperty("MATERIALIZED_TABLE", matTable.getFullName());
                table.setProperty("teiid_rel:ALLOW_MATVIEW_MANAGEMENT", "true");
                table.setProperty("teiid_rel:MATVIEW_LOADNUMBER_COLUMN", "LoadNumber");
                table.setProperty("teiid_rel:MATVIEW_STATUS_TABLE", statusTable.getFullName());
            }
        }
        databaseStore.importSchema(schemaName, null, CACHE_STORE, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
        ImportSchemaAwareDDLStringVisitor visitor = new ImportSchemaAwareDDLStringVisitor(databaseStore, null, null);
        visitor.visit(databaseStore.db());
        String vdbDDL = visitor.toString();
        this.log.info((CharSequence)("Materialization based VDB: " + vdbDDL));
        File file = new File(resourcesDir, "materialized.ddl");
        this.log.info((CharSequence)("Materialization Written to : " + file.getAbsolutePath()));
        FileWriter fw = new FileWriter(file);
        fw.write(vdbDDL);
        fw.close();
    }

    private Table buildStatusTable(MetadataFactory factory) {
        Table tbl = factory.addTable("status");
        tbl.setName(this.sanitize(factory.getVdbName() + "_" + tbl.getFullName()));
        Column c = factory.addColumn("VDBName", "string", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(50);
        c = factory.addColumn("VDBVersion", "string", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(50);
        c = factory.addColumn("SchemaName", "string", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(50);
        c = factory.addColumn("Name", "string", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(256);
        c = factory.addColumn("TargetSchemaName", "string", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(50);
        c = factory.addColumn("TargetName", "string", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(256);
        c = factory.addColumn("Valid", "boolean", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(50);
        c = factory.addColumn("LoadState", "string", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(25);
        c = factory.addColumn("Cardinality", "long", (ColumnSet)tbl);
        c = factory.addColumn("Updated", "timestamp", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c = factory.addColumn("LoadNumber", "long", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c = factory.addColumn("NodeName", "string", (ColumnSet)tbl);
        c.setNullType(BaseColumn.NullType.No_Nulls);
        c.setLength(25);
        c = factory.addColumn("StaleCount", "long", (ColumnSet)tbl);
        factory.addPrimaryKey("PK", Arrays.asList("VDBName", "VDBVersion", "SchemaName", "Name"), tbl);
        tbl.setSupportsUpdate(true);
        for (Column col : tbl.getColumns()) {
            col.setUpdatable(true);
        }
        if (this.type.equalsIgnoreCase("infinispan-hotrod")) {
            tbl.setProperty("teiid_ispn:cache", tbl.getName());
        }
        return tbl;
    }

    private String sanitize(String str) {
        return str.replace('.', '_').replace('-', '_');
    }

    private Table cloneTable(MetadataFactory factory, Table table) throws Exception {
        Table matTable = (Table)SerializationUtils.clone((Serializable)table);
        matTable.setVirtual(false);
        matTable.setMaterialized(false);
        matTable.setSupportsUpdate(true);
        matTable.setName(this.sanitize(factory.getVdbName() + "_" + table.getFullName()));
        factory.addColumn("LoadNumber", "long", (ColumnSet)matTable);
        for (Column c : matTable.getColumns()) {
            c.setUpdatable(true);
        }
        for (String key : matTable.getProperties().keySet()) {
            if (!key.startsWith("teiid_rel:MATVIEW")) continue;
            matTable.setProperty(key, null);
        }
        if (this.type.equalsIgnoreCase("infinispan-hotrod")) {
            matTable.setProperty("teiid_ispn:cache", matTable.getName());
        }
        return matTable;
    }
}

