/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.maven;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.teiid.maven.CodeGenerator;
import org.teiid.maven.VdbCodeGeneratorMojo;
import org.teiid.metadata.Server;
import org.teiid.spring.common.ExternalSource;

public class DataSourceCodeGenerator
implements CodeGenerator {
    private MustacheFactory mf;
    private File javaSrcDir;
    private ClassLoader classLoader;

    public DataSourceCodeGenerator(MustacheFactory mf, File javaSrcDir, ClassLoader classLoader) {
        this.mf = mf;
        this.javaSrcDir = javaSrcDir;
        this.classLoader = classLoader;
    }

    @Override
    public void generate(ExternalSource source, Server server, Map<String, String> props) throws MojoExecutionException {
        try {
            Mustache mustache = DataSourceCodeGenerator.loadMustache(this.mf, source, this.classLoader);
            if (mustache == null) {
                throw new MojoExecutionException("Failed to generate source for name :" + source.getTranslatorName() + " make sure it is supported source, if this a custom source, it is developed with @ConnectionFactoryConfiguration annotation and Mustache file is provided");
            }
            FileWriter out = new FileWriter(new File(this.javaSrcDir, "DataSources" + server.getName() + ".java"));
            mustache.execute((Writer)out, props);
            ((Writer)out).close();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    static Mustache loadMustache(MustacheFactory mf, ExternalSource source, ClassLoader classLoader) {
        Mustache mustache = null;
        InputStream is = classLoader.getResourceAsStream(source.getName() + ".mustache");
        mustache = is != null ? mf.compile((Reader)new InputStreamReader(is), source.getName().toLowerCase()) : mf.compile((Reader)new InputStreamReader(VdbCodeGeneratorMojo.class.getResourceAsStream("/templates/Jdbc.mustache")), source.getName().toLowerCase());
        return mustache;
    }
}

