/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.maven;

import com.github.mustachejava.MustacheFactory;
import java.io.File;
import java.util.HashMap;
import org.apache.maven.plugin.logging.Log;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.CodegenConfigurator;
import org.teiid.metadata.Database;

public class ApiGenerator {
    private File openApiFile;
    private File outputDirectory;
    private Log log;

    public ApiGenerator(File openApiFile, File outputDirectory, Log log) {
        this.openApiFile = openApiFile;
        this.outputDirectory = outputDirectory;
        this.log = log;
    }

    protected void generate(MustacheFactory mf, File javaSrcDir, Database database, HashMap<String, String> parentMap) throws Exception {
        this.log.info((CharSequence)("Starting to Generate the Java classes for OpenAPI document: " + this.openApiFile.getCanonicalPath()));
        String packageName = parentMap.get("packageName");
        String outputDir = this.outputDirectory.getAbsolutePath();
        CodegenConfigurator configurator = new CodegenConfigurator();
        configurator.setPackageName(packageName);
        configurator.setApiPackage(packageName);
        configurator.addDynamicProperty("configPackage", (Object)packageName);
        configurator.addDynamicProperty("basePackage", (Object)packageName);
        configurator.setModelPackage(packageName);
        configurator.setInputSpec(this.openApiFile.getAbsolutePath());
        configurator.setGeneratorName("org.teiid.maven.TeiidCodegen");
        configurator.setOutputDir(outputDir);
        configurator.setLibrary("spring-boot");
        configurator.addDynamicProperty("delegatePattern", (Object)"true");
        configurator.setIgnoreFileOverride(null);
        ClientOptInput input = configurator.toClientOptInput();
        new DefaultGenerator().opts(input).generate();
        this.log.info((CharSequence)("Generated the Java classes for OpenAPI document: " + this.openApiFile.getCanonicalPath()));
    }
}

