/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.maven;

import com.github.jknack.handlebars.internal.text.StringTokenizer;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.teiid.maven.ApiGenerator;
import org.teiid.maven.MaterializationEnhancer;
import org.teiid.maven.PluginDatabaseStore;
import org.teiid.metadata.Database;
import org.teiid.metadata.Server;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.spring.common.ExternalSource;
import org.teiid.spring.common.ExternalSources;

@Mojo(name="vdb-codegen", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, requiresProject=true, threadSafe=true)
public class VdbCodeGeneratorMojo
extends AbstractMojo {
    public static final SystemFunctionManager SFM = SystemMetadata.getInstance().getSystemFunctionManager();
    public static final String ISPN = "infinispan-hotrod";
    @Parameter(defaultValue="${basedir}/src/main/resources/teiid.ddl")
    private File vdbFile;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/teiid-sb")
    private File outputDirectory;
    @Parameter
    private String packageName;
    @Parameter
    private Boolean generateApplicationClass = true;
    @Parameter
    private Boolean generateDataSourceClasses = true;
    @Parameter(defaultValue="${basedir}/src/main/resources/openapi.json")
    private File openApiFile;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter
    private String componentScanPackageNames = "org.teiid.spring.data";
    @Parameter
    private String materializationType = "infinispan-hotrod";
    @Parameter
    private Boolean materializationEnable = false;
    @Parameter
    private String vdbVersion = "";

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            String ymlFile;
            File resourcesDir;
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            ClassLoader pluginClassloader = this.getClassLoader();
            Thread.currentThread().setContextClassLoader(pluginClassloader);
            File outputDir = this.getOutputDirectory();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            if (this.packageName == null) {
                this.packageName = this.project.getGroupId();
            }
            String codeDirectory = this.packageName.replace('.', '/');
            File javaSrcDir = new File(this.getOutputDirectory() + "/src/main/java", codeDirectory);
            if (!javaSrcDir.exists()) {
                javaSrcDir.mkdirs();
            }
            if (!(resourcesDir = new File(this.getOutputDirectory() + "/src/main/resources")).exists()) {
                resourcesDir.mkdirs();
            }
            ExternalSources sources = new ExternalSources();
            StringTokenizer st = new StringTokenizer(this.componentScanPackageNames, ",");
            while (st.hasNext()) {
                sources.loadConnctionFactories(pluginClassloader, st.next());
            }
            File vdbfile = this.getVDBFile();
            PluginDatabaseStore databaseStore = this.getDatabaseStore(vdbfile);
            Database database = databaseStore.db();
            this.getLog().info((CharSequence)("Materialization enabled: " + this.materializationEnable));
            this.getLog().info((CharSequence)("Materialization type: " + this.materializationType));
            MaterializationEnhancer materialization = new MaterializationEnhancer(this.materializationType, this.getLog(), this.vdbVersion);
            if (this.materializationEnable.booleanValue() && materialization.isMaterializationRequired(databaseStore)) {
                this.getLog().info((CharSequence)("VDB requires Materialization Intrumentation: " + databaseStore.db().getName()));
                materialization.instrumentForMaterialization(databaseStore, resourcesDir);
                Resource resource = new Resource();
                resource.setDirectory(this.getOutputDirectory().getPath() + "/src/main/resources");
                this.project.addResource(resource);
            }
            HashMap<String, String> parentMap = new HashMap<String, String>();
            parentMap.put("packageName", this.packageName);
            parentMap.put("vdbName", database.getName());
            parentMap.put("vdbDescription", database.getAnnotation());
            if (this.generateOpenApiScoffolding()) {
                parentMap.put("openapi", this.generateOpenApiScoffolding() ? "true" : "false");
            }
            if (this.generateApplicationClass.booleanValue()) {
                this.createApplication((MustacheFactory)mf, javaSrcDir, database, parentMap);
            }
            if (this.generateDataSourceClasses.booleanValue()) {
                this.createDataSources((MustacheFactory)mf, javaSrcDir, database, parentMap, pluginClassloader, sources);
            }
            this.verifyTranslatorDependencies(database, sources);
            if (!this.openApiFile.exists() && !(ymlFile = this.openApiFile.getAbsolutePath().replace("openapi.json", "openapi.yml")).contentEquals(this.openApiFile.getAbsolutePath())) {
                this.openApiFile = new File(ymlFile);
            }
            if (this.generateOpenApiScoffolding() && this.openApiFile.exists()) {
                this.getLog().info((CharSequence)("Found the OpenAPI document at " + this.openApiFile.getAbsolutePath()));
                ApiGenerator generator = new ApiGenerator(this.openApiFile, this.outputDirectory, this.getLog());
                generator.generate((MustacheFactory)mf, javaSrcDir, database, parentMap);
            } else {
                this.getLog().info((CharSequence)"No OpenAPI document found, no classes for the OpenAPI will be generated ");
            }
            this.project.addCompileSourceRoot(javaSrcDir.getAbsolutePath());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error running the vdb-codegen-plugin.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private PluginDatabaseStore getDatabaseStore(File vdbfile) throws IOException {
        Map typeMap = SystemMetadata.getInstance().getRuntimeTypeMap();
        PluginDatabaseStore store = new PluginDatabaseStore(typeMap);
        store.parse(vdbfile);
        return store;
    }

    private void createApplication(MustacheFactory mf, File javaSrcDir, Database database, HashMap<String, String> props) throws Exception {
        this.getLog().info((CharSequence)"Creating the Application.java class");
        Mustache mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/Application.mustache")), "application");
        FileWriter out = new FileWriter(new File(javaSrcDir, "Application.java"));
        mustache.execute((Writer)out, props);
        ((Writer)out).close();
    }

    private void verifyTranslatorDependencies(Database database, ExternalSources sources) throws Exception {
        for (Server server : database.getServers()) {
            String translator = this.getBaseDataWrapper(database, server.getDataWrapper());
            ExternalSource es = sources.find(translator);
            if (es == null) {
                throw new MojoExecutionException("No supported source found with name:" + server.getDataWrapper());
            }
            boolean foundDependency = false;
            if (es.getGav() != null) {
                for (String g : es.getGav()) {
                    foundDependency = false;
                    List dependencies = this.project.getDependencies();
                    for (Dependency d : dependencies) {
                        String gav = d.getGroupId() + ":" + d.getArtifactId();
                        if (!g.equals(gav)) continue;
                        this.getLog().info((CharSequence)("Found dependency:" + gav));
                        foundDependency = true;
                    }
                    if (!foundDependency) break;
                }
            }
            if (foundDependency) continue;
            boolean throwError = false;
            StringBuilder sb = new StringBuilder();
            if (es.getGav() != null) {
                for (String g : es.getGav()) {
                    sb.append("Drivers for translator \"" + server.getDataWrapper() + "\" are not found. Include following dependecy in pom.xml\n<dependency>\n    <groupId>" + g.substring(0, g.indexOf(58)) + "</groupId>\n    <artifactId>" + g.substring(g.indexOf(58) + 1) + "</artifactId>\n</dependency>\n\n");
                    throwError = true;
                }
            } else {
                this.getLog().error((CharSequence)("Drivers for translator \"" + server.getDataWrapper() + "\" can not be verified. Make sure you have the required dependencies in the pom.xml"));
            }
            if (!throwError) continue;
            throw new MojoExecutionException(sb.toString());
        }
    }

    private String getBaseDataWrapper(Database db, String name) {
        if (db.getDataWrapper(name) != null) {
            if (db.getDataWrapper(name).getType() == null) {
                return name;
            }
            return this.getBaseDataWrapper(db, db.getDataWrapper(name).getType());
        }
        return name;
    }

    private void createDataSources(MustacheFactory mf, File javaSrcDir, Database database, HashMap<String, String> parentMap, ClassLoader classLoader, ExternalSources externalSources) throws Exception {
        TreeMap<String, ExternalSource> sources = new TreeMap<String, ExternalSource>();
        for (ExternalSource source : externalSources.getItems().values()) {
            sources.put(source.getName(), source);
            if (sources.get(source.getTranslatorName()) != null) continue;
            sources.put(source.getTranslatorName(), source);
        }
        for (Server server : database.getServers()) {
            HashMap<String, String> tempMap = new HashMap<String, String>(parentMap);
            tempMap.put("dsName", server.getName());
            tempMap.put("sanitized-dsName", VdbCodeGeneratorMojo.removeCamelCase(server.getName()));
            this.getLog().info((CharSequence)("Building DataSource.java for source :" + server.getName()));
            String translator = this.getBaseDataWrapper(database, server.getDataWrapper());
            ExternalSource source = (ExternalSource)sources.get(translator);
            if (source == null) {
                throw new MojoExecutionException("No Source found with name :" + translator + " make sure it is supported source, if this a custom source, it is developed with @ConnectionFactoryConfiguration annotation");
            }
            Mustache mustache = VdbCodeGeneratorMojo.loadMustache(mf, source, classLoader);
            if (mustache != null) {
                FileWriter out = new FileWriter(new File(javaSrcDir, "DataSources" + server.getName() + ".java"));
                mustache.execute((Writer)out, tempMap);
                ((Writer)out).close();
                continue;
            }
            throw new MojoExecutionException("Failed to generate source for name :" + translator + " make sure it is supported source, if this a custom source, it is developed with @ConnectionFactoryConfiguration annotation and Mustache file is provided");
        }
    }

    static String removeCamelCase(String name) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        boolean lastCharIsCaptital = false;
        for (int i = 0; i < name.length(); ++i) {
            Character ch = Character.valueOf(name.charAt(i));
            if (Character.isWhitespace(ch.charValue()) || ch.charValue() == '.') {
                throw new MojoExecutionException("Space or dot (.) are not allowed in a property name : " + name);
            }
            if (Character.isUpperCase(ch.charValue())) {
                if (!lastCharIsCaptital && i > 0) {
                    sb.append('-');
                    sb.append(Character.toLowerCase(ch.charValue()));
                    lastCharIsCaptital = true;
                    continue;
                }
                sb.append(Character.toLowerCase(ch.charValue()));
                lastCharIsCaptital = true;
                continue;
            }
            sb.append(ch);
            lastCharIsCaptital = false;
        }
        return sb.toString();
    }

    static Mustache loadMustache(MustacheFactory mf, ExternalSource source, ClassLoader classLoader) {
        Mustache mustache = null;
        InputStream is = classLoader.getResourceAsStream(source.getName() + ".mustache");
        mustache = is != null ? mf.compile((Reader)new InputStreamReader(is), source.getName().toLowerCase()) : mf.compile((Reader)new InputStreamReader(VdbCodeGeneratorMojo.class.getResourceAsStream("/templates/Jdbc.mustache")), source.getName().toLowerCase());
        return mustache;
    }

    private File getVDBFile() throws MojoExecutionException, IOException {
        if (this.vdbFile.exists()) {
            this.getLog().info((CharSequence)("Found VDB = " + this.vdbFile));
            if (this.vdbFile.getName().endsWith(".vdb")) {
                File vdbDir = this.unzipContents(this.vdbFile);
                this.vdbFile = new File(vdbDir, "/META-INF/vdb.ddl");
                File openapi = new File(vdbDir, "openapi.json");
                if (openapi.exists()) {
                    this.openApiFile = openapi;
                }
            }
            return this.vdbFile;
        }
        String f = this.vdbFile.getAbsolutePath().replace("teiid.ddl", "teiid.vdb");
        if (!f.contentEquals(this.vdbFile.getAbsolutePath())) {
            this.vdbFile = new File(f);
            if (this.vdbFile.exists()) {
                File vdbDir = this.unzipContents(this.vdbFile);
                this.vdbFile = new File(vdbDir, "/META-INF/vdb.ddl");
                File openapi = new File(vdbDir, "openapi.json");
                if (openapi.exists()) {
                    this.openApiFile = openapi;
                }
                return this.vdbFile;
            }
        }
        Set dependencies = this.project.getArtifacts();
        for (Artifact d : dependencies) {
            if (d.getFile() == null || !d.getFile().getName().endsWith(".vdb")) continue;
            File vdbDir = this.unzipContents(d);
            this.vdbFile = new File(vdbDir, "/META-INF/vdb.ddl");
            File openapi = new File(vdbDir, "openapi.json");
            if (openapi.exists()) {
                this.openApiFile = openapi;
            }
            return this.vdbFile;
        }
        throw new MojoExecutionException("No VDB File found at location " + this.vdbFile + " or no VDB dependencies found in pom.xml");
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String mavenCompilePath : this.project.getCompileClasspathElements()) {
                pathUrls.add(new File(mavenCompilePath).toURI().toURL());
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            this.getLog().debug((CharSequence)("urls for URLClassLoader: " + Arrays.asList(urlsForClassLoader)));
            return new URLClassLoader(urlsForClassLoader, VdbCodeGeneratorMojo.class.getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }

    private boolean generateOpenApiScoffolding() {
        List dependencies = this.project.getDependencies();
        for (Dependency d : dependencies) {
            String gav = d.getGroupId() + ":" + d.getArtifactId();
            if (!gav.equals("org.teiid:spring-openapi")) continue;
            this.getLog().info((CharSequence)"OpenAPI dependency is found in the pom.xml");
            return true;
        }
        this.getLog().info((CharSequence)"No OpenAPI dependency is found in the pom.xml, skipping the generation of the OpenAPI classes");
        return false;
    }

    private File unzipContents(Artifact d) throws IOException {
        File f = new File(this.outputDirectory.getPath(), d.getArtifactId());
        f.mkdirs();
        this.getLog().info((CharSequence)("unzipping " + d.getArtifactId() + " to directory " + f.getCanonicalPath()));
        return VdbCodeGeneratorMojo.unzipContents(d.getFile(), f);
    }

    private File unzipContents(File d) throws IOException {
        File f = new File(this.outputDirectory.getPath(), d.getName());
        f.mkdirs();
        this.getLog().info((CharSequence)("unzipping " + d.getName() + " to directory " + f.getCanonicalPath()));
        return VdbCodeGeneratorMojo.unzipContents(d, f);
    }

    public static File unzipContents(File in, File out) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(in));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String fileName = ze.getName();
            File newFile = new File(out, fileName);
            if (ze.isDirectory()) {
                newFile.mkdirs();
            } else {
                int len;
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zis.closeEntry();
            ze = zis.getNextEntry();
        }
        zis.close();
        return out;
    }
}

