/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.maven;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.maven.ApiGenerator;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.Server;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.spring.common.ExternalSource;

@Mojo(name="vdb-codegen", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class VdbCodeGeneratorMojo
extends AbstractMojo {
    public static final SystemFunctionManager SFM = SystemMetadata.getInstance().getSystemFunctionManager();
    @Parameter(defaultValue="${basedir}/src/main/resources/teiid.ddl")
    private File vdbFile;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/teiid-sb")
    private File outputDirectory;
    @Parameter
    private String packageName;
    @Parameter
    private Boolean generateApplicationClass = true;
    @Parameter
    private Boolean generateDataSourceClasses = true;
    @Parameter(defaultValue="${basedir}/src/main/resources/openapi.json")
    private File openApiFile;

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            String ymlFile;
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            ClassLoader pluginClassloader = this.getClassLoader();
            Thread.currentThread().setContextClassLoader(pluginClassloader);
            File outputDir = this.getOutputDirectory();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            if (this.packageName == null) {
                this.packageName = this.project.getGroupId();
            }
            String codeDirectory = this.packageName.replace('.', '/');
            File javaSrcDir = new File(this.getOutputDirectory() + "/src/main/java", codeDirectory);
            if (!javaSrcDir.exists()) {
                javaSrcDir.mkdirs();
            }
            File vdbfile = this.getVDBFile();
            Database database = this.getDatabase(vdbfile);
            HashMap<String, String> parentMap = new HashMap<String, String>();
            parentMap.put("packageName", this.packageName);
            parentMap.put("vdbName", database.getName());
            parentMap.put("vdbDescription", database.getAnnotation());
            if (this.generateOpenApiScoffolding()) {
                parentMap.put("openapi", this.generateOpenApiScoffolding() ? "true" : "false");
            }
            if (this.generateApplicationClass.booleanValue()) {
                this.createApplication((MustacheFactory)mf, javaSrcDir, database, parentMap);
            }
            if (this.generateDataSourceClasses.booleanValue()) {
                this.createDataSources((MustacheFactory)mf, javaSrcDir, database, parentMap);
            }
            this.verifyTranslatorDependencies(database);
            if (!this.openApiFile.exists() && !(ymlFile = this.openApiFile.getAbsolutePath().replace("openapi.json", "openapi.yml")).contentEquals(this.openApiFile.getAbsolutePath())) {
                this.openApiFile = new File(ymlFile);
            }
            if (this.generateOpenApiScoffolding() && this.openApiFile.exists()) {
                this.getLog().info((CharSequence)("Found the OpenAPI document at " + this.openApiFile.getAbsolutePath()));
                ApiGenerator generator = new ApiGenerator(this.openApiFile, this.outputDirectory, this.getLog());
                generator.generate((MustacheFactory)mf, javaSrcDir, database, parentMap);
            } else {
                this.getLog().info((CharSequence)"No OpenAPI document found, no classes for the OpenAPI will be generated ");
            }
            this.project.addCompileSourceRoot(javaSrcDir.getAbsolutePath());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error running the vdb-codegen-plugin.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database getDatabase(File vdbfile) throws IOException {
        DatabaseStore store = new DatabaseStore(){

            public Map<String, Datatype> getRuntimeTypes() {
                return SystemMetadata.getInstance().getRuntimeTypeMap();
            }

            public void importSchema(String schemaName, String serverType, String serverName, String foreignSchemaName, List<String> includeTables, List<String> excludeTables, Map<String, String> properties) {
            }
        };
        Database db = null;
        String vdbStr = ObjectConverterUtil.convertToString((InputStream)new FileInputStream(vdbfile));
        StringReader reader = new StringReader(vdbStr);
        try {
            store.startEditing(false);
            store.setMode(DatabaseStore.Mode.ANY);
            QueryParser.getQueryParser().parseDDL(store, (Reader)new BufferedReader(reader));
            db = (Database)store.getDatabases().get(0);
        }
        finally {
            reader.close();
            store.stopEditing();
        }
        return db;
    }

    private void createApplication(MustacheFactory mf, File javaSrcDir, Database database, HashMap<String, String> props) throws Exception {
        this.getLog().info((CharSequence)"Creating the Application.java class");
        Mustache mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/Application.mustache")), "application");
        FileWriter out = new FileWriter(new File(javaSrcDir, "Application.java"));
        mustache.execute((Writer)out, props);
        ((Writer)out).close();
    }

    private void verifyTranslatorDependencies(Database database) throws Exception {
        for (DataWrapper dw : database.getDataWrappers()) {
            ExternalSource source = ExternalSource.find((String)dw.getName());
            if (source == null) {
                throw new MojoExecutionException("No Translator found with name:" + dw.getName());
            }
            boolean foundDependency = false;
            for (String g : source.getGav()) {
                foundDependency = false;
                List dependencies = this.project.getDependencies();
                for (Dependency d : dependencies) {
                    String gav = d.getGroupId() + ":" + d.getArtifactId();
                    if (!g.equals(gav)) continue;
                    this.getLog().info((CharSequence)("Found dependency:" + gav));
                    foundDependency = true;
                }
                if (!foundDependency) break;
            }
            if (foundDependency) continue;
            if (source.getGav() != null) {
                StringBuilder sb = new StringBuilder();
                for (String g : source.getGav()) {
                    sb.append("Drivers for translator \"" + dw.getName() + "\" are not found. Include following dependecy in pom.xml\n<dependency>\n    <groupId>" + g.substring(0, g.indexOf(58)) + "</groupId>\n    <artifactId>" + g.substring(g.indexOf(58) + 1) + "</artifactId>\n</dependency>\n\n");
                }
                throw new MojoExecutionException(sb.toString());
            }
            this.getLog().error((CharSequence)("Drivers for translator \"" + dw.getName() + "\" can not be verified. Make sure you have the required dependencies in the pom.xml"));
        }
    }

    private void createDataSources(MustacheFactory mf, File javaSrcDir, Database database, HashMap<String, String> parentMap) throws Exception {
        for (Server server : database.getServers()) {
            FileWriter out;
            Mustache mustache;
            HashMap<String, String> tempMap = new HashMap<String, String>(parentMap);
            tempMap.put("dsName", server.getName());
            this.getLog().info((CharSequence)("Building DataSource.java for source :" + server.getName()));
            String translator = server.getDataWrapper();
            if (translator.equals(ExternalSource.MONGODB.getTranslatorName())) {
                mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/MongoDB.mustache")), "mongodb");
                out = new FileWriter(new File(javaSrcDir, "DataSources" + server.getName() + ".java"));
                mustache.execute((Writer)out, tempMap);
                ((Writer)out).close();
                continue;
            }
            if (translator.equals(ExternalSource.SALESFORCE.getTranslatorName())) {
                mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/Salesforce.mustache")), "salesforce");
                out = new FileWriter(new File(javaSrcDir, "DataSources" + server.getName() + ".java"));
                mustache.execute((Writer)out, tempMap);
                ((Writer)out).close();
                continue;
            }
            if (translator.equals(ExternalSource.GOOGLESHEETS.getTranslatorName())) {
                mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/GoogleSheets.mustache")), "googlesheets");
                out = new FileWriter(new File(javaSrcDir, "DataSources" + server.getName() + ".java"));
                mustache.execute((Writer)out, tempMap);
                ((Writer)out).close();
                continue;
            }
            if (translator.equals(ExternalSource.FILE.getTranslatorName()) || translator.equals(ExternalSource.EXCEL.getTranslatorName())) {
                mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/File.mustache")), "file");
                out = new FileWriter(new File(javaSrcDir, "DataSources" + server.getName() + ".java"));
                mustache.execute((Writer)out, tempMap);
                ((Writer)out).close();
                continue;
            }
            if (this.isRestBasedTranslator(translator)) {
                mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/Rest.mustache")), "rest");
                out = new FileWriter(new File(javaSrcDir, "DataSources" + server.getName() + ".java"));
                mustache.execute((Writer)out, tempMap);
                ((Writer)out).close();
                continue;
            }
            mustache = mf.compile((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/Jdbc.mustache")), "jdbc");
            out = new FileWriter(new File(javaSrcDir, "DataSources" + server.getName() + ".java"));
            mustache.execute((Writer)out, tempMap);
            ((Writer)out).close();
        }
    }

    private boolean isRestBasedTranslator(String translator) {
        return ExternalSource.REST.getTranslatorName().equalsIgnoreCase(translator) || ExternalSource.OPENAPI.getTranslatorName().equalsIgnoreCase(translator) || ExternalSource.SAP_GATEWAY.getTranslatorName().equalsIgnoreCase(translator) || ExternalSource.ODATA.getTranslatorName().equalsIgnoreCase(translator) || ExternalSource.ODATA4.getTranslatorName().equalsIgnoreCase(translator);
    }

    private File getVDBFile() throws MojoExecutionException, IOException {
        if (this.vdbFile.exists()) {
            this.getLog().info((CharSequence)("Found VDB = " + this.vdbFile));
            return this.vdbFile;
        }
        String f = this.vdbFile.getAbsolutePath().replace("teiid.ddl", "teiid.vdb");
        if (!f.contentEquals(this.openApiFile.getAbsolutePath())) {
            this.vdbFile = new File(f);
            if (this.vdbFile.exists()) {
                return this.vdbFile;
            }
        }
        Set dependencies = this.project.getArtifacts();
        for (Artifact d : dependencies) {
            if (d.getFile() == null || !d.getFile().getName().endsWith(".vdb")) continue;
            File vdbDir = this.unzipContents(d);
            this.vdbFile = new File(vdbDir, "/META-INF/vdb.ddl");
            File openapi = new File(vdbDir, "openapi.json");
            if (!openapi.exists()) break;
            this.openApiFile = openapi;
            break;
        }
        throw new MojoExecutionException("No VDB File found at location " + this.vdbFile + " or no VDB dependencies defined");
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String mavenCompilePath : this.project.getCompileClasspathElements()) {
                pathUrls.add(new File(mavenCompilePath).toURI().toURL());
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            this.getLog().debug((CharSequence)("urls for URLClassLoader: " + Arrays.asList(urlsForClassLoader)));
            return new URLClassLoader(urlsForClassLoader, VdbCodeGeneratorMojo.class.getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }

    private boolean generateOpenApiScoffolding() {
        List dependencies = this.project.getDependencies();
        for (Dependency d : dependencies) {
            String gav = d.getGroupId() + ":" + d.getArtifactId();
            if (!gav.equals("org.teiid:spring-openapi")) continue;
            this.getLog().info((CharSequence)"OpenAPI dependency is found in the pom.xml");
            return true;
        }
        this.getLog().info((CharSequence)"No OpenAPI dependency is found in the pom.xml, skipping the generation of the OpenAPI classes");
        return false;
    }

    private File unzipContents(Artifact d) throws IOException {
        File f = new File(this.outputDirectory.getPath(), d.getArtifactId());
        f.mkdirs();
        this.getLog().info((CharSequence)("unzipping " + d.getArtifactId() + " to directory " + f.getCanonicalPath()));
        return VdbCodeGeneratorMojo.unzipContents(d.getFile(), f);
    }

    public static File unzipContents(File in, File out) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(in));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String fileName = ze.getName();
            File newFile = new File(out, fileName);
            new File(newFile.getParent()).mkdirs();
            if (!newFile.isDirectory()) {
                int len;
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zis.closeEntry();
            ze = zis.getNextEntry();
        }
        zis.close();
        return out;
    }
}

