/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.maven;

import io.swagger.v3.oas.models.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.SpringCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeiidCodegen
extends SpringCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeiidCodegen.class);

    public void processOpts() {
        super.processOpts();
        this.apiTemplateFiles.remove("api.mustache");
        this.apiTemplateFiles.remove("apiDelegate.mustache");
        this.apiTemplateFiles.put("teiidApi.mustache", ".java");
        this.apiTemplateFiles.put("teiidDelegate.mustache", "Delegate.java");
        this.apiTemplateFiles.put("teiidApiController.mustache", "Controller.java");
        this.removeSupportingFile("OpenAPI2SpringBoot.java");
        this.removeSupportingFile("pom.xml");
        this.removeSupportingFile("README.md");
        this.removeSupportingFile(".openapi-generator-ignore");
        this.removeSupportingFile(".openapi-generator");
    }

    private void removeSupportingFile(String name) {
        SupportingFile found = null;
        for (SupportingFile f : this.supportingFiles) {
            if (!f.destinationFilename.contentEquals(name)) continue;
            found = f;
        }
        if (found != null) {
            this.supportingFiles.remove(found);
        }
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        LOGGER.info("tag = " + tag + " resourcePath = " + resourcePath);
    }

    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List os = (List)operations.get("operation");
        ArrayList<TeiidCodegenOperation> newOs = new ArrayList<TeiidCodegenOperation>();
        for (CodegenOperation o : os) {
            TeiidCodegenOperation tco = new TeiidCodegenOperation(o);
            if (o.returnType == null || o.returnType.contentEquals("Void")) {
                tco.setHasReturn(false);
                o.returnType = "Void";
            }
            newOs.add(tco);
        }
        operations.put("operation", newOs);
        return objs;
    }

    class TeiidCodegenOperation
    extends CodegenOperation {
        public boolean hasReturn = true;

        public TeiidCodegenOperation(CodegenOperation o) {
            this.responseHeaders.addAll(o.responseHeaders);
            this.hasAuthMethods = o.hasAuthMethods;
            this.hasConsumes = o.hasConsumes;
            this.hasProduces = o.hasProduces;
            this.hasParams = o.hasParams;
            this.hasOptionalParams = o.hasOptionalParams;
            this.returnTypeIsPrimitive = o.returnTypeIsPrimitive;
            this.returnSimpleType = o.returnSimpleType;
            this.subresourceOperation = o.subresourceOperation;
            this.isMapContainer = o.isMapContainer;
            this.isListContainer = o.isListContainer;
            this.isMultipart = o.isMultipart;
            this.hasMore = o.hasMore;
            this.isResponseBinary = o.isResponseBinary;
            this.hasReference = o.hasReference;
            this.isRestfulIndex = o.isRestfulIndex;
            this.isRestfulShow = o.isRestfulShow;
            this.isRestfulCreate = o.isRestfulCreate;
            this.isRestfulUpdate = o.isRestfulUpdate;
            this.isRestfulDestroy = o.isRestfulDestroy;
            this.isRestful = o.isRestful;
            this.path = o.path;
            this.operationId = o.operationId;
            this.returnType = o.returnType;
            this.httpMethod = o.httpMethod;
            this.returnBaseType = o.returnBaseType;
            this.returnContainer = o.returnContainer;
            this.summary = o.summary;
            this.unescapedNotes = o.unescapedNotes;
            this.notes = o.notes;
            this.baseName = o.baseName;
            this.defaultResponse = o.defaultResponse;
            this.discriminator = o.discriminator;
            this.consumes = o.consumes;
            this.produces = o.produces;
            this.bodyParam = o.bodyParam;
            this.allParams = o.allParams;
            this.bodyParams = o.bodyParams;
            this.pathParams = o.pathParams;
            this.queryParams = o.queryParams;
            this.headerParams = o.headerParams;
            this.formParams = o.formParams;
            this.requiredParams = o.requiredParams;
            this.optionalParams = o.optionalParams;
            this.authMethods = o.authMethods;
            this.tags = o.tags;
            this.responses = o.responses;
            this.imports = o.imports;
            this.examples = o.examples;
            this.externalDocs = o.externalDocs;
            this.vendorExtensions = o.vendorExtensions;
            this.nickname = o.nickname;
            this.operationIdLowerCase = o.operationIdLowerCase;
            this.operationIdCamelCase = o.operationIdCamelCase;
        }

        public boolean isHasReturn() {
            return this.hasReturn;
        }

        public void setHasReturn(boolean hasReturn) {
            this.hasReturn = hasReturn;
        }
    }
}

