package com.example;

import com.example.ModelApiResponse;
import com.example.Pet;
import org.springframework.core.io.Resource;
import java.util.*;
import io.swagger.annotations.*;

import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import org.springframework.core.io.InputStreamResource;
import java.util.Optional;

/**
 * A delegate to be called by the {@link PetApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */

public class PetApiDelegate extends org.teiid.spring.openapi.TeiidRSProvider {
    private org.teiid.spring.autoconfigure.TeiidServer server;
    private org.teiid.adminapi.VDB vdb;

    public PetApiDelegate(org.teiid.spring.autoconfigure.TeiidServer server, org.teiid.adminapi.VDB vdb) {
        this.server = server;
        this.vdb = vdb;
    }

    /**
     * @see PetApi#addPet
     */
    public ResponseEntity<Void> addPet(Pet body) {
        setServer(this.server);
        setVdb(this.vdb);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("body",body);
        execute("addPet", parameters, "UTF-8", false);
        return new ResponseEntity<>(HttpStatus.OK);        

    }

    /**
     * @see PetApi#deletePet
     */
    public ResponseEntity<Void> deletePet(Long petId,
        String apiKey) {
        setServer(this.server);
        setVdb(this.vdb);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("petId",petId);
        parameters.put("apiKey",apiKey);
        execute("deletePet", parameters, "UTF-8", false);
        return new ResponseEntity<>(HttpStatus.OK);        

    }

    /**
     * @see PetApi#findPetsByStatus
     */
    public ResponseEntity<InputStreamResource> findPetsByStatus(List<String> status) {
        setServer(this.server);
        setVdb(this.vdb);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("status",status);
        return execute("findPetsByStatus", parameters, "UTF-8", true);        

    }

    /**
     * @see PetApi#getPetById
     */
    public ResponseEntity<InputStreamResource> getPetById(Long petId) {
        setServer(this.server);
        setVdb(this.vdb);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("petId",petId);
        return execute("getPetById", parameters, "UTF-8", true);        

    }

    /**
     * @see PetApi#updatePet
     */
    public ResponseEntity<Void> updatePet(Pet body) {
        setServer(this.server);
        setVdb(this.vdb);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("body",body);
        execute("updatePet", parameters, "UTF-8", false);
        return new ResponseEntity<>(HttpStatus.OK);        

    }

    /**
     * @see PetApi#updatePetWithForm
     */
    public ResponseEntity<Void> updatePetWithForm(Long petId,
        String name,
        String status) {
        setServer(this.server);
        setVdb(this.vdb);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("petId",petId);
        parameters.put("name",name);
        parameters.put("status",status);
        execute("updatePetWithForm", parameters, "UTF-8", false);
        return new ResponseEntity<>(HttpStatus.OK);        

    }

    /**
     * @see PetApi#uploadFile
     */
    public ResponseEntity<InputStreamResource> uploadFile(Long petId,
        String additionalMetadata,
        MultipartFile file) {
        setServer(this.server);
        setVdb(this.vdb);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("petId",petId);
        parameters.put("additionalMetadata",additionalMetadata);
        parameters.put("file",file);
        return execute("uploadFile", parameters, "UTF-8", true);        

    }

}
