/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.MigrationSummary;

public class BatonExecutionSummary {
    private static final Logger logger = LoggerFactory.getLogger(BatonExecutionSummary.class);
    private int filesSuccessfullyMigrated;
    private int filesUnsuccessfullyMigrated;
    private int numberOfTargetsExecuted;

    public void addMigrationSummary(MigrationSummary summary) {
        if (summary == null) {
            logger.warn("Mission migration summary details - file counts may be inaccurate!");
        } else {
            this.filesSuccessfullyMigrated += summary.getFilesSuccessfullyMigrated();
            this.filesUnsuccessfullyMigrated += summary.getFilesUnsuccessfullyMigrated();
        }
        ++this.numberOfTargetsExecuted;
    }

    public int getFilesSuccessfullyMigrated() {
        return this.filesSuccessfullyMigrated;
    }

    public int getFilesUnsuccessfullyMigrated() {
        return this.filesUnsuccessfullyMigrated;
    }

    public int getNumberOfTargetsExecuted() {
        return this.numberOfTargetsExecuted;
    }

    public String getSummary() {
        return String.format("Migrations Processed: %d, Successfully Migrated Files: %d, Unsuccessfully Migrated Files: %d", this.numberOfTargetsExecuted, this.filesSuccessfullyMigrated, this.filesUnsuccessfullyMigrated);
    }
}

