/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton;

import java.io.File;
import java.util.Set;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.Migration;
import org.technologybrewery.baton.MigrationSummary;

public abstract class AbstractMigration
implements Migration {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMigration.class);
    protected String name;
    protected String description;
    protected boolean active = true;
    protected Set<String> fileNamePatterns;

    @Override
    public MigrationSummary execute(FileSet[] fileSets) {
        if (!this.active) {
            logger.info("Migration {}' is marked inactive - skipping", (Object)this.getName());
            return new MigrationSummary(0, 0);
        }
        FileSetManager fileSetManager = new FileSetManager();
        int successfulMigrations = 0;
        int unsuccessfulMigrations = 0;
        for (FileSet fileSet : fileSets) {
            String[] includedFiles;
            for (String file : includedFiles = fileSetManager.getIncludedFiles(fileSet)) {
                File fileToMigrate = new File(fileSet.getDirectory(), file);
                if (!this.shouldExecuteOnFile(fileToMigrate)) continue;
                try {
                    this.performMigration(fileToMigrate);
                    ++successfulMigrations;
                }
                catch (Exception e) {
                    ++unsuccessfulMigrations;
                    logger.error(String.format("Problem performing migration on %s!", fileToMigrate.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return new MigrationSummary(successfulMigrations, unsuccessfulMigrations);
    }

    protected abstract boolean shouldExecuteOnFile(File var1);

    protected abstract boolean performMigration(File var1);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Set<String> getFileNamePatterns() {
        return this.fileNamePatterns;
    }

    public void setFileNamePatterns(Set<String> fileNamePatterns) {
        this.fileNamePatterns = fileNamePatterns;
    }
}

