/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.core;

import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSRegExpFlag;
import org.teavm.jso.core.JSString;

public abstract class JSRegExp
implements JSObject {
    @JSBody(params={"pattern"}, script="return new RegExp(pattern);")
    @NoSideEffects
    public static native JSRegExp create(String var0);

    @JSBody(params={"pattern", "flags"}, script="return new RegExp(pattern, flags);")
    @NoSideEffects
    public static native JSRegExp create(String var0, String var1);

    public static JSRegExp create(String pattern, JSRegExpFlag ... flags) {
        boolean global = false;
        boolean ignoreCase = false;
        boolean multiline = false;
        block5: for (JSRegExpFlag flag : flags) {
            switch (flag) {
                case GLOBAL: {
                    global = true;
                    continue block5;
                }
                case IGNORE_CASE: {
                    ignoreCase = true;
                    continue block5;
                }
                case MULTILINE: {
                    multiline = true;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (global) {
            sb.append('g');
        }
        if (ignoreCase) {
            sb.append('i');
        }
        if (multiline) {
            sb.append('m');
        }
        return JSRegExp.create(pattern, sb.toString());
    }

    @JSProperty
    public abstract boolean isGlobal();

    @JSProperty
    public abstract boolean isIgnoreCase();

    @JSProperty
    public abstract boolean isMultiline();

    @JSProperty
    public abstract int getLastIndex();

    @JSProperty
    public abstract JSString getSource();

    public abstract JSArray<JSString> exec(JSString var1);

    public abstract boolean test(JSString var1);

    public abstract boolean test(String var1);
}

