/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.test;

import org.junit.Assert;
import org.junit.Test;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.core.JSString;

public class ConversionTest {
    @Test
    public void convertsPrimitivesToJavaScript() {
        Assert.assertEquals((Object)"true:2:3:64:4:5.5:6.5:foo", (Object)ConversionTest.combinePrimitives(true, (byte)2, (short)3, '@', 4, 5.5f, 6.5, "foo"));
    }

    @Test
    public void convertsPrimitivesToJava() {
        Primitives map = ConversionTest.getPrimitives();
        Assert.assertTrue((boolean)map.getA());
        Assert.assertEquals((long)2L, (long)map.getB());
        Assert.assertEquals((long)3L, (long)map.getC());
        Assert.assertEquals((long)64L, (long)map.getD());
        Assert.assertEquals((long)4L, (long)map.getE());
        Assert.assertEquals((double)5.5, (double)map.getF(), (double)0.01);
        Assert.assertEquals((double)6.5, (double)map.getG(), (double)0.01);
        Assert.assertEquals((Object)"foo", (Object)map.getH());
    }

    @Test
    public void convertsPrimitiveArraysToJavaScript() {
        Assert.assertEquals((Object)"true:2:3:64:4:5.5:6.5:foo", (Object)ConversionTest.combinePrimitiveArrays(new boolean[]{true}, new byte[]{2}, new short[]{3}, new char[]{'@'}, new int[]{4}, new float[]{5.5f}, new double[]{6.5}, new String[]{"foo"}));
    }

    @Test
    public void convertsPrimitiveArraysToJava() {
        PrimitiveArrays arrays = ConversionTest.getPrimitiveArrays();
        boolean[] booleanArray = arrays.getA();
        Assert.assertEquals((long)1L, (long)booleanArray.length);
        Assert.assertTrue((boolean)booleanArray[0]);
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])arrays.getB());
        Assert.assertArrayEquals((short[])new short[]{3}, (short[])arrays.getC());
        Assert.assertArrayEquals((char[])new char[]{'@'}, (char[])arrays.getD());
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])arrays.getE());
        Assert.assertArrayEquals((float[])new float[]{5.5f}, (float[])arrays.getF(), (float)0.01f);
        Assert.assertArrayEquals((double[])new double[]{6.5}, (double[])arrays.getG(), (double)0.01);
        Assert.assertArrayEquals((Object[])new String[]{"foo"}, (Object[])arrays.getH());
    }

    @Test
    public void convertsPrimitiveArrays2ToJavaScript() {
        Assert.assertEquals((Object)"true:2:3:64:4:5.5:6.5:foo", (Object)ConversionTest.combinePrimitiveArrays2(new boolean[][]{{true}}, new byte[][]{{2}}, new short[][]{{3}}, new char[][]{{'@'}}, new int[][]{{4}}, new float[][]{{5.5f}}, new double[][]{{6.5}}, new String[][]{{"foo"}}));
    }

    @Test
    public void convertsPrimitiveArrays2ToJava() {
        PrimitiveArrays2 arrays = ConversionTest.getPrimitiveArrays2();
        boolean[][] booleanArray = arrays.getA();
        Assert.assertEquals((long)1L, (long)booleanArray.length);
        Assert.assertEquals((long)1L, (long)booleanArray[0].length);
        Assert.assertTrue((boolean)booleanArray[0][0]);
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])arrays.getB()[0]);
        Assert.assertArrayEquals((short[])new short[]{3}, (short[])arrays.getC()[0]);
        Assert.assertArrayEquals((char[])new char[]{'@'}, (char[])arrays.getD()[0]);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])arrays.getE()[0]);
        Assert.assertArrayEquals((float[])new float[]{5.5f}, (float[])arrays.getF()[0], (float)0.01f);
        Assert.assertArrayEquals((double[])new double[]{6.5}, (double[])arrays.getG()[0], (double)0.01);
        Assert.assertArrayEquals((Object[])new String[]{"foo"}, (Object[])arrays.getH()[0]);
    }

    @Test
    public void convertsPrimitiveArrays4ToJavaScript() {
        Assert.assertEquals((Object)"true:2:3:64:4:5.5:6.5:foo", (Object)ConversionTest.combinePrimitiveArrays4(new boolean[][][][]{new boolean[][][]{new boolean[][]{{true}}}}, new byte[][][][]{new byte[][][]{new byte[][]{{2}}}}, new short[][][][]{new short[][][]{new short[][]{{3}}}}, new char[][][][]{new char[][][]{new char[][]{{'@'}}}}, new int[][][][]{new int[][][]{new int[][]{{4}}}}, new float[][][][]{new float[][][]{new float[][]{{5.5f}}}}, new double[][][][]{new double[][][]{new double[][]{{6.5}}}}, new String[][][][]{{{{"foo"}}}}));
    }

    @Test
    public void convertsPrimitiveArrays4ToJava() {
        PrimitiveArrays4 arrays = ConversionTest.getPrimitiveArrays4();
        boolean[][][][] booleanArray = arrays.getA();
        Assert.assertEquals((long)1L, (long)booleanArray.length);
        Assert.assertEquals((long)1L, (long)booleanArray[0][0][0].length);
        Assert.assertTrue((boolean)booleanArray[0][0][0][0]);
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])arrays.getB()[0][0][0]);
        Assert.assertArrayEquals((short[])new short[]{3}, (short[])arrays.getC()[0][0][0]);
        Assert.assertArrayEquals((char[])new char[]{'@'}, (char[])arrays.getD()[0][0][0]);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])arrays.getE()[0][0][0]);
        Assert.assertArrayEquals((float[])new float[]{5.5f}, (float[])arrays.getF()[0][0][0], (float)0.01f);
        Assert.assertArrayEquals((double[])new double[]{6.5}, (double[])arrays.getG()[0][0][0], (double)0.01);
        Assert.assertArrayEquals((Object[])new String[]{"foo"}, (Object[])arrays.getH()[0][0][0]);
    }

    @Test
    public void passesJSObject() {
        Assert.assertEquals((Object)"(foo)", (Object)ConversionTest.surround(JSString.valueOf((String)"foo")).stringValue());
    }

    @Test
    public void convertsArrayOfJSObject() {
        Assert.assertEquals((Object)"(foo)", (Object)ConversionTest.surround(new JSString[]{JSString.valueOf((String)"foo")})[0].stringValue());
        Assert.assertEquals((Object)"(foo)", (Object)ConversionTest.surround(new JSString[][]{{JSString.valueOf((String)"foo")}})[0][0].stringValue());
        Assert.assertEquals((Object)"(foo)", (Object)ConversionTest.surround(new JSString[][][][]{{{{JSString.valueOf((String)"foo")}}}})[0][0][0][0].stringValue());
    }

    @Test
    public void copiesArray() {
        int[] array = new int[]{23};
        Assert.assertEquals((long)24L, (long)ConversionTest.mutate(array));
        Assert.assertEquals((long)23L, (long)array[0]);
    }

    @JSBody(params={"a", "b", "c", "d", "e", "f", "g", "h"}, script="return '' + a + ':' + b + ':' + c + ':' + d + ':' + e + ':' + f.toFixed(1) + ':'+ g.toFixed(1) + ':' + h;")
    private static native String combinePrimitives(boolean var0, byte var1, short var2, char var3, int var4, float var5, double var6, String var8);

    @JSBody(params={}, script="return { a : true, b : 2, c : 3, d : 64, e : 4, f : 5.5, g : 6.5, h : 'foo' };")
    private static native Primitives getPrimitives();

    @JSBody(params={"a", "b", "c", "d", "e", "f", "g", "h"}, script="return '' + a[0] + ':' + b[0] + ':' + c[0] + ':' + d[0] + ':' + e[0] + ':' + f[0].toFixed(1) + ':'+ g[0].toFixed(1) + ':' + h[0];")
    private static native String combinePrimitiveArrays(boolean[] var0, byte[] var1, short[] var2, char[] var3, int[] var4, float[] var5, double[] var6, String[] var7);

    @JSBody(params={}, script="return { a : [true], b : [2], c : [3], d : [64], e : [4], f : [5.5], g : [6.5], h : ['foo'] };")
    private static native PrimitiveArrays getPrimitiveArrays();

    @JSBody(params={"a", "b", "c", "d", "e", "f", "g", "h"}, script="return '' + a[0][0] + ':' + b[0][0] + ':' + c[0][0] + ':' + d[0][0] + ':' + e[0][0] + ':' + f[0][0].toFixed(1) + ':' + g[0][0].toFixed(1) + ':' + h[0][0];")
    private static native String combinePrimitiveArrays2(boolean[][] var0, byte[][] var1, short[][] var2, char[][] var3, int[][] var4, float[][] var5, double[][] var6, String[][] var7);

    @JSBody(params={}, script="return { a : [[true]], b : [[2]], c : [[3]], d : [[64]], e : [[4]], f : [[5.5]], g : [[6.5]], h : [['foo']] };")
    private static native PrimitiveArrays2 getPrimitiveArrays2();

    @JSBody(params={"a", "b", "c", "d", "e", "f", "g", "h"}, script="return '' + a[0][0][0][0] + ':' + b[0][0][0][0] + ':' + c[0][0][0][0] + ':' + d[0][0][0][0] + ':' + e[0][0][0][0] + ':' + f[0][0][0][0].toFixed(1) + ':' + g[0][0][0][0].toFixed(1) + ':' + h[0][0][0][0];")
    private static native String combinePrimitiveArrays4(boolean[][][][] var0, byte[][][][] var1, short[][][][] var2, char[][][][] var3, int[][][][] var4, float[][][][] var5, double[][][][] var6, String[][][][] var7);

    @JSBody(params={}, script="return { a : [[[[true]]]], b : [[[[2]]]], c : [[[[3]]]], d : [[[[64]]]], e : [[[[4]]]], f : [[[[5.5]]]], g : [[[[6.5]]]], h : [[[['foo']]]] };")
    private static native PrimitiveArrays4 getPrimitiveArrays4();

    @JSBody(params={"str"}, script="return '(' + str + ')';")
    private static native JSString surround(JSString var0);

    @JSBody(params={"str"}, script="return ['(' + str[0] + ')'];")
    private static native JSString[] surround(JSString[] var0);

    @JSBody(params={"str"}, script="return [['(' + str[0][0] + ')']];")
    private static native JSString[][] surround(JSString[][] var0);

    @JSBody(params={"str"}, script="return [[[['(' + str[0][0][0][0] + ')']]]];")
    private static native JSString[][][][] surround(JSString[][][][] var0);

    @JSBody(params={"array"}, script="array[0]++; return array[0];")
    private static native int mutate(int[] var0);

    static interface PrimitiveArrays4
    extends JSObject {
        @JSProperty
        public boolean[][][][] getA();

        @JSProperty
        public byte[][][][] getB();

        @JSProperty
        public short[][][][] getC();

        @JSProperty
        public char[][][][] getD();

        @JSProperty
        public int[][][][] getE();

        @JSProperty
        public float[][][][] getF();

        @JSProperty
        public double[][][][] getG();

        @JSProperty
        public String[][][][] getH();
    }

    static interface PrimitiveArrays2
    extends JSObject {
        @JSProperty
        public boolean[][] getA();

        @JSProperty
        public byte[][] getB();

        @JSProperty
        public short[][] getC();

        @JSProperty
        public char[][] getD();

        @JSProperty
        public int[][] getE();

        @JSProperty
        public float[][] getF();

        @JSProperty
        public double[][] getG();

        @JSProperty
        public String[][] getH();
    }

    static interface PrimitiveArrays
    extends JSObject {
        @JSProperty
        public boolean[] getA();

        @JSProperty
        public byte[] getB();

        @JSProperty
        public short[] getC();

        @JSProperty
        public char[] getD();

        @JSProperty
        public int[] getE();

        @JSProperty
        public float[] getF();

        @JSProperty
        public double[] getG();

        @JSProperty
        public String[] getH();
    }

    static interface Primitives
    extends JSObject {
        @JSProperty
        public boolean getA();

        @JSProperty
        public byte getB();

        @JSProperty
        public short getC();

        @JSProperty
        public char getD();

        @JSProperty
        public int getE();

        @JSProperty
        public float getF();

        @JSProperty
        public double getG();

        @JSProperty
        public String getH();
    }
}

