/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.test;

import org.junit.Assert;
import org.junit.Test;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSMethod;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;

public class AnnotationsTest {
    @Test
    public void staticBodyWorks() {
        Assert.assertEquals((long)12L, (long)AnnotationsTest.add(5, 7));
    }

    @Test
    public void memberBodyWorks() {
        Assert.assertEquals((long)12L, (long)AnnotationsTest.convert(AnnotationsTest.convert(5).add(AnnotationsTest.convert(7))));
    }

    @Test
    public void abstractWrapperWorks() {
        AbstractWrapper obj = AbstractWrapper.create(5);
        Assert.assertEquals((long)5L, (long)obj.getValue());
        Assert.assertEquals((long)12L, (long)obj.testMethod(6));
        Assert.assertEquals((long)13L, (long)obj.renamedMethod(6));
        Assert.assertEquals((long)25L, (long)obj.javaMethod(6));
    }

    @Test
    public void interfaceWrapperWorks() {
        InterfaceWrapper obj = AnnotationsTest.createWrapper(5);
        Assert.assertEquals((long)5L, (long)obj.getValue());
        Assert.assertEquals((long)12L, (long)obj.testMethod(6));
        Assert.assertEquals((long)13L, (long)obj.renamedMethod(6));
    }

    @JSBody(params={"a", "b"}, script="return a + b;")
    private static native int add(int var0, int var1);

    @JSBody(params={"n"}, script="return n;")
    private static native Num convert(int var0);

    @JSBody(params={"n"}, script="return n;")
    private static native int convert(Num var0);

    @JSBody(params={"value"}, script="return {value : value, testMethod : function(num) { return this.value + num + 1; }, renamedJSMethod : function(num) { return this.value + num + 2; }};")
    public static native InterfaceWrapper createWrapper(int var0);

    static interface InterfaceWrapper
    extends JSObject {
        @JSProperty
        public int getValue();

        public int testMethod(int var1);

        @JSMethod(value="renamedJSMethod")
        public int renamedMethod(int var1);
    }

    static abstract class AbstractWrapper
    implements JSObject {
        private AbstractWrapper() {
        }

        @JSProperty
        public abstract int getValue();

        public abstract int testMethod(int var1);

        @JSMethod(value="renamedJSMethod")
        public abstract int renamedMethod(int var1);

        public final int javaMethod(int num) {
            return this.testMethod(num) + this.renamedMethod(num);
        }

        @JSBody(params={"value"}, script="return {'value' : value, testMethod : function(num) { return this.value + num + 1; }, renamedJSMethod : function(num) { return this.value + num + 2; }};")
        public static native AbstractWrapper create(int var0);
    }

    static abstract class Num
    implements JSObject {
        Num() {
        }

        @JSBody(params={"other"}, script="return this + other;")
        public final native Num add(Num var1);
    }
}

