/*
 * Decompiled with CFR 0.152.
 */
package org.taymyr.play.repository.infrastructure.persistence;

import akka.Done;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.hibernate.Session;
import org.jetbrains.annotations.NotNull;
import org.taymyr.play.repository.domain.Repository;
import org.taymyr.play.repository.infrastructure.persistence.DatabaseExecutionContext;
import org.taymyr.play.repository.infrastructure.persistence.JPARepository$sam$java_util_function_Function$0;
import play.db.jpa.JPAApi;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B1\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J(\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H 0\u0018\"\u0004\b\u0002\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002H 0\"H\u0004J(\u0010$\u001a\b\u0012\u0004\u0012\u0002H 0\u0018\"\u0004\b\u0002\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002H 0\"H\u0004J(\u0010%\u001a\b\u0012\u0004\u0012\u0002H 0\u0018\"\u0004\b\u0002\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u0002H 0\"H\u0004J(\u0010'\u001a\b\u0012\u0004\u0012\u0002H 0\u0018\"\u0004\b\u0002\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u0002H 0\"H\u0004J\"\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)0\u00182\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010)H\u0016J!\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000,0\u00182\u0006\u0010-\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)0\u0018H\u0016J'\u00100\u001a\u0002H \"\u0004\b\u0002\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002H 0\"H\u0004\u00a2\u0006\u0002\u00101J\u001b\u00102\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J\u001b\u00104\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J'\u00106\u001a\u0002H \"\u0004\b\u0002\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002H 0\"H\u0004\u00a2\u0006\u0002\u00101R\u001c\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00067"}, d2={"Lorg/taymyr/play/repository/infrastructure/persistence/JPARepository;", "Aggregate", "", "Identity", "Ljava/io/Serializable;", "Lorg/taymyr/play/repository/domain/Repository;", "jpaApi", "Lplay/db/jpa/JPAApi;", "executionContext", "Lorg/taymyr/play/repository/infrastructure/persistence/DatabaseExecutionContext;", "clazz", "Ljava/lang/Class;", "persistenceUnitName", "", "(Lplay/db/jpa/JPAApi;Lorg/taymyr/play/repository/infrastructure/persistence/DatabaseExecutionContext;Ljava/lang/Class;Ljava/lang/String;)V", "getClazz", "()Ljava/lang/Class;", "getExecutionContext", "()Lorg/taymyr/play/repository/infrastructure/persistence/DatabaseExecutionContext;", "getJpaApi", "()Lplay/db/jpa/JPAApi;", "getPersistenceUnitName", "()Ljava/lang/String;", "create", "Ljava/util/concurrent/CompletionStage;", "Lakka/Done;", "aggregate", "(Ljava/lang/Object;)Ljava/util/concurrent/CompletionStage;", "createAll", "aggregates", "", "execute", "E", "function", "Lkotlin/Function1;", "Ljavax/persistence/EntityManager;", "executeRO", "executeSession", "Lorg/hibernate/Session;", "executeSessionRO", "findByIds", "", "ids", "get", "Ljava/util/Optional;", "id", "(Ljava/io/Serializable;)Ljava/util/concurrent/CompletionStage;", "getAll", "readOnly", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "remove", "removeAll", "save", "saveAll", "transaction", "play-repository-jpa-java"})
public abstract class JPARepository<Aggregate, Identity extends Serializable>
implements Repository<Aggregate, Identity> {
    @NotNull
    private final JPAApi jpaApi;
    @NotNull
    private final DatabaseExecutionContext executionContext;
    @NotNull
    private final Class<? extends Aggregate> clazz;
    @NotNull
    private final String persistenceUnitName;

    protected final <E> E transaction(@NotNull Function1<? super EntityManager, ? extends E> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        Function1<? super EntityManager, ? extends E> function1 = function;
        return (E)this.jpaApi.withTransaction(this.persistenceUnitName, (Function)new JPARepository$sam$java_util_function_Function$0(function1));
    }

    protected final <E> E readOnly(@NotNull Function1<? super EntityManager, ? extends E> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        Function1<? super EntityManager, ? extends E> function1 = function;
        return (E)this.jpaApi.withTransaction(this.persistenceUnitName, true, (Function)new JPARepository$sam$java_util_function_Function$0(function1));
    }

    @NotNull
    protected final <E> CompletionStage<E> execute(@NotNull Function1<? super EntityManager, ? extends E> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        CompletableFuture completableFuture = CompletableFuture.supplyAsync(new Supplier<E>(this, function){
            final /* synthetic */ JPARepository this$0;
            final /* synthetic */ Function1 $function;

            public final E get() {
                return this.this$0.transaction(this.$function);
            }
            {
                this.this$0 = jPARepository;
                this.$function = function1;
            }
        }, (Executor)((Object)this.executionContext));
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"supplyAsync(Supplier { t\u2026ion) }, executionContext)");
        return completableFuture;
    }

    @NotNull
    protected final <E> CompletionStage<E> executeRO(@NotNull Function1<? super EntityManager, ? extends E> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        CompletableFuture completableFuture = CompletableFuture.supplyAsync(new Supplier<E>(this, function){
            final /* synthetic */ JPARepository this$0;
            final /* synthetic */ Function1 $function;

            public final E get() {
                return this.this$0.readOnly(this.$function);
            }
            {
                this.this$0 = jPARepository;
                this.$function = function1;
            }
        }, (Executor)((Object)this.executionContext));
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"supplyAsync(Supplier { r\u2026ion) }, executionContext)");
        return completableFuture;
    }

    @NotNull
    protected final <E> CompletionStage<E> executeSession(@NotNull Function1<? super Session, ? extends E> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return this.execute((Function1)new Function1<EntityManager, E>(function){
            final /* synthetic */ Function1 $function;

            public final E invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                Object object = em.unwrap(Session.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"em.unwrap(Session::class.java)");
                return (E)this.$function.invoke(object);
            }
            {
                this.$function = function1;
                super(1);
            }
        });
    }

    @NotNull
    protected final <E> CompletionStage<E> executeSessionRO(@NotNull Function1<? super Session, ? extends E> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return this.executeRO((Function1)new Function1<EntityManager, E>(function){
            final /* synthetic */ Function1 $function;

            public final E invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                Object object = em.unwrap(Session.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"em.unwrap(Session::class.java)");
                return (E)this.$function.invoke(object);
            }
            {
                this.$function = function1;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<Optional<Aggregate>> get(@NotNull Identity id) {
        Intrinsics.checkParameterIsNotNull(id, (String)"id");
        return this.execute((Function1)new Function1<EntityManager, Optional<Aggregate>>(this, (Serializable)id){
            final /* synthetic */ JPARepository this$0;
            final /* synthetic */ Serializable $id;

            @NotNull
            public final Optional<Aggregate> invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                return Optional.ofNullable(em.find(this.this$0.getClazz(), (Object)this.$id));
            }
            {
                this.this$0 = jPARepository;
                this.$id = serializable;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<List<Aggregate>> getAll() {
        return this.executeRO((Function1)new Function1<EntityManager, List>(this){
            final /* synthetic */ JPARepository this$0;

            public final List invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
                Class<Aggregate> clazz = this.this$0.getClazz();
                if (clazz == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Nothing>");
                }
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(clazz);
                Root root = criteriaQuery.from(this.this$0.getClazz());
                CriteriaQuery all = criteriaQuery.select((Selection)root);
                TypedQuery typedQuery = em.createQuery(all);
                Intrinsics.checkExpressionValueIsNotNull((Object)typedQuery, (String)"em.createQuery(all)");
                return typedQuery.getResultList();
            }
            {
                this.this$0 = jPARepository;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<List<Aggregate>> findByIds(@NotNull List<? extends Identity> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.executeSessionRO((Function1)new Function1<Session, List<? extends Aggregate>>(this, ids){
            final /* synthetic */ JPARepository this$0;
            final /* synthetic */ List $ids;

            public final List<? extends Aggregate> invoke(@NotNull Session session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                return session.byMultipleIds(this.this$0.getClazz()).multiLoad(this.$ids);
            }
            {
                this.this$0 = jPARepository;
                this.$ids = list;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<Done> remove(@NotNull Aggregate aggregate) {
        Intrinsics.checkParameterIsNotNull(aggregate, (String)"aggregate");
        return this.execute((Function1)new Function1<EntityManager, Done>(aggregate){
            final /* synthetic */ Object $aggregate;

            public final Done invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                if (em.contains(this.$aggregate)) {
                    em.remove(this.$aggregate);
                } else {
                    em.remove(em.merge(this.$aggregate));
                }
                return Done.getInstance();
            }
            {
                this.$aggregate = object;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<Done> removeAll(@NotNull Collection<? extends Aggregate> aggregates) {
        Intrinsics.checkParameterIsNotNull(aggregates, (String)"aggregates");
        return this.execute((Function1)new Function1<EntityManager, Done>(aggregates){
            final /* synthetic */ Collection $aggregates;

            public final Done invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                Iterable $this$forEach$iv = this.$aggregates;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    if (em.contains(it)) {
                        em.remove(it);
                        continue;
                    }
                    em.remove(em.merge(it));
                }
                return Done.getInstance();
            }
            {
                this.$aggregates = collection;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<Done> create(@NotNull Aggregate aggregate) {
        Intrinsics.checkParameterIsNotNull(aggregate, (String)"aggregate");
        return this.execute((Function1)new Function1<EntityManager, Done>(aggregate){
            final /* synthetic */ Object $aggregate;

            public final Done invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                em.persist(this.$aggregate);
                return Done.getInstance();
            }
            {
                this.$aggregate = object;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<Done> createAll(@NotNull Collection<? extends Aggregate> aggregates) {
        Intrinsics.checkParameterIsNotNull(aggregates, (String)"aggregates");
        return this.execute((Function1)new Function1<EntityManager, Done>(aggregates){
            final /* synthetic */ Collection $aggregates;

            public final Done invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                Iterable $this$forEach$iv = this.$aggregates;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    em.persist(it);
                }
                return Done.getInstance();
            }
            {
                this.$aggregates = collection;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<Done> save(@NotNull Aggregate aggregate) {
        Intrinsics.checkParameterIsNotNull(aggregate, (String)"aggregate");
        return this.execute((Function1)new Function1<EntityManager, Done>(aggregate){
            final /* synthetic */ Object $aggregate;

            public final Done invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                em.merge(this.$aggregate);
                return Done.getInstance();
            }
            {
                this.$aggregate = object;
                super(1);
            }
        });
    }

    @NotNull
    public CompletionStage<Done> saveAll(@NotNull Collection<? extends Aggregate> aggregates) {
        Intrinsics.checkParameterIsNotNull(aggregates, (String)"aggregates");
        return this.execute((Function1)new Function1<EntityManager, Done>(aggregates){
            final /* synthetic */ Collection $aggregates;

            public final Done invoke(@NotNull EntityManager em) {
                Intrinsics.checkParameterIsNotNull((Object)em, (String)"em");
                Iterable $this$forEach$iv = this.$aggregates;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    em.merge(it);
                }
                return Done.getInstance();
            }
            {
                this.$aggregates = collection;
                super(1);
            }
        });
    }

    @NotNull
    protected final JPAApi getJpaApi() {
        return this.jpaApi;
    }

    @NotNull
    protected final DatabaseExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    protected final Class<? extends Aggregate> getClazz() {
        return this.clazz;
    }

    @NotNull
    protected final String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    @JvmOverloads
    public JPARepository(@NotNull JPAApi jpaApi, @NotNull DatabaseExecutionContext executionContext, @NotNull Class<? extends Aggregate> clazz, @NotNull String persistenceUnitName) {
        Intrinsics.checkParameterIsNotNull((Object)jpaApi, (String)"jpaApi");
        Intrinsics.checkParameterIsNotNull((Object)executionContext, (String)"executionContext");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)persistenceUnitName, (String)"persistenceUnitName");
        this.jpaApi = jpaApi;
        this.executionContext = executionContext;
        this.clazz = clazz;
        this.persistenceUnitName = persistenceUnitName;
    }

    public /* synthetic */ JPARepository(JPAApi jPAApi, DatabaseExecutionContext databaseExecutionContext, Class clazz, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = "default";
        }
        this(jPAApi, databaseExecutionContext, clazz, string);
    }

    @JvmOverloads
    public JPARepository(@NotNull JPAApi jpaApi, @NotNull DatabaseExecutionContext executionContext, @NotNull Class<? extends Aggregate> clazz) {
        this(jpaApi, executionContext, clazz, null, 8, null);
    }
}

