/*
 * Decompiled with CFR 0.152.
 */
package org.taymyr.lagom.javadsl.api.transport;

import com.google.common.net.MediaType;
import com.lightbend.lagom.javadsl.api.transport.MessageProtocol;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/taymyr/lagom/javadsl/api/transport/MessageProtocols;", "", "()V", "JSON", "Lcom/lightbend/lagom/javadsl/api/transport/MessageProtocol;", "JSON_UTF_8", "YAML", "fromFile", "file", "", "def", "fromMediaType", "mediaType", "Lcom/google/common/net/MediaType;", "lagom-extensions"})
public final class MessageProtocols {
    @JvmField
    @NotNull
    public static final MessageProtocol JSON;
    @JvmField
    @NotNull
    public static final MessageProtocol JSON_UTF_8;
    @JvmField
    @NotNull
    public static final MessageProtocol YAML;
    public static final MessageProtocols INSTANCE;

    @JvmStatic
    @NotNull
    public static final MessageProtocol fromMediaType(@NotNull MediaType mediaType) {
        Intrinsics.checkParameterIsNotNull((Object)mediaType, (String)"mediaType");
        MessageProtocol messageProtocol = MessageProtocol.fromContentTypeHeader(Optional.of(mediaType.toString()));
        Intrinsics.checkExpressionValueIsNotNull((Object)messageProtocol, (String)"MessageProtocol.fromCont\u2026of(mediaType.toString()))");
        return messageProtocol;
    }

    @JvmStatic
    @Nullable
    public static final MessageProtocol fromFile(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return MessageProtocols.fromFile(file, null);
    }

    @JvmStatic
    @Nullable
    public static final MessageProtocol fromFile(@NotNull String file, @Nullable MessageProtocol def) {
        MessageProtocol messageProtocol;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        switch (StringsKt.substringAfterLast$default((String)file, (char)'.', null, (int)2, null)) {
            case "json": {
                messageProtocol = JSON;
                break;
            }
            case "yml": 
            case "yaml": {
                messageProtocol = YAML;
                break;
            }
            default: {
                messageProtocol = def;
            }
        }
        return messageProtocol;
    }

    private MessageProtocols() {
    }

    static {
        MessageProtocols messageProtocols;
        INSTANCE = messageProtocols = new MessageProtocols();
        MediaType mediaType = MediaType.create((String)"application", (String)"json");
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaType, (String)"MediaType.create(\"application\", \"json\")");
        JSON = MessageProtocols.fromMediaType(mediaType);
        MediaType mediaType2 = MediaType.JSON_UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaType2, (String)"MediaType.JSON_UTF_8");
        JSON_UTF_8 = MessageProtocols.fromMediaType(mediaType2);
        MediaType mediaType3 = MediaType.create((String)"application", (String)"x-yaml");
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaType3, (String)"MediaType.create(\"application\", \"x-yaml\")");
        YAML = MessageProtocols.fromMediaType(mediaType3);
    }
}

