/*
 * Decompiled with CFR 0.152.
 */
package org.t3as.snomedct.lookup;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.jdbcx.JdbcConnectionPool;
import org.t3as.metamap.jaxb.Candidate;
import org.t3as.metamap.jaxb.MMO;
import org.t3as.metamap.jaxb.MMOs;
import org.t3as.metamap.jaxb.Mapping;
import org.t3as.metamap.jaxb.Phrase;
import org.t3as.metamap.jaxb.SemType;
import org.t3as.metamap.jaxb.Utterance;
import org.t3as.snomedct.lookup.SnomedTerm;

public final class SnomedLookup
implements Closeable {
    private static final String SELECT_SQL = "select top 1 snomedId, termType from snomed where cui = ? and description = ? order by mrrank, snomedId desc";
    private static final String FROM_SNOMEDID_SELECT_SQL = "select cui, description, termType from snomed where snomedid = ?";
    private final JdbcConnectionPool connectionPool;
    private final Connection conn;
    private final PreparedStatement fromCuiPrepStmt;
    private final PreparedStatement fromSnomedIdPrepStmt;

    public SnomedLookup(File dbFile) throws SQLException {
        this.connectionPool = JdbcConnectionPool.create((String)("jdbc:h2:" + dbFile.getAbsoluteFile() + ";IFEXISTS=TRUE;ACCESS_MODE_DATA=r"), (String)"foo", (String)"bar");
        this.conn = this.connectionPool.getConnection();
        this.fromCuiPrepStmt = this.conn.prepareStatement(SELECT_SQL);
        this.fromSnomedIdPrepStmt = this.conn.prepareStatement(FROM_SNOMEDID_SELECT_SQL);
    }

    public int enrichXml(MMOs root) throws SQLException {
        int count = 0;
        for (MMO mmo : root.getMMO()) {
            for (Utterance utterance : mmo.getUtterances().getUtterance()) {
                for (Phrase phrase : utterance.getPhrases().getPhrase()) {
                    System.out.printf("Phrase: %s\n", phrase.getPhraseText());
                    for (Mapping mapping : phrase.getMappings().getMapping()) {
                        System.out.printf("Score: %s\n", mapping.getMappingScore());
                        for (Candidate candidate : mapping.getMappingCandidates().getCandidate()) {
                            ArrayList<String> semTypes = new ArrayList<String>();
                            for (SemType st : candidate.getSemTypes().getSemType()) {
                                semTypes.add(st.getvalue());
                            }
                            count += this.addSnomedId(candidate) ? 1 : 0;
                            System.out.printf("  %-5s %-9s %s %s %s %s\n", candidate.getCandidateScore(), candidate.getCandidateCUI(), candidate.getSnomedId(), candidate.getCandidatePreferred(), semTypes, candidate.getSources().getSource());
                        }
                    }
                    System.out.println();
                }
            }
        }
        return count;
    }

    public boolean addSnomedId(Candidate candidate) throws SQLException {
        SnomedTerm result = this.findFromCuiAndDesc(candidate.getCandidateCUI(), candidate.getCandidatePreferred());
        if (result != null) {
            candidate.setSnomedId(result.snomedId);
            candidate.setTermType(result.termType);
            return true;
        }
        System.err.printf("WARNING! Could not find the SNOMED CT concept id for UMLS CUI: %s: '%s'\n", candidate.getCandidateCUI(), candidate.getCandidatePreferred());
        return false;
    }

    public SnomedTerm findFromCuiAndDesc(String cui, String description) throws SQLException {
        this.fromCuiPrepStmt.setString(1, cui);
        this.fromCuiPrepStmt.setString(2, description);
        ResultSet resultSet = this.fromCuiPrepStmt.executeQuery();
        SnomedTerm t = null;
        if (resultSet.first()) {
            t = new SnomedTerm(cui, resultSet.getString("snomedId"), resultSet.getString("termType"), description);
        }
        resultSet.close();
        return t;
    }

    public SnomedTerm findFromSnomedId(String snomedId) throws SQLException {
        this.fromSnomedIdPrepStmt.setString(1, snomedId);
        ResultSet resultSet = this.fromSnomedIdPrepStmt.executeQuery();
        SnomedTerm t = null;
        if (resultSet.first()) {
            t = new SnomedTerm(resultSet.getString("cui"), snomedId, resultSet.getString("termType"), resultSet.getString("description"));
        }
        resultSet.close();
        return t;
    }

    @Override
    public void close() throws IOException {
        try {
            this.fromCuiPrepStmt.close();
            this.fromSnomedIdPrepStmt.close();
            this.conn.close();
            this.connectionPool.dispose();
        }
        catch (SQLException e) {
            throw new IOException("Could not close SQL connection: " + e.getMessage(), e);
        }
    }
}

