/*
 * Decompiled with CFR 0.152.
 */
package org.t3as.snomedct.lookup.cmdline;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.t3as.metamap.JaxbLoader;
import org.t3as.metamap.jaxb.MMOs;
import org.t3as.snomedct.lookup.SnomedLookup;
import org.t3as.snomedct.lookup.SnomedTerm;
import org.xml.sax.SAXException;

public class Main {
    public static void main(String[] args) throws IOException, SQLException, JAXBException, ParserConfigurationException, SAXException {
        block45: {
            Options opts = new Options();
            JCommander jc = null;
            try {
                jc = new JCommander((Object)opts, args);
            }
            catch (Exception e) {
                System.err.println("Could not parse the options: " + e.getMessage());
                System.exit(1);
            }
            if (opts.showUsage) {
                jc.usage();
                System.exit(0);
            }
            if (opts.infile == null && !opts.cuiDesc && !opts.snomedIds) {
                System.out.println("If not specifying -infile, please specify either -cuiDesc or -snomedId.");
                jc.usage();
                System.exit(1);
            }
            if (opts.infile == null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                     SnomedLookup snomedLookup = new SnomedLookup(opts.dbFile);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        SnomedTerm term = null;
                        if (opts.cuiDesc) {
                            String[] parts = line.split(" ", 2);
                            term = snomedLookup.findFromCuiAndDesc(parts[0], parts[1]);
                        } else if (opts.snomedIds) {
                            term = snomedLookup.findFromSnomedId(line);
                        }
                        if (term == null) continue;
                        System.out.println(term);
                    }
                    break block45;
                }
            }
            try (SnomedLookup snomedLookup = new SnomedLookup(opts.dbFile);){
                long jaxbStart = System.currentTimeMillis();
                MMOs root = JaxbLoader.loadXml((File)opts.infile);
                long jaxbEnd = System.currentTimeMillis();
                long start = System.currentTimeMillis();
                int count = snomedLookup.enrichXml(root);
                long end = System.currentTimeMillis();
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MMOs.class});
                Marshaller m = jaxbContext.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal((Object)root, (OutputStream)System.out);
                System.err.printf("Loaded XML in %,d millis, looked up %,d SNOMED concepts in %,d milliseconds.\n", jaxbEnd - jaxbStart, count, end - start);
            }
        }
    }

    private static class Options {
        @Parameter(help=true, names={"-h", "--help"}, description="Show this help message.")
        boolean showUsage = false;
        @Parameter(names={"-infile"}, description="MetaMap '--XMLf1' output to look up SNOMED CT codes for.")
        File infile = null;
        @Parameter(names={"-cuiDescs"}, description="Read CUI and descriptions to lookup from stdin.")
        boolean cuiDesc = false;
        @Parameter(names={"-snomedIds"}, description="Read SNOMED CT ID's to lookup from stdin.")
        boolean snomedIds = false;
        @Parameter(names={"-dbFile"}, description="The file prefix to the SNOMED CT lookup database.")
        File dbFile = new File("/opt/snomed-coder-web/data/snomedct");

        private Options() {
        }
    }
}

