/*
 * Decompiled with CFR 0.152.
 */
package org.t3as.snomedct.lookup.cmdline;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import org.t3as.snomedct.lookup.CreateLookupDb;

public final class CreateDb {
    public static void main(String[] args) throws Exception {
        Options opts = new Options();
        JCommander jc = null;
        try {
            jc = new JCommander((Object)opts, args);
        }
        catch (Exception e) {
            System.err.println("Could not parse the options: " + e.getMessage());
            System.exit(1);
        }
        if (opts.showUsage) {
            jc.usage();
            System.exit(0);
        }
        System.out.println("Starting database generation...");
        long start = System.currentTimeMillis();
        try (CreateLookupDb createLookupDb = new CreateLookupDb(opts.dbFile, opts.umlsMetaPath);){
            int count = createLookupDb.process();
            long end = System.currentTimeMillis();
            System.out.printf("Inserted %,d SNOMED CT concepts in %,d milliseconds.\n", count, end - start);
        }
    }

    private static class Options {
        @Parameter(help=true, names={"-h", "--help"}, description="Show this help message.")
        boolean showUsage = false;
        @Parameter(names={"-dbFile"}, description="The file prefix to save the SNOMED CT lookup database in.")
        File dbFile = new File("/opt/snomed-coder-web/data/snomedct");
        @Parameter(names={"-umlsMeta"}, description="The path to the UMLS META directory.")
        File umlsMetaPath = new File("/opt/snomed-coder-web/umls/2013AB/META");

        private Options() {
        }
    }
}

