/*
 * Decompiled with CFR 0.152.
 */
package org.t3as.snomedct.lookup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.h2.jdbcx.JdbcConnectionPool;
import org.t3as.metamap.JaxbLoader;

public class CreateLookupDb
implements AutoCloseable {
    private static final String INSERT_SQL = "insert into snomed (snomedid,cui,termType,mrrank,description) values (?,?,?,?,?)";
    private final File umlsMetaPath;
    private final JdbcConnectionPool connectionPool;
    private final Connection connection;

    public CreateLookupDb(File dbFile, File umlsMetaPath) throws SQLException {
        this.umlsMetaPath = umlsMetaPath;
        this.connectionPool = JdbcConnectionPool.create((String)("jdbc:h2:" + dbFile.getAbsoluteFile()), (String)"foo", (String)"bar");
        this.connection = this.connectionPool.getConnection();
    }

    public int process() throws SQLException, IOException {
        HashMap<String, Integer> rankMap = new HashMap<String, Integer>();
        try (BufferedReader mrrank = new BufferedReader(new FileReader(this.umlsMetaPath.getAbsolutePath() + "/MRRANK.RRF"));){
            String line;
            int rank = 1;
            while ((line = mrrank.readLine()) != null) {
                String[] p = line.split("\\|", 0);
                if (!p[1].startsWith("SNOMED")) continue;
                rankMap.put(p[2], rank);
                ++rank;
            }
        }
        var3_4 = null;
        try (Statement statement = this.connection.createStatement();){
            statement.execute(StringUtils.join((Object[])JaxbLoader.loadResource((String)"create-snomed-db.sql"), (String)"\n"));
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
        int count = 0;
        try (PreparedStatement prep = this.connection.prepareStatement(INSERT_SQL);
             BufferedReader mrconso = new BufferedReader(new FileReader(this.umlsMetaPath.getAbsolutePath() + "/MRCONSO.RRF"));){
            String line;
            while ((line = mrconso.readLine()) != null) {
                String[] p = line.split("\\|", 0);
                if (!p[11].startsWith("SNOMED")) continue;
                prep.setString(1, p[13]);
                prep.setString(2, p[0]);
                prep.setString(3, p[12]);
                prep.setInt(4, (Integer)rankMap.get(p[12]));
                prep.setString(5, p[14]);
                prep.execute();
                ++count;
            }
        }
        return count;
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
        this.connectionPool.dispose();
    }
}

