/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.UserError;
import org.symphonyoss.symphony.pod.model.UserV2;

/**
 * List of User record version 2
 */
@ApiModel(description = "List of User record version 2")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class V2UserList {
  @JsonProperty("users")
  private List<UserV2> users = null;

  @JsonProperty("errors")
  private List<UserError> errors = null;

  public V2UserList users(List<UserV2> users) {
    this.users = users;
    return this;
  }

  public V2UserList addUsersItem(UserV2 usersItem) {
    if (this.users == null) {
      this.users = new ArrayList<UserV2>();
    }
    this.users.add(usersItem);
    return this;
  }

   /**
   * List of all users found with the search
   * @return users
  **/
  @ApiModelProperty(value = "List of all users found with the search")
  public List<UserV2> getUsers() {
    return users;
  }

  public void setUsers(List<UserV2> users) {
    this.users = users;
  }

  public V2UserList errors(List<UserError> errors) {
    this.errors = errors;
    return this;
  }

  public V2UserList addErrorsItem(UserError errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<UserError>();
    }
    this.errors.add(errorsItem);
    return this;
  }

   /**
   * List of all errors found with the informed search criteria
   * @return errors
  **/
  @ApiModelProperty(value = "List of all errors found with the informed search criteria")
  public List<UserError> getErrors() {
    return errors;
  }

  public void setErrors(List<UserError> errors) {
    this.errors = errors;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2UserList v2UserList = (V2UserList) o;
    return Objects.equals(this.users, v2UserList.users) &&
        Objects.equals(this.errors, v2UserList.errors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(users, errors);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2UserList {\n");
    
    sb.append("    users: ").append(toIndentedString(users)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

