/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.RoomTag;

/**
 * V2RoomAttributes
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class V2RoomAttributes {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("keywords")
  private List<RoomTag> keywords = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("membersCanInvite")
  private Boolean membersCanInvite = null;

  @JsonProperty("discoverable")
  private Boolean discoverable = null;

  @JsonProperty("public")
  private Boolean _public = null;

  @JsonProperty("readOnly")
  private Boolean readOnly = null;

  @JsonProperty("copyProtected")
  private Boolean copyProtected = null;

  public V2RoomAttributes name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Room name.
   * @return name
  **/
  @ApiModelProperty(value = "Room name.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public V2RoomAttributes keywords(List<RoomTag> keywords) {
    this.keywords = keywords;
    return this;
  }

  public V2RoomAttributes addKeywordsItem(RoomTag keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<RoomTag>();
    }
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Keywords for search to use to find this room
   * @return keywords
  **/
  @ApiModelProperty(value = "Keywords for search to use to find this room")
  public List<RoomTag> getKeywords() {
    return keywords;
  }

  public void setKeywords(List<RoomTag> keywords) {
    this.keywords = keywords;
  }

  public V2RoomAttributes description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Room description.
   * @return description
  **/
  @ApiModelProperty(value = "Room description.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public V2RoomAttributes membersCanInvite(Boolean membersCanInvite) {
    this.membersCanInvite = membersCanInvite;
    return this;
  }

   /**
   * If true, any chatroom participant can add new participants. If false, only owners can add new participants.
   * @return membersCanInvite
  **/
  @ApiModelProperty(value = "If true, any chatroom participant can add new participants. If false, only owners can add new participants.")
  public Boolean getMembersCanInvite() {
    return membersCanInvite;
  }

  public void setMembersCanInvite(Boolean membersCanInvite) {
    this.membersCanInvite = membersCanInvite;
  }

  public V2RoomAttributes discoverable(Boolean discoverable) {
    this.discoverable = discoverable;
    return this;
  }

   /**
   * If true, this chatroom (name, description and messages) can be searched and listed by non-participants. If false, only participants can search this room.
   * @return discoverable
  **/
  @ApiModelProperty(value = "If true, this chatroom (name, description and messages) can be searched and listed by non-participants. If false, only participants can search this room.")
  public Boolean getDiscoverable() {
    return discoverable;
  }

  public void setDiscoverable(Boolean discoverable) {
    this.discoverable = discoverable;
  }

  public V2RoomAttributes _public(Boolean _public) {
    this._public = _public;
    return this;
  }

   /**
   * If true, this is a public chatroom. IF false, a private chatroom.
   * @return _public
  **/
  @ApiModelProperty(value = "If true, this is a public chatroom. IF false, a private chatroom.")
  public Boolean getPublic() {
    return _public;
  }

  public void setPublic(Boolean _public) {
    this._public = _public;
  }

  public V2RoomAttributes readOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return this;
  }

   /**
   * If true, only stream owners can send messages.
   * @return readOnly
  **/
  @ApiModelProperty(value = "If true, only stream owners can send messages.")
  public Boolean getReadOnly() {
    return readOnly;
  }

  public void setReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
  }

  public V2RoomAttributes copyProtected(Boolean copyProtected) {
    this.copyProtected = copyProtected;
    return this;
  }

   /**
   * If true, clients disable the clipboard copy for content in this stream.
   * @return copyProtected
  **/
  @ApiModelProperty(value = "If true, clients disable the clipboard copy for content in this stream.")
  public Boolean getCopyProtected() {
    return copyProtected;
  }

  public void setCopyProtected(Boolean copyProtected) {
    this.copyProtected = copyProtected;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2RoomAttributes v2RoomAttributes = (V2RoomAttributes) o;
    return Objects.equals(this.name, v2RoomAttributes.name) &&
        Objects.equals(this.keywords, v2RoomAttributes.keywords) &&
        Objects.equals(this.description, v2RoomAttributes.description) &&
        Objects.equals(this.membersCanInvite, v2RoomAttributes.membersCanInvite) &&
        Objects.equals(this.discoverable, v2RoomAttributes.discoverable) &&
        Objects.equals(this._public, v2RoomAttributes._public) &&
        Objects.equals(this.readOnly, v2RoomAttributes.readOnly) &&
        Objects.equals(this.copyProtected, v2RoomAttributes.copyProtected);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, keywords, description, membersCanInvite, discoverable, _public, readOnly, copyProtected);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2RoomAttributes {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    membersCanInvite: ").append(toIndentedString(membersCanInvite)).append("\n");
    sb.append("    discoverable: ").append(toIndentedString(discoverable)).append("\n");
    sb.append("    _public: ").append(toIndentedString(_public)).append("\n");
    sb.append("    readOnly: ").append(toIndentedString(readOnly)).append("\n");
    sb.append("    copyProtected: ").append(toIndentedString(copyProtected)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

