/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.V2UserPresence;

/**
 * V2Presence
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class V2Presence {
  @JsonProperty("category")
  private String category = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("timestamp")
  private Long timestamp = null;

  public V2Presence category(String category) {
    this.category = category;
    return this;
  }

   /**
   * Presence status. Possible values are:   - UNDEFINED   - AVAILABLE   - BUSY   - DO_NOT_DISTURB   - ON_THE_PHONE   - BE_RIGHT_BACK   - IN_A_MEETING   - AWAY   - OUT_OF_OFFICE   - OFF_WORK   - OFFLINE 
   * @return category
  **/
  @ApiModelProperty(required = true, value = "Presence status. Possible values are:   - UNDEFINED   - AVAILABLE   - BUSY   - DO_NOT_DISTURB   - ON_THE_PHONE   - BE_RIGHT_BACK   - IN_A_MEETING   - AWAY   - OUT_OF_OFFICE   - OFF_WORK   - OFFLINE ")
  public String getCategory() {
    return category;
  }

  public void setCategory(String category) {
    this.category = category;
  }

  public V2Presence userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * The ID of the user to whom the presence state relates.
   * @return userId
  **/
  @ApiModelProperty(value = "The ID of the user to whom the presence state relates.")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public V2Presence timestamp(Long timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * The time, in milliseconds since Jan 1 1970, when the presence state was set.
   * @return timestamp
  **/
  @ApiModelProperty(value = "The time, in milliseconds since Jan 1 1970, when the presence state was set.")
  public Long getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2Presence v2Presence = (V2Presence) o;
    return Objects.equals(this.category, v2Presence.category) &&
        Objects.equals(this.userId, v2Presence.userId) &&
        Objects.equals(this.timestamp, v2Presence.timestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(category, userId, timestamp);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2Presence {\n");
    
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

