/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.V2MemberInfoList;

/**
 * List of members in the stream.
 */
@ApiModel(description = "List of members in the stream.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class V2MembershipList {
  @JsonProperty("count")
  private Integer count = null;

  @JsonProperty("skip")
  private Integer skip = null;

  @JsonProperty("limit")
  private Integer limit = null;

  @JsonProperty("members")
  private V2MemberInfoList members = null;

  public V2MembershipList count(Integer count) {
    this.count = count;
    return this;
  }

   /**
   * total members count
   * @return count
  **/
  @ApiModelProperty(value = "total members count")
  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public V2MembershipList skip(Integer skip) {
    this.skip = skip;
    return this;
  }

   /**
   * number of items to skip from the request
   * @return skip
  **/
  @ApiModelProperty(value = "number of items to skip from the request")
  public Integer getSkip() {
    return skip;
  }

  public void setSkip(Integer skip) {
    this.skip = skip;
  }

  public V2MembershipList limit(Integer limit) {
    this.limit = limit;
    return this;
  }

   /**
   * maximum number of items to return
   * @return limit
  **/
  @ApiModelProperty(value = "maximum number of items to return")
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public V2MembershipList members(V2MemberInfoList members) {
    this.members = members;
    return this;
  }

   /**
   * Get members
   * @return members
  **/
  @ApiModelProperty(value = "")
  public V2MemberInfoList getMembers() {
    return members;
  }

  public void setMembers(V2MemberInfoList members) {
    this.members = members;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2MembershipList v2MembershipList = (V2MembershipList) o;
    return Objects.equals(this.count, v2MembershipList.count) &&
        Objects.equals(this.skip, v2MembershipList.skip) &&
        Objects.equals(this.limit, v2MembershipList.limit) &&
        Objects.equals(this.members, v2MembershipList.members);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, skip, limit, members);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2MembershipList {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    skip: ").append(toIndentedString(skip)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    members: ").append(toIndentedString(members)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

