/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.V2AdminStreamAttributes;

/**
 * Stream information
 */
@ApiModel(description = "Stream information")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class V2AdminStreamInfo {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("isExternal")
  private Boolean isExternal = null;

  @JsonProperty("isActive")
  private Boolean isActive = null;

  @JsonProperty("isPublic")
  private Boolean isPublic = null;

  @JsonProperty("type")
  private String type = null;

  @JsonProperty("attributes")
  private V2AdminStreamAttributes attributes = null;

  public V2AdminStreamInfo id(String id) {
    this.id = id;
    return this;
  }

   /**
   * stream id
   * @return id
  **/
  @ApiModelProperty(value = "stream id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public V2AdminStreamInfo isExternal(Boolean isExternal) {
    this.isExternal = isExternal;
    return this;
  }

   /**
   * true indicate this stream has the scope of external and false indictate this stream has the scope of internal
   * @return isExternal
  **/
  @ApiModelProperty(value = "true indicate this stream has the scope of external and false indictate this stream has the scope of internal")
  public Boolean getIsExternal() {
    return isExternal;
  }

  public void setIsExternal(Boolean isExternal) {
    this.isExternal = isExternal;
  }

  public V2AdminStreamInfo isActive(Boolean isActive) {
    this.isActive = isActive;
    return this;
  }

   /**
   * true indicate that this stream has the status of active and false indicate this stream has the scope of inactive
   * @return isActive
  **/
  @ApiModelProperty(value = "true indicate that this stream has the status of active and false indicate this stream has the scope of inactive")
  public Boolean getIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public V2AdminStreamInfo isPublic(Boolean isPublic) {
    this.isPublic = isPublic;
    return this;
  }

   /**
   * true indicate that this stream has a privacy setting of public.  This only apply a ROOM stream type.
   * @return isPublic
  **/
  @ApiModelProperty(value = "true indicate that this stream has a privacy setting of public.  This only apply a ROOM stream type.")
  public Boolean getIsPublic() {
    return isPublic;
  }

  public void setIsPublic(Boolean isPublic) {
    this.isPublic = isPublic;
  }

  public V2AdminStreamInfo type(String type) {
    this.type = type;
    return this;
  }

   /**
   * type of stream (IM, MIM, ROOM)
   * @return type
  **/
  @ApiModelProperty(value = "type of stream (IM, MIM, ROOM)")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public V2AdminStreamInfo attributes(V2AdminStreamAttributes attributes) {
    this.attributes = attributes;
    return this;
  }

   /**
   * Get attributes
   * @return attributes
  **/
  @ApiModelProperty(value = "")
  public V2AdminStreamAttributes getAttributes() {
    return attributes;
  }

  public void setAttributes(V2AdminStreamAttributes attributes) {
    this.attributes = attributes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2AdminStreamInfo v2AdminStreamInfo = (V2AdminStreamInfo) o;
    return Objects.equals(this.id, v2AdminStreamInfo.id) &&
        Objects.equals(this.isExternal, v2AdminStreamInfo.isExternal) &&
        Objects.equals(this.isActive, v2AdminStreamInfo.isActive) &&
        Objects.equals(this.isPublic, v2AdminStreamInfo.isPublic) &&
        Objects.equals(this.type, v2AdminStreamInfo.type) &&
        Objects.equals(this.attributes, v2AdminStreamInfo.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, isExternal, isActive, isPublic, type, attributes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2AdminStreamInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    isExternal: ").append(toIndentedString(isExternal)).append("\n");
    sb.append("    isActive: ").append(toIndentedString(isActive)).append("\n");
    sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

