/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * additional optional properties for the stream
 */
@ApiModel(description = "additional optional properties for the stream")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class V2AdminStreamAttributes {
  @JsonProperty("roomName")
  private String roomName = null;

  @JsonProperty("roomDescription")
  private String roomDescription = null;

  @JsonProperty("members")
  private List<Long> members = null;

  @JsonProperty("createdByUserId")
  private Long createdByUserId = null;

  @JsonProperty("createdDate")
  private Long createdDate = null;

  @JsonProperty("lastModifiedDate")
  private Long lastModifiedDate = null;

  @JsonProperty("originCompany")
  private String originCompany = null;

  @JsonProperty("originCompanyId")
  private Integer originCompanyId = null;

  @JsonProperty("membersCount")
  private Integer membersCount = null;

  @JsonProperty("lastMessageDate")
  private Long lastMessageDate = null;

  public V2AdminStreamAttributes roomName(String roomName) {
    this.roomName = roomName;
    return this;
  }

   /**
   * room name (room only)
   * @return roomName
  **/
  @ApiModelProperty(value = "room name (room only)")
  public String getRoomName() {
    return roomName;
  }

  public void setRoomName(String roomName) {
    this.roomName = roomName;
  }

  public V2AdminStreamAttributes roomDescription(String roomDescription) {
    this.roomDescription = roomDescription;
    return this;
  }

   /**
   * description of the room (room only)
   * @return roomDescription
  **/
  @ApiModelProperty(value = "description of the room (room only)")
  public String getRoomDescription() {
    return roomDescription;
  }

  public void setRoomDescription(String roomDescription) {
    this.roomDescription = roomDescription;
  }

  public V2AdminStreamAttributes members(List<Long> members) {
    this.members = members;
    return this;
  }

  public V2AdminStreamAttributes addMembersItem(Long membersItem) {
    if (this.members == null) {
      this.members = new ArrayList<Long>();
    }
    this.members.add(membersItem);
    return this;
  }

   /**
   * list of userid who is member of the stream - im or mim only
   * @return members
  **/
  @ApiModelProperty(value = "list of userid who is member of the stream - im or mim only")
  public List<Long> getMembers() {
    return members;
  }

  public void setMembers(List<Long> members) {
    this.members = members;
  }

  public V2AdminStreamAttributes createdByUserId(Long createdByUserId) {
    this.createdByUserId = createdByUserId;
    return this;
  }

   /**
   * creator user id
   * @return createdByUserId
  **/
  @ApiModelProperty(value = "creator user id")
  public Long getCreatedByUserId() {
    return createdByUserId;
  }

  public void setCreatedByUserId(Long createdByUserId) {
    this.createdByUserId = createdByUserId;
  }

  public V2AdminStreamAttributes createdDate(Long createdDate) {
    this.createdDate = createdDate;
    return this;
  }

   /**
   * created date
   * @return createdDate
  **/
  @ApiModelProperty(value = "created date")
  public Long getCreatedDate() {
    return createdDate;
  }

  public void setCreatedDate(Long createdDate) {
    this.createdDate = createdDate;
  }

  public V2AdminStreamAttributes lastModifiedDate(Long lastModifiedDate) {
    this.lastModifiedDate = lastModifiedDate;
    return this;
  }

   /**
   * last modified date
   * @return lastModifiedDate
  **/
  @ApiModelProperty(value = "last modified date")
  public Long getLastModifiedDate() {
    return lastModifiedDate;
  }

  public void setLastModifiedDate(Long lastModifiedDate) {
    this.lastModifiedDate = lastModifiedDate;
  }

  public V2AdminStreamAttributes originCompany(String originCompany) {
    this.originCompany = originCompany;
    return this;
  }

   /**
   * company name of the creator
   * @return originCompany
  **/
  @ApiModelProperty(value = "company name of the creator")
  public String getOriginCompany() {
    return originCompany;
  }

  public void setOriginCompany(String originCompany) {
    this.originCompany = originCompany;
  }

  public V2AdminStreamAttributes originCompanyId(Integer originCompanyId) {
    this.originCompanyId = originCompanyId;
    return this;
  }

   /**
   * company id of the creator
   * @return originCompanyId
  **/
  @ApiModelProperty(value = "company id of the creator")
  public Integer getOriginCompanyId() {
    return originCompanyId;
  }

  public void setOriginCompanyId(Integer originCompanyId) {
    this.originCompanyId = originCompanyId;
  }

  public V2AdminStreamAttributes membersCount(Integer membersCount) {
    this.membersCount = membersCount;
    return this;
  }

   /**
   * total number of members in the stream
   * @return membersCount
  **/
  @ApiModelProperty(value = "total number of members in the stream")
  public Integer getMembersCount() {
    return membersCount;
  }

  public void setMembersCount(Integer membersCount) {
    this.membersCount = membersCount;
  }

  public V2AdminStreamAttributes lastMessageDate(Long lastMessageDate) {
    this.lastMessageDate = lastMessageDate;
    return this;
  }

   /**
   * last date a message was sent in this stream
   * @return lastMessageDate
  **/
  @ApiModelProperty(value = "last date a message was sent in this stream")
  public Long getLastMessageDate() {
    return lastMessageDate;
  }

  public void setLastMessageDate(Long lastMessageDate) {
    this.lastMessageDate = lastMessageDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2AdminStreamAttributes v2AdminStreamAttributes = (V2AdminStreamAttributes) o;
    return Objects.equals(this.roomName, v2AdminStreamAttributes.roomName) &&
        Objects.equals(this.roomDescription, v2AdminStreamAttributes.roomDescription) &&
        Objects.equals(this.members, v2AdminStreamAttributes.members) &&
        Objects.equals(this.createdByUserId, v2AdminStreamAttributes.createdByUserId) &&
        Objects.equals(this.createdDate, v2AdminStreamAttributes.createdDate) &&
        Objects.equals(this.lastModifiedDate, v2AdminStreamAttributes.lastModifiedDate) &&
        Objects.equals(this.originCompany, v2AdminStreamAttributes.originCompany) &&
        Objects.equals(this.originCompanyId, v2AdminStreamAttributes.originCompanyId) &&
        Objects.equals(this.membersCount, v2AdminStreamAttributes.membersCount) &&
        Objects.equals(this.lastMessageDate, v2AdminStreamAttributes.lastMessageDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roomName, roomDescription, members, createdByUserId, createdDate, lastModifiedDate, originCompany, originCompanyId, membersCount, lastMessageDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2AdminStreamAttributes {\n");
    
    sb.append("    roomName: ").append(toIndentedString(roomName)).append("\n");
    sb.append("    roomDescription: ").append(toIndentedString(roomDescription)).append("\n");
    sb.append("    members: ").append(toIndentedString(members)).append("\n");
    sb.append("    createdByUserId: ").append(toIndentedString(createdByUserId)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastModifiedDate: ").append(toIndentedString(lastModifiedDate)).append("\n");
    sb.append("    originCompany: ").append(toIndentedString(originCompany)).append("\n");
    sb.append("    originCompanyId: ").append(toIndentedString(originCompanyId)).append("\n");
    sb.append("    membersCount: ").append(toIndentedString(membersCount)).append("\n");
    sb.append("    lastMessageDate: ").append(toIndentedString(lastMessageDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

