/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.AvatarList;

/**
 * User record version 2
 */
@ApiModel(description = "User record version 2")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class UserV2 {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("emailAddress")
  private String emailAddress = null;

  @JsonProperty("firstName")
  private String firstName = null;

  @JsonProperty("lastName")
  private String lastName = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("title")
  private String title = null;

  @JsonProperty("company")
  private String company = null;

  @JsonProperty("username")
  private String username = null;

  @JsonProperty("location")
  private String location = null;

  @JsonProperty("avatars")
  private AvatarList avatars = null;

  @JsonProperty("workPhoneNumber")
  private String workPhoneNumber = null;

  @JsonProperty("mobilePhoneNumber")
  private String mobilePhoneNumber = null;

  @JsonProperty("jobFunction")
  private String jobFunction = null;

  @JsonProperty("department")
  private String department = null;

  @JsonProperty("division")
  private String division = null;

  public UserV2 id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public UserV2 emailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

   /**
   * Get emailAddress
   * @return emailAddress
  **/
  @ApiModelProperty(value = "")
  public String getEmailAddress() {
    return emailAddress;
  }

  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }

  public UserV2 firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

   /**
   * Get firstName
   * @return firstName
  **/
  @ApiModelProperty(value = "")
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public UserV2 lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

   /**
   * Get lastName
   * @return lastName
  **/
  @ApiModelProperty(value = "")
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public UserV2 displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @ApiModelProperty(value = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public UserV2 title(String title) {
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @ApiModelProperty(value = "")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public UserV2 company(String company) {
    this.company = company;
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @ApiModelProperty(value = "")
  public String getCompany() {
    return company;
  }

  public void setCompany(String company) {
    this.company = company;
  }

  public UserV2 username(String username) {
    this.username = username;
    return this;
  }

   /**
   * Get username
   * @return username
  **/
  @ApiModelProperty(value = "")
  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public UserV2 location(String location) {
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @ApiModelProperty(value = "")
  public String getLocation() {
    return location;
  }

  public void setLocation(String location) {
    this.location = location;
  }

  public UserV2 avatars(AvatarList avatars) {
    this.avatars = avatars;
    return this;
  }

   /**
   * Get avatars
   * @return avatars
  **/
  @ApiModelProperty(value = "")
  public AvatarList getAvatars() {
    return avatars;
  }

  public void setAvatars(AvatarList avatars) {
    this.avatars = avatars;
  }

  public UserV2 workPhoneNumber(String workPhoneNumber) {
    this.workPhoneNumber = workPhoneNumber;
    return this;
  }

   /**
   * Note: only available if the application has the extended user or contact permission
   * @return workPhoneNumber
  **/
  @ApiModelProperty(value = "Note: only available if the application has the extended user or contact permission")
  public String getWorkPhoneNumber() {
    return workPhoneNumber;
  }

  public void setWorkPhoneNumber(String workPhoneNumber) {
    this.workPhoneNumber = workPhoneNumber;
  }

  public UserV2 mobilePhoneNumber(String mobilePhoneNumber) {
    this.mobilePhoneNumber = mobilePhoneNumber;
    return this;
  }

   /**
   * Note: only available if the application has the extended user or contact permission
   * @return mobilePhoneNumber
  **/
  @ApiModelProperty(value = "Note: only available if the application has the extended user or contact permission")
  public String getMobilePhoneNumber() {
    return mobilePhoneNumber;
  }

  public void setMobilePhoneNumber(String mobilePhoneNumber) {
    this.mobilePhoneNumber = mobilePhoneNumber;
  }

  public UserV2 jobFunction(String jobFunction) {
    this.jobFunction = jobFunction;
    return this;
  }

   /**
   * Note: only available if the application has the extended user or contact permission
   * @return jobFunction
  **/
  @ApiModelProperty(value = "Note: only available if the application has the extended user or contact permission")
  public String getJobFunction() {
    return jobFunction;
  }

  public void setJobFunction(String jobFunction) {
    this.jobFunction = jobFunction;
  }

  public UserV2 department(String department) {
    this.department = department;
    return this;
  }

   /**
   * Note: only available if the application has the extended user or contact permission
   * @return department
  **/
  @ApiModelProperty(value = "Note: only available if the application has the extended user or contact permission")
  public String getDepartment() {
    return department;
  }

  public void setDepartment(String department) {
    this.department = department;
  }

  public UserV2 division(String division) {
    this.division = division;
    return this;
  }

   /**
   * Note: only available if the application has the extended user or contact permission
   * @return division
  **/
  @ApiModelProperty(value = "Note: only available if the application has the extended user or contact permission")
  public String getDivision() {
    return division;
  }

  public void setDivision(String division) {
    this.division = division;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserV2 userV2 = (UserV2) o;
    return Objects.equals(this.id, userV2.id) &&
        Objects.equals(this.emailAddress, userV2.emailAddress) &&
        Objects.equals(this.firstName, userV2.firstName) &&
        Objects.equals(this.lastName, userV2.lastName) &&
        Objects.equals(this.displayName, userV2.displayName) &&
        Objects.equals(this.title, userV2.title) &&
        Objects.equals(this.company, userV2.company) &&
        Objects.equals(this.username, userV2.username) &&
        Objects.equals(this.location, userV2.location) &&
        Objects.equals(this.avatars, userV2.avatars) &&
        Objects.equals(this.workPhoneNumber, userV2.workPhoneNumber) &&
        Objects.equals(this.mobilePhoneNumber, userV2.mobilePhoneNumber) &&
        Objects.equals(this.jobFunction, userV2.jobFunction) &&
        Objects.equals(this.department, userV2.department) &&
        Objects.equals(this.division, userV2.division);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, emailAddress, firstName, lastName, displayName, title, company, username, location, avatars, workPhoneNumber, mobilePhoneNumber, jobFunction, department, division);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserV2 {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    avatars: ").append(toIndentedString(avatars)).append("\n");
    sb.append("    workPhoneNumber: ").append(toIndentedString(workPhoneNumber)).append("\n");
    sb.append("    mobilePhoneNumber: ").append(toIndentedString(mobilePhoneNumber)).append("\n");
    sb.append("    jobFunction: ").append(toIndentedString(jobFunction)).append("\n");
    sb.append("    department: ").append(toIndentedString(department)).append("\n");
    sb.append("    division: ").append(toIndentedString(division)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

