/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.ProductList;

/**
 * Application Entitlements for the user
 */
@ApiModel(description = "Application Entitlements for the user")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class UserAppEntitlement {
  @JsonProperty("appId")
  private String appId = null;

  @JsonProperty("appName")
  private String appName = null;

  @JsonProperty("listed")
  private Boolean listed = null;

  @JsonProperty("install")
  private Boolean install = null;

  @JsonProperty("products")
  private ProductList products = null;

  public UserAppEntitlement appId(String appId) {
    this.appId = appId;
    return this;
  }

   /**
   * Unique ID for the Application
   * @return appId
  **/
  @ApiModelProperty(required = true, value = "Unique ID for the Application")
  public String getAppId() {
    return appId;
  }

  public void setAppId(String appId) {
    this.appId = appId;
  }

  public UserAppEntitlement appName(String appName) {
    this.appName = appName;
    return this;
  }

   /**
   * Name for this Application
   * @return appName
  **/
  @ApiModelProperty(value = "Name for this Application")
  public String getAppName() {
    return appName;
  }

  public void setAppName(String appName) {
    this.appName = appName;
  }

  public UserAppEntitlement listed(Boolean listed) {
    this.listed = listed;
    return this;
  }

   /**
   * if true, this application will be listed in the appstore for this user.  Otherwise, this application will be hidden in the appstore.
   * @return listed
  **/
  @ApiModelProperty(required = true, value = "if true, this application will be listed in the appstore for this user.  Otherwise, this application will be hidden in the appstore.")
  public Boolean getListed() {
    return listed;
  }

  public void setListed(Boolean listed) {
    this.listed = listed;
  }

  public UserAppEntitlement install(Boolean install) {
    this.install = install;
    return this;
  }

   /**
   * if true, it indicate this application is installed for this user.  Otherwise, this user does not have this application installed.
   * @return install
  **/
  @ApiModelProperty(required = true, value = "if true, it indicate this application is installed for this user.  Otherwise, this user does not have this application installed.")
  public Boolean getInstall() {
    return install;
  }

  public void setInstall(Boolean install) {
    this.install = install;
  }

  public UserAppEntitlement products(ProductList products) {
    this.products = products;
    return this;
  }

   /**
   * Get products
   * @return products
  **/
  @ApiModelProperty(value = "")
  public ProductList getProducts() {
    return products;
  }

  public void setProducts(ProductList products) {
    this.products = products;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserAppEntitlement userAppEntitlement = (UserAppEntitlement) o;
    return Objects.equals(this.appId, userAppEntitlement.appId) &&
        Objects.equals(this.appName, userAppEntitlement.appName) &&
        Objects.equals(this.listed, userAppEntitlement.listed) &&
        Objects.equals(this.install, userAppEntitlement.install) &&
        Objects.equals(this.products, userAppEntitlement.products);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, appName, listed, install, products);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserAppEntitlement {\n");
    
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    appName: ").append(toIndentedString(appName)).append("\n");
    sb.append("    listed: ").append(toIndentedString(listed)).append("\n");
    sb.append("    install: ").append(toIndentedString(install)).append("\n");
    sb.append("    products: ").append(toIndentedString(products)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

