/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.StreamType;

/**
 * Stream filtering parameters.
 */
@ApiModel(description = "Stream filtering parameters.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class StreamFilter {
  @JsonProperty("streamTypes")
  private List<StreamType> streamTypes = null;

  @JsonProperty("includeInactiveStreams")
  private Boolean includeInactiveStreams = null;

  public StreamFilter streamTypes(List<StreamType> streamTypes) {
    this.streamTypes = streamTypes;
    return this;
  }

  public StreamFilter addStreamTypesItem(StreamType streamTypesItem) {
    if (this.streamTypes == null) {
      this.streamTypes = new ArrayList<StreamType>();
    }
    this.streamTypes.add(streamTypesItem);
    return this;
  }

   /**
   * Types of streams to search for.
   * @return streamTypes
  **/
  @ApiModelProperty(value = "Types of streams to search for.")
  public List<StreamType> getStreamTypes() {
    return streamTypes;
  }

  public void setStreamTypes(List<StreamType> streamTypes) {
    this.streamTypes = streamTypes;
  }

  public StreamFilter includeInactiveStreams(Boolean includeInactiveStreams) {
    this.includeInactiveStreams = includeInactiveStreams;
    return this;
  }

   /**
   * Whether to include inactive streams in the list of results.
   * @return includeInactiveStreams
  **/
  @ApiModelProperty(value = "Whether to include inactive streams in the list of results.")
  public Boolean getIncludeInactiveStreams() {
    return includeInactiveStreams;
  }

  public void setIncludeInactiveStreams(Boolean includeInactiveStreams) {
    this.includeInactiveStreams = includeInactiveStreams;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StreamFilter streamFilter = (StreamFilter) o;
    return Objects.equals(this.streamTypes, streamFilter.streamTypes) &&
        Objects.equals(this.includeInactiveStreams, streamFilter.includeInactiveStreams);
  }

  @Override
  public int hashCode() {
    return Objects.hash(streamTypes, includeInactiveStreams);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StreamFilter {\n");
    
    sb.append("    streamTypes: ").append(toIndentedString(streamTypes)).append("\n");
    sb.append("    includeInactiveStreams: ").append(toIndentedString(includeInactiveStreams)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

