/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.symphonyoss.symphony.pod.model.ConversationSpecificStreamAttributes;
import org.symphonyoss.symphony.pod.model.RoomSpecificStreamAttributes;
import org.symphonyoss.symphony.pod.model.StreamType;

/**
 * StreamAttributes
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class StreamAttributes {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("crossPod")
  private Boolean crossPod = null;

  @JsonProperty("active")
  private Boolean active = null;

  @JsonProperty("streamType")
  private StreamType streamType = null;

  @JsonProperty("streamAttributes")
  private ConversationSpecificStreamAttributes streamAttributes = null;

  @JsonProperty("roomAttributes")
  private RoomSpecificStreamAttributes roomAttributes = null;

  public StreamAttributes id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The stream ID.
   * @return id
  **/
  @ApiModelProperty(value = "The stream ID.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public StreamAttributes crossPod(Boolean crossPod) {
    this.crossPod = crossPod;
    return this;
  }

   /**
   * If true, this is a cross-pod stream.
   * @return crossPod
  **/
  @ApiModelProperty(value = "If true, this is a cross-pod stream.")
  public Boolean getCrossPod() {
    return crossPod;
  }

  public void setCrossPod(Boolean crossPod) {
    this.crossPod = crossPod;
  }

  public StreamAttributes active(Boolean active) {
    this.active = active;
    return this;
  }

   /**
   * If true, this stream is active.
   * @return active
  **/
  @ApiModelProperty(value = "If true, this stream is active.")
  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public StreamAttributes streamType(StreamType streamType) {
    this.streamType = streamType;
    return this;
  }

   /**
   * Get streamType
   * @return streamType
  **/
  @ApiModelProperty(value = "")
  public StreamType getStreamType() {
    return streamType;
  }

  public void setStreamType(StreamType streamType) {
    this.streamType = streamType;
  }

  public StreamAttributes streamAttributes(ConversationSpecificStreamAttributes streamAttributes) {
    this.streamAttributes = streamAttributes;
    return this;
  }

   /**
   * Get streamAttributes
   * @return streamAttributes
  **/
  @ApiModelProperty(value = "")
  public ConversationSpecificStreamAttributes getStreamAttributes() {
    return streamAttributes;
  }

  public void setStreamAttributes(ConversationSpecificStreamAttributes streamAttributes) {
    this.streamAttributes = streamAttributes;
  }

  public StreamAttributes roomAttributes(RoomSpecificStreamAttributes roomAttributes) {
    this.roomAttributes = roomAttributes;
    return this;
  }

   /**
   * Get roomAttributes
   * @return roomAttributes
  **/
  @ApiModelProperty(value = "")
  public RoomSpecificStreamAttributes getRoomAttributes() {
    return roomAttributes;
  }

  public void setRoomAttributes(RoomSpecificStreamAttributes roomAttributes) {
    this.roomAttributes = roomAttributes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StreamAttributes streamAttributes = (StreamAttributes) o;
    return Objects.equals(this.id, streamAttributes.id) &&
        Objects.equals(this.crossPod, streamAttributes.crossPod) &&
        Objects.equals(this.active, streamAttributes.active) &&
        Objects.equals(this.streamType, streamAttributes.streamType) &&
        Objects.equals(this.streamAttributes, streamAttributes.streamAttributes) &&
        Objects.equals(this.roomAttributes, streamAttributes.roomAttributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, crossPod, active, streamType, streamAttributes, roomAttributes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StreamAttributes {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    crossPod: ").append(toIndentedString(crossPod)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    streamType: ").append(toIndentedString(streamType)).append("\n");
    sb.append("    streamAttributes: ").append(toIndentedString(streamAttributes)).append("\n");
    sb.append("    roomAttributes: ").append(toIndentedString(roomAttributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

