/*
 * Pod API
 * This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.pod.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.pod.model.UserId;

/**
 * Room Query Object. Used to specify the parameters for room search.
 */
@ApiModel(description = "Room Query Object. Used to specify the parameters for room search.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:17.901-05:00")
public class RoomSearchCriteria {
  @JsonProperty("query")
  private String query = null;

  @JsonProperty("labels")
  private List<String> labels = null;

  @JsonProperty("active")
  private Boolean active = null;

  @JsonProperty("private")
  private Boolean _private = null;

  @JsonProperty("owner")
  private UserId owner = null;

  @JsonProperty("creator")
  private UserId creator = null;

  @JsonProperty("member")
  private UserId member = null;

  /**
   * Sort algorithm to be used. Supports two values: \&quot;BASIC\&quot; (legacy algorithm) and \&quot;RELEVANCE\&quot; (enhanced algorithm). 
   */
  public enum SortOrderEnum {
    BASIC("BASIC"),
    
    RELEVANCE("RELEVANCE");

    private String value;

    SortOrderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortOrderEnum fromValue(String text) {
      for (SortOrderEnum b : SortOrderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("sortOrder")
  private SortOrderEnum sortOrder = null;

  public RoomSearchCriteria query(String query) {
    this.query = query;
    return this;
  }

   /**
   * The search query. Matches the room name and description.
   * @return query
  **/
  @ApiModelProperty(required = true, value = "The search query. Matches the room name and description.")
  public String getQuery() {
    return query;
  }

  public void setQuery(String query) {
    this.query = query;
  }

  public RoomSearchCriteria labels(List<String> labels) {
    this.labels = labels;
    return this;
  }

  public RoomSearchCriteria addLabelsItem(String labelsItem) {
    if (this.labels == null) {
      this.labels = new ArrayList<String>();
    }
    this.labels.add(labelsItem);
    return this;
  }

   /**
   * A list of room tag labels whose values will be queried.
   * @return labels
  **/
  @ApiModelProperty(value = "A list of room tag labels whose values will be queried.")
  public List<String> getLabels() {
    return labels;
  }

  public void setLabels(List<String> labels) {
    this.labels = labels;
  }

  public RoomSearchCriteria active(Boolean active) {
    this.active = active;
    return this;
  }

   /**
   * Restrict the search to active/inactive rooms. If unspecified, search all rooms.
   * @return active
  **/
  @ApiModelProperty(value = "Restrict the search to active/inactive rooms. If unspecified, search all rooms.")
  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public RoomSearchCriteria _private(Boolean _private) {
    this._private = _private;
    return this;
  }

   /**
   * Restrict the search to private rooms. If unspecified, search all rooms.
   * @return _private
  **/
  @ApiModelProperty(value = "Restrict the search to private rooms. If unspecified, search all rooms.")
  public Boolean getPrivate() {
    return _private;
  }

  public void setPrivate(Boolean _private) {
    this._private = _private;
  }

  public RoomSearchCriteria owner(UserId owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @ApiModelProperty(value = "")
  public UserId getOwner() {
    return owner;
  }

  public void setOwner(UserId owner) {
    this.owner = owner;
  }

  public RoomSearchCriteria creator(UserId creator) {
    this.creator = creator;
    return this;
  }

   /**
   * Get creator
   * @return creator
  **/
  @ApiModelProperty(value = "")
  public UserId getCreator() {
    return creator;
  }

  public void setCreator(UserId creator) {
    this.creator = creator;
  }

  public RoomSearchCriteria member(UserId member) {
    this.member = member;
    return this;
  }

   /**
   * Get member
   * @return member
  **/
  @ApiModelProperty(value = "")
  public UserId getMember() {
    return member;
  }

  public void setMember(UserId member) {
    this.member = member;
  }

  public RoomSearchCriteria sortOrder(SortOrderEnum sortOrder) {
    this.sortOrder = sortOrder;
    return this;
  }

   /**
   * Sort algorithm to be used. Supports two values: \&quot;BASIC\&quot; (legacy algorithm) and \&quot;RELEVANCE\&quot; (enhanced algorithm). 
   * @return sortOrder
  **/
  @ApiModelProperty(value = "Sort algorithm to be used. Supports two values: \"BASIC\" (legacy algorithm) and \"RELEVANCE\" (enhanced algorithm). ")
  public SortOrderEnum getSortOrder() {
    return sortOrder;
  }

  public void setSortOrder(SortOrderEnum sortOrder) {
    this.sortOrder = sortOrder;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomSearchCriteria roomSearchCriteria = (RoomSearchCriteria) o;
    return Objects.equals(this.query, roomSearchCriteria.query) &&
        Objects.equals(this.labels, roomSearchCriteria.labels) &&
        Objects.equals(this.active, roomSearchCriteria.active) &&
        Objects.equals(this._private, roomSearchCriteria._private) &&
        Objects.equals(this.owner, roomSearchCriteria.owner) &&
        Objects.equals(this.creator, roomSearchCriteria.creator) &&
        Objects.equals(this.member, roomSearchCriteria.member) &&
        Objects.equals(this.sortOrder, roomSearchCriteria.sortOrder);
  }

  @Override
  public int hashCode() {
    return Objects.hash(query, labels, active, _private, owner, creator, member, sortOrder);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomSearchCriteria {\n");
    
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    _private: ").append(toIndentedString(_private)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    member: ").append(toIndentedString(member)).append("\n");
    sb.append("    sortOrder: ").append(toIndentedString(sortOrder)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

